/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.extractor;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.extractor.TextExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeTextExtractor
implements TextExtractor {
    private static final Logger logger = LoggerFactory.getLogger((Class)CompositeTextExtractor.class);
    private final Map extractors = new HashMap();

    public void addTextExtractor(TextExtractor extractor) {
        String[] types = extractor.getContentTypes();
        for (int i = 0; i < types.length; ++i) {
            this.extractors.put(types[i], extractor);
        }
    }

    public String[] getContentTypes() {
        Set types = this.extractors.keySet();
        return types.toArray(new String[types.size()]);
    }

    public Reader extractText(InputStream stream, String type, String encoding) throws IOException {
        TextExtractor extractor = (TextExtractor)this.extractors.get(type);
        if (extractor != null) {
            try {
                return extractor.extractText(stream, type, encoding);
            }
            catch (RuntimeException e) {
                logger.warn("Failed to extract text content", (Throwable)e);
                return new StringReader("");
            }
        }
        stream.close();
        logger.info("No extractor available for content type {}", (Object)type);
        return new StringReader("");
    }
}

