/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository.sql;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.sql.ConditionOnColumn;
import com.xebialabs.deployit.core.sql.QueryBuilder;
import com.xebialabs.deployit.core.sql.SchemaInfo;
import com.xebialabs.deployit.core.sql.SelectBuilder;
import com.xebialabs.deployit.core.sql.Selectable;
import com.xebialabs.deployit.core.sql.SqlCondition;
import com.xebialabs.deployit.core.sql.SqlCondition$;
import com.xebialabs.deployit.core.sql.SqlFunction$;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.sql.StringMatchCondition;
import com.xebialabs.deployit.repository.sql.base.package$;
import com.xebialabs.deployit.sql.base.schema.CIS$;
import com.xebialabs.deployit.sql.base.schema.CI_PROPERTIES$;
import java.io.Serializable;
import java.util.Map;
import org.joda.time.DateTime;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;

public final class CiConditions$ {
    public static final CiConditions$ MODULE$ = new CiConditions$();

    public SelectBuilder idToPK(String id, SchemaInfo schemaInfo) {
        return (SelectBuilder)new SelectBuilder(CIS$.MODULE$.tableName(), schemaInfo).select((Selectable)CIS$.MODULE$.ID()).where((SqlCondition)SqlCondition$.MODULE$.equals((Selectable)CIS$.MODULE$.path(), package$.MODULE$.idToPath(id)));
    }

    public SqlCondition ofType(Type ciType, SchemaInfo schemaInfo) {
        Type type = ciType;
        List ciTypes = CollectionConverters$.MODULE$.CollectionHasAsScala(DescriptorRegistry.getSubtypes((Type)ciType)).asScala().toList().$colon$colon((Object)type).map((Function1 & Serializable)x$1 -> x$1.toString());
        List ciTypesConditionList = ciTypes.grouped(schemaInfo.sqlDialect().inClauseLimit()).map((Function1 & Serializable)s -> SqlCondition$.MODULE$.in((Selectable)CIS$.MODULE$.ci_type(), (Iterable)s)).toList();
        return ciTypesConditionList.size() > 1 ? SqlCondition$.MODULE$.or((Seq)ciTypesConditionList) : (SqlCondition)ciTypesConditionList.apply(0);
    }

    public SqlCondition childOf(String parent, SchemaInfo schemaInfo) {
        return parent.equals("/") ? SqlCondition$.MODULE$.equalsNull((Selectable)CIS$.MODULE$.parent_id()) : SqlCondition$.MODULE$.subselect((Selectable)CIS$.MODULE$.parent_id(), (QueryBuilder)new SelectBuilder(CIS$.MODULE$.tableName(), schemaInfo).select((Selectable)CIS$.MODULE$.ID()).where((SqlCondition)SqlCondition$.MODULE$.equals((Selectable)CIS$.MODULE$.path(), package$.MODULE$.idToPath(parent))));
    }

    public SqlCondition descendantOf(String ancestor) {
        return SqlCondition$.MODULE$.like((Selectable)CIS$.MODULE$.path(), new StringBuilder(2).append(package$.MODULE$.idToPath(ancestor)).append("/%").toString());
    }

    public SqlCondition nameMatch(String value, boolean exact) {
        return new StringMatchCondition(CIS$.MODULE$.name(), value, exact);
    }

    public SqlCondition internalIdMatch(int internalId) {
        return SqlCondition$.MODULE$.equals((Selectable)CIS$.MODULE$.ID(), (Number)Predef$.MODULE$.int2Integer(internalId));
    }

    public SqlCondition referenceIdMatch(String referenceId) {
        return SqlCondition$.MODULE$.equals((Selectable)CIS$.MODULE$.reference_id(), referenceId);
    }

    public SqlCondition idMatch(String value, boolean exact) {
        return new StringMatchCondition(CIS$.MODULE$.path(), value, exact);
    }

    public SqlCondition modifiedBefore(DateTime time) {
        return SqlCondition$.MODULE$.before((Selectable)CIS$.MODULE$.modified_at(), time);
    }

    public SqlCondition modifiedAfter(DateTime time) {
        return SqlCondition$.MODULE$.after((Selectable)CIS$.MODULE$.modified_at(), time);
    }

    public SqlCondition hasProperties(Map<String, String> properties, SchemaInfo schemaInfo) {
        return SqlCondition$.MODULE$.subselect((Selectable)CIS$.MODULE$.ID(), (QueryBuilder)CollectionConverters$.MODULE$.MapHasAsScala(properties).asScala().foldLeft((Object)new SelectBuilder(CI_PROPERTIES$.MODULE$.tableName(), schemaInfo).select((Selectable)CI_PROPERTIES$.MODULE$.ci_id()), (Function2 & Serializable)(selectBuilder, entry) -> {
            MODULE$.validateEscapeSearchString((String)entry._2());
            return (SelectBuilder)selectBuilder.where((SqlCondition)SqlCondition$.MODULE$.and((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConditionOnColumn[]{SqlCondition$.MODULE$.equals((Selectable)CI_PROPERTIES$.MODULE$.name(), (String)entry._1()), (ConditionOnColumn)Try$.MODULE$.apply((Function0 & Serializable)() -> SqlCondition$.MODULE$.equals((Selectable)CI_PROPERTIES$.MODULE$.boolean_value(), StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString((String)entry._2())))).getOrElse((Function0 & Serializable)() -> SqlCondition$.MODULE$.like((Selectable)SqlFunction$.MODULE$.lower().apply((Object)CI_PROPERTIES$.MODULE$.string_value()), ((String)entry._2()).toLowerCase()))}))));
        }));
    }

    public void validateEscapeSearchString(String str) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), str.length()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> Checks.checkArgument((!CiConditions$.isBackslash$1(i, str) || CiConditions$.nextIsEscape$1(i, str) ? 1 : 0) != 0, (String)"Invalid search string '%s'. Escape character '\\' must be followed by another escape character, '_', or '%%'. It cannot be followed by any other character or be at the end of the pattern.", (Object[])new Object[]{str}));
    }

    private static final boolean isBackslash$1(int idx, String str$1) {
        return StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(str$1), idx) == '\\';
    }

    private static final boolean nextIsEscape$1(int idx, String str$1) {
        return idx < str$1.length() - 1 && (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(str$1), idx + 1) == '_' || StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(str$1), idx + 1) == '%');
    }

    private CiConditions$() {
    }
}

