/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.permissions.service.impl;

import ai.digital.deploy.permissions.exception.RoleNameNotFoundException;
import ai.digital.deploy.permissions.jpa.ReadOnlyTransactionalPermissionService;
import ai.digital.deploy.permissions.jpa.TransactionalPermissionService;
import ai.digital.deploy.permissions.model.ReferencedPermission;
import ai.digital.deploy.permissions.model.ReferencedPermission$;
import ai.digital.deploy.permissions.model.Role;
import ai.digital.deploy.permissions.model.view.RoleReferencedPermissionView;
import ai.digital.deploy.permissions.repository.ReferencedPermissionRepository;
import ai.digital.deploy.permissions.repository.RoleReferencedPermissionViewRepository;
import ai.digital.deploy.permissions.service.ReferencedPermissionService;
import ai.digital.deploy.permissions.service.RolePrincipalService;
import ai.digital.deploy.permissions.service.RoleService;
import ai.digital.deploy.permissions.service.impl.package$;
import java.io.Serializable;
import java.util.UUID;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Service
@TransactionalPermissionService
@ScalaSignature(bytes="\u0006\u0005\t%a\u0001\u0002\r\u001a\u0001\u0019B\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\tq\u0001\u0011\t\u0011)A\u0005s!AA\b\u0001B\u0001B\u0003%Q\b\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003B\u0011\u0015!\u0005\u0001\"\u0001F\u0011\u0015a\u0005\u0001\"\u0011N\u0011\u0015a\b\u0001\"\u0011~\u0011\u001d\t\u0019\u0001\u0001C!\u0003\u000bAq!!\u0005\u0001\t\u0003\n\u0019\u0002C\u0004\u0002\u0018\u0001!\t%!\u0007\t\u000f\u0005m\u0001\u0001\"\u0011\u0002\u001e!9\u00111\u0004\u0001\u0005B\u0005=\u0002bBA\u000e\u0001\u0011\u0005\u0013q\u0007\u0005\b\u00037\u0001A\u0011IA \u0011\u001d\tY\b\u0001C!\u0003{Bq!!\"\u0001\t\u0003\n9\tC\u0004\u0002\u0016\u0002!I!a&\t\u000f\u0005m\u0005\u0001\"\u0011\u0002\u001e\"9\u0011Q\u0016\u0001\u0005B\u0005=\u0006bBA^\u0001\u0011\u0005\u0013Q\u0018\u0005\b\u0003\u000b\u0004A\u0011IAd\u0011\u001d\t\t\u000e\u0001C!\u0003'Dq!!5\u0001\t\u0003\n)OA\u0010SK\u001a,'/\u001a8dK\u0012\u0004VM]7jgNLwN\\*feZL7-Z%na2T!AG\u000e\u0002\t%l\u0007\u000f\u001c\u0006\u00039u\tqa]3sm&\u001cWM\u0003\u0002\u001f?\u0005Y\u0001/\u001a:nSN\u001c\u0018n\u001c8t\u0015\t\u0001\u0013%\u0001\u0004eKBdw.\u001f\u0006\u0003E\r\nq\u0001Z5hSR\fGNC\u0001%\u0003\t\t\u0017n\u0001\u0001\u0014\u0007\u00019S\u0006\u0005\u0002)W5\t\u0011FC\u0001+\u0003\u0015\u00198-\u00197b\u0013\ta\u0013F\u0001\u0004B]f\u0014VM\u001a\t\u0003]=j\u0011aG\u0005\u0003am\u00111DU3gKJ,gnY3e!\u0016\u0014X.[:tS>t7+\u001a:wS\u000e,\u0017A\b:fM\u0016\u0014XM\\2fIB+'/\\5tg&|gNU3q_NLGo\u001c:z!\t\u0019d'D\u00015\u0015\t)T$\u0001\u0006sKB|7/\u001b;pefL!a\u000e\u001b\u0003=I+g-\u001a:f]\u000e,G\rU3s[&\u001c8/[8o%\u0016\u0004xn]5u_JL\u0018a\u0003:pY\u0016\u001cVM\u001d<jG\u0016\u0004\"A\f\u001e\n\u0005mZ\"a\u0003*pY\u0016\u001cVM\u001d<jG\u0016\fAC]8mKB\u0013\u0018N\\2ja\u0006d7+\u001a:wS\u000e,\u0007C\u0001\u0018?\u0013\ty4D\u0001\u000bS_2,\u0007K]5oG&\u0004\u0018\r\\*feZL7-Z\u0001'e>dWMU3gKJ,gnY3e!\u0016\u0014X.[:tS>tg+[3x%\u0016\u0004xn]5u_JL\bCA\u001aC\u0013\t\u0019EG\u0001\u0014S_2,'+\u001a4fe\u0016t7-\u001a3QKJl\u0017n]:j_:4\u0016.Z<SKB|7/\u001b;pef\fa\u0001P5oSRtD#\u0002$I\u0013*[\u0005CA$\u0001\u001b\u0005I\u0002\"B\u0019\u0006\u0001\u0004\u0011\u0004\"\u0002\u001d\u0006\u0001\u0004I\u0004\"\u0002\u001f\u0006\u0001\u0004i\u0004\"\u0002!\u0006\u0001\u0004\t\u0015aA1eIR!aJ\u001a9{!\u0011As*U,\n\u0005AK#A\u0002+va2,'\u0007\u0005\u0002S+6\t1K\u0003\u0002U;\u0005)Qn\u001c3fY&\u0011ak\u0015\u0002\u0005%>dW\rE\u0002YA\u000et!!\u00170\u000f\u0005ikV\"A.\u000b\u0005q+\u0013A\u0002\u001fs_>$h(C\u0001+\u0013\ty\u0016&A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0005\u0014'\u0001\u0002'jgRT!aX\u0015\u0011\u0005I#\u0017BA3T\u0005Q\u0011VMZ3sK:\u001cW\r\u001a)fe6L7o]5p]\")qM\u0002a\u0001Q\u0006Y!/\u001a4fe\u0016t7-Z%e!\tIg.D\u0001k\u0015\tYG.\u0001\u0003vi&d'\"A7\u0002\t)\fg/Y\u0005\u0003_*\u0014A!V+J\t\")\u0011O\u0002a\u0001e\u0006A!o\u001c7f\u001d\u0006lW\r\u0005\u0002to:\u0011A/\u001e\t\u00035&J!A^\u0015\u0002\rA\u0013X\rZ3g\u0013\tA\u0018P\u0001\u0004TiJLgn\u001a\u0006\u0003m&BQA\b\u0004A\u0002m\u00042\u0001\u00171s\u0003\u0019\u0011X-\\8wKR)aJ`@\u0002\u0002!)qm\u0002a\u0001Q\")\u0011o\u0002a\u0001e\")ad\u0002a\u0001w\u0006i!/Z7pm\u00164uN\u001d*pY\u0016$B!a\u0002\u0002\u000eA\u0019\u0001&!\u0003\n\u0007\u0005-\u0011F\u0001\u0003V]&$\bBBA\b\u0011\u0001\u0007\u0011+\u0001\u0003s_2,\u0017A\u0005:f[>4XMR8s%\u00164WM]3oG\u0016$B!a\u0002\u0002\u0016!)q-\u0003a\u0001Q\u0006I!/Z7pm\u0016\fE\u000e\u001c\u000b\u0003\u0003\u000f\tAA]3bIR\u0019q+a\b\t\u000bE\\\u0001\u0019\u0001:)\u0007-\t\u0019\u0003\u0005\u0003\u0002&\u0005-RBAA\u0014\u0015\r\tI#H\u0001\u0004UB\f\u0017\u0002BA\u0017\u0003O\u0011aEU3bI>sG.\u001f+sC:\u001c\u0018m\u0019;j_:\fG\u000eU3s[&\u001c8/[8o'\u0016\u0014h/[2f)\r9\u0016\u0011\u0007\u0005\u0007\u0003ga\u0001\u0019A>\u0002\u0013I|G.\u001a(b[\u0016\u001c\bf\u0001\u0007\u0002$Q)q+!\u000f\u0002<!)q-\u0004a\u0001Q\")\u0011/\u0004a\u0001e\"\u001aQ\"a\t\u0015\u0011\u0005\u0005\u0013\u0011NA6\u0003_\u0002b\u0001K(\u0002D\u0005m\u0003#BA#\u0003/\nVBAA$\u0015\u0011\tI%a\u0013\u0002\r\u0011|W.Y5o\u0015\u0011\ti%a\u0014\u0002\t\u0011\fG/\u0019\u0006\u0005\u0003#\n\u0019&A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\t\t)&A\u0002pe\u001eLA!!\u0017\u0002H\t!\u0001+Y4f!\u0011A\u0006-!\u0018\u0011\t\u0005}\u0013QM\u0007\u0003\u0003CR1!a\u0019T\u0003\u00111\u0018.Z<\n\t\u0005\u001d\u0014\u0011\r\u0002\u001d%>dWMU3gKJ,gnY3e!\u0016\u0014X.[:tS>tg+[3x\u0011\u00159g\u00021\u0001i\u0011\u0019\tiG\u0004a\u0001e\u0006Y!o\u001c7f!\u0006$H/\u001a:o\u0011\u001d\t\tH\u0004a\u0001\u0003g\n\u0001\u0002]1hK\u0006\u0014G.\u001a\t\u0005\u0003\u000b\n)(\u0003\u0003\u0002x\u0005\u001d#\u0001\u0003)bO\u0016\f'\r\\3)\u00079\t\u0019#\u0001\nsK\u0006$gi\u001c:S_2,\u0007+\u0019;uKJtG#B,\u0002\u0000\u0005\u0005\u0005\"B4\u0010\u0001\u0004A\u0007BBA7\u001f\u0001\u0007!\u000fK\u0002\u0010\u0003G\tA!\u001a3jiRIa*!#\u0002\f\u00065\u0015\u0011\u0013\u0005\u0006OB\u0001\r\u0001\u001b\u0005\u0006cB\u0001\rA\u001d\u0005\u0007\u0003\u001f\u0003\u0002\u0019A>\u0002!A,'/\\5tg&|gn\u001d+p\u0003\u0012$\u0007BBAJ!\u0001\u000710\u0001\nqKJl\u0017n]:j_:$v\u000eR3mKR,\u0017aB4fiJ{G.\u001a\u000b\u0004#\u0006e\u0005\"B9\u0012\u0001\u0004\u0011\u0018\u0001F4fiJ+g-\u001a:f]\u000e,7OR8s%>dW\r\u0006\u0004\u0002 \u0006\u0015\u0016\u0011\u0016\t\u0005g\u0006\u0005\u0006.C\u0002\u0002$f\u00141aU3u\u0011\u0019\t9K\u0005a\u0001Q\u00061!o\u001c7f\u0013\u0012DQA\b\nA\u0002mD3AEA\u0012\u0003U9W\r\u001e*fM\u0016\u0014XM\\2fg\u001a{'OU8mKN$b!a(\u00022\u0006]\u0006bBAZ'\u0001\u0007\u0011QW\u0001\be>dW-\u00133t!\rA\u0006\r\u001b\u0005\u0006=M\u0001\ra\u001f\u0015\u0004'\u0005\r\u0012\u0001G4fiJ+g-\u001a:f]\u000e,7OR8s%>dWMT1nKR1\u0011qTA`\u0003\u0003DQ!\u001d\u000bA\u0002IDQA\b\u000bA\u0002mD3\u0001FA\u0012\u0003u9W\r\u001e*fM\u0016\u0014XM\\2fg\u001a{'\u000f\u0015:j]\u000eL\u0007/\u00197OC6,GCBAP\u0003\u0013\fi\r\u0003\u0004\u0002LV\u0001\rA]\u0001\u000eaJLgnY5qC2t\u0015-\\3\t\u000by)\u0002\u0019A>)\u0007U\t\u0019#A\bdQ\u0016\u001c7\u000eU3s[&\u001c8/[8o)!\t).a7\u0002^\u0006}\u0007c\u0001\u0015\u0002X&\u0019\u0011\u0011\\\u0015\u0003\u000f\t{w\u000e\\3b]\")qM\u0006a\u0001Q\")aD\u0006a\u0001w\"1\u0011\u0011\u001d\fA\u0002m\f\u0001\"\u00197m%>dWm\u001d\u0015\u0004-\u0005\rBCCAk\u0003O\fI/a;\u0002n\")qm\u0006a\u0001Q\")ad\u0006a\u0001w\"1\u0011\u0011]\fA\u0002mDa!a<\u0018\u0001\u0004Y\u0018A\u00039sS:\u001c\u0017\u000e]1mg\"\u001aq#a\t)\u0007\u0001\t)\u0010\u0005\u0003\u0002&\u0005]\u0018\u0002BA}\u0003O\u0011a\u0004\u0016:b]N\f7\r^5p]\u0006d\u0007+\u001a:nSN\u001c\u0018n\u001c8TKJ4\u0018nY3)\u0007\u0001\ti\u0010\u0005\u0003\u0002\u0000\n\u0015QB\u0001B\u0001\u0015\u0011\u0011\u0019!a\u0014\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0003\b\t\u0005!aB*feZL7-\u001a")
public class ReferencedPermissionServiceImpl
implements ReferencedPermissionService {
    private final ReferencedPermissionRepository referencedPermissionRepository;
    private final RoleService roleService;
    private final RolePrincipalService rolePrincipalService;
    private final RoleReferencedPermissionViewRepository roleReferencedPermissionViewRepository;

    @Override
    public Tuple2<Role, List<ReferencedPermission>> add(UUID referenceId, String roleName, List<String> permissions) {
        Role role = this.getRole(roleName);
        List<ReferencedPermission> savedPermissions = this.referencedPermissionRepository.get(referenceId, role);
        Tuple2 tuple2 = savedPermissions.partition((Function1 & Serializable)rp -> BoxesRunTime.boxToBoolean((boolean)permissions.contains((Object)rp.permissionName())));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List exists = (List)tuple2._1();
        List toDelete = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)exists, (Object)toDelete);
        Tuple2 tuple23 = tuple22;
        List exists2 = (List)tuple23._1();
        List toDelete2 = (List)tuple23._2();
        List toSave = permissions.filterNot((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)ReferencedPermissionServiceImpl.$anonfun$add$2(exists2, p))).map((Function1 & Serializable)p -> ReferencedPermission$.MODULE$.apply(role, (String)p, referenceId));
        this.referencedPermissionRepository.remove((List<ReferencedPermission>)toDelete2);
        return new Tuple2((Object)role, exists2.$plus$plus(this.referencedPermissionRepository.add((List<ReferencedPermission>)toSave)));
    }

    @Override
    public Tuple2<Role, List<ReferencedPermission>> remove(UUID referenceId, String roleName, List<String> permissions) {
        Role role = this.getRole(roleName);
        Tuple2 tuple2 = this.referencedPermissionRepository.get(referenceId, role).partition((Function1 & Serializable)rp -> BoxesRunTime.boxToBoolean((boolean)permissions.contains((Object)rp.permissionName())));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List toDelete = (List)tuple2._1();
        List rp2 = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)toDelete, (Object)rp2);
        Tuple2 tuple23 = tuple22;
        List toDelete2 = (List)tuple23._1();
        List rp3 = (List)tuple23._2();
        this.referencedPermissionRepository.remove((List<ReferencedPermission>)toDelete2);
        return new Tuple2((Object)role, (Object)rp3);
    }

    @Override
    public void removeForRole(Role role) {
        this.referencedPermissionRepository.removeForRole(role);
    }

    @Override
    public void removeForReference(UUID referenceId) {
        this.referencedPermissionRepository.removeForReference(referenceId);
    }

    @Override
    public void removeAll() {
        this.referencedPermissionRepository.removeAll();
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public List<ReferencedPermission> read(String roleName) {
        this.roleService.readOrThrowException(roleName);
        return this.referencedPermissionRepository.get(roleName);
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public List<ReferencedPermission> read(List<String> roleNames) {
        this.roleService.read(roleNames);
        return this.referencedPermissionRepository.get(roleNames);
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public List<ReferencedPermission> read(UUID referenceId, String roleName) {
        this.roleService.readOrThrowException(roleName);
        return this.referencedPermissionRepository.get(referenceId, roleName);
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public Tuple2<Page<Role>, List<RoleReferencedPermissionView>> read(UUID referenceId, String rolePattern, Pageable pageable) {
        Page<Role> rolePage = this.roleService.read(rolePattern, pageable);
        List roleIds = CollectionConverters$.MODULE$.ListHasAsScala(rolePage.getContent()).asScala().toList().map((Function1 & Serializable)x$4 -> x$4.id());
        List<RoleReferencedPermissionView> views = this.roleReferencedPermissionViewRepository.get((List<UUID>)roleIds, referenceId);
        return new Tuple2(rolePage, views);
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public List<ReferencedPermission> readForRolePattern(UUID referenceId, String rolePattern) {
        return (List)package$.MODULE$.wrapNullablePatternSearch(rolePattern, (Function1 & Serializable)p -> $this.referencedPermissionRepository.listByRoleNamePattern((String)p, referenceId), (Function0 & Serializable)() -> $this.referencedPermissionRepository.get(referenceId));
    }

    @Override
    public Tuple2<Role, List<ReferencedPermission>> edit(UUID referenceId, String roleName, List<String> permissionsToAdd, List<String> permissionToDelete) {
        Role role = this.getRole(roleName);
        List<ReferencedPermission> permissions = this.referencedPermissionRepository.get(referenceId, role);
        Tuple2 tuple2 = permissions.partition((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)permissionToDelete.contains((Object)p.permissionName())));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List toDelete = (List)tuple2._1();
        List exists = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)toDelete, (Object)exists);
        Tuple2 tuple23 = tuple22;
        List toDelete2 = (List)tuple23._1();
        List exists2 = (List)tuple23._2();
        this.referencedPermissionRepository.remove((List<ReferencedPermission>)toDelete2);
        List toAdd = permissionsToAdd.map((Function1 & Serializable)p -> ReferencedPermission$.MODULE$.apply(role, (String)p, referenceId));
        return new Tuple2((Object)role, exists2.$plus$plus(this.referencedPermissionRepository.add((List<ReferencedPermission>)toAdd)));
    }

    /*
     * WARNING - void declaration
     */
    private Role getRole(String roleName) {
        void var2_2;
        Role role = (Role)this.roleService.read(roleName).getOrElse((Function0 & Serializable)() -> {
            throw new RoleNameNotFoundException(roleName);
        });
        return var2_2;
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public Set<UUID> getReferencesForRole(UUID roleId, List<String> permissions) {
        return this.referencedPermissionRepository.listByRoleAndPermissions(roleId, permissions).map((Function1 & Serializable)x$6 -> x$6.reference()).toSet();
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public Set<UUID> getReferencesForRoles(List<UUID> roleIds, List<String> permissions) {
        return this.referencedPermissionRepository.listByRolesAndPermissions(roleIds, permissions).map((Function1 & Serializable)x$7 -> x$7.reference()).toSet();
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public Set<UUID> getReferencesForRoleName(String roleName, List<String> permissions) {
        return this.referencedPermissionRepository.listByRoleNameAndPermissions(roleName, permissions).map((Function1 & Serializable)x$8 -> x$8.reference()).toSet();
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public Set<UUID> getReferencesForPrincipalName(String principalName, List<String> permissions) {
        return this.referencedPermissionRepository.listByPrincipalNameAndPermissions(principalName, permissions).map((Function1 & Serializable)x$9 -> x$9.reference()).toSet();
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public boolean checkPermission(UUID referenceId, List<String> permissions, List<String> allRoles) {
        return this.referencedPermissionRepository.getByPermissionsAndRoles(referenceId, permissions, (Set<String>)allRoles.toSet()).nonEmpty();
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public boolean checkPermission(UUID referenceId, List<String> permissions, List<String> allRoles, List<String> principals) {
        Set principalRoleIds = this.rolePrincipalService.readAll(principals).map((Function1 & Serializable)x$10 -> x$10.role().name()).toSet();
        return this.referencedPermissionRepository.getByPermissionsAndRoles(referenceId, permissions, (Set<String>)((Set)principalRoleIds.$plus$plus(allRoles))).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$add$2(List exists$1, String p) {
        return exists$1.map((Function1 & Serializable)x$2 -> x$2.permissionName()).contains((Object)p);
    }

    public ReferencedPermissionServiceImpl(ReferencedPermissionRepository referencedPermissionRepository, RoleService roleService, RolePrincipalService rolePrincipalService, RoleReferencedPermissionViewRepository roleReferencedPermissionViewRepository) {
        this.referencedPermissionRepository = referencedPermissionRepository;
        this.roleService = roleService;
        this.rolePrincipalService = rolePrincipalService;
        this.roleReferencedPermissionViewRepository = roleReferencedPermissionViewRepository;
    }
}

