/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.validation;

import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.validation.ApplicableTo;
import com.xebialabs.deployit.plugin.api.validation.PatternValidator;
import com.xebialabs.deployit.plugin.api.validation.Rule;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collection;
import java.util.regex.Pattern;

@Retention(value=RetentionPolicy.RUNTIME)
@Rule(clazz=Validator.class, type="regex")
@ApplicableTo(value={PropertyKind.STRING, PropertyKind.LIST_OF_STRING, PropertyKind.SET_OF_STRING})
@Target(value={ElementType.FIELD})
public @interface Regex {
    public static final String DEFAULT_MESSAGE = "Value '%s' did not conform to pattern %s";

    public String pattern();

    public String message() default "Value '%s' did not conform to pattern %s";

    public static class Validator
    implements PatternValidator<Object> {
        private String pattern;
        private String message = "Value '%s' did not conform to pattern %s";

        @Override
        public void validate(Object value, ValidationContext context) {
            if (value instanceof String) {
                this.validateString((String)value, context);
            }
            if (value instanceof Collection) {
                Collection c = (Collection)value;
                for (String s : c) {
                    this.validateString(s, context);
                }
            }
        }

        private void validateString(String s, ValidationContext context) {
            if (!Pattern.compile(this.pattern).matcher(s).matches()) {
                context.error(this.message, s, this.pattern);
            }
        }

        @Override
        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}

