/*
 * Decompiled with CFR 0.152.
 */
package org.prevayler.implementation.clock;

import java.util.Date;
import org.prevayler.Clock;
import org.prevayler.implementation.clock.BrokenClock;

public class PausableClock
implements Clock {
    private final Clock _realClock;
    private final BrokenClock _brokenClock = new BrokenClock();
    private Clock _activeClock;

    public PausableClock(Clock realClock) {
        this._realClock = realClock;
        this.resume();
    }

    @Override
    public synchronized Date time() {
        return this._activeClock.time();
    }

    public synchronized void pause() {
        this.advanceTo(this._realClock.time());
        this._activeClock = this._brokenClock;
    }

    public void advanceTo(Date time) {
        this._brokenClock.advanceTo(time);
    }

    public synchronized void resume() {
        this._activeClock = this._realClock;
    }

    public Date realTime() {
        return this._realClock.time();
    }
}

