/*
 * Decompiled with CFR 0.152.
 */
package liquibase.logging.core;

import java.util.logging.Level;
import liquibase.configuration.AbstractConfigurationContainer;
import liquibase.exception.UnexpectedLiquibaseException;

public class DefaultLoggerConfiguration
extends AbstractConfigurationContainer {
    public static final String LOG_LEVEL = "level";

    public DefaultLoggerConfiguration() {
        super("liquibase.defaultlogger");
        this.getContainer().addProperty(LOG_LEVEL, String.class).setDescription("Logging level").setDefaultValue("INFO");
    }

    public String getLogLevelName() {
        return this.getContainer().getValue(LOG_LEVEL, String.class);
    }

    public Level getLogLevel() {
        String logLevel = this.getLogLevelName();
        if ("fine".equalsIgnoreCase(logLevel) || "debug".equalsIgnoreCase(logLevel)) {
            return Level.FINE;
        }
        if ("info".equalsIgnoreCase(logLevel)) {
            return Level.INFO;
        }
        if ("warning".equalsIgnoreCase(logLevel)) {
            return Level.WARNING;
        }
        if ("error".equalsIgnoreCase(logLevel) || "severe".equalsIgnoreCase(logLevel)) {
            return Level.SEVERE;
        }
        if ("off".equalsIgnoreCase(logLevel)) {
            return Level.OFF;
        }
        throw new UnexpectedLiquibaseException("Unknown log level: " + logLevel + ".  Valid levels are: debug, info, warning, error, off");
    }

    public DefaultLoggerConfiguration setLogLevel(String name) {
        this.getContainer().setValue(LOG_LEVEL, name);
        return this;
    }
}

