/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.xebialabs.deployit.booter.local.ClassBasedLocalDescriptor;
import com.xebialabs.deployit.booter.local.GenerateDeployableTypeDefinition;
import com.xebialabs.deployit.booter.local.GeneratedParameterTypeDefinition;
import com.xebialabs.deployit.booter.local.LocalDescriptor;
import com.xebialabs.deployit.booter.local.LocalDescriptorRegistry;
import com.xebialabs.deployit.booter.local.SyntheticBasedTypeDefinition;
import com.xebialabs.deployit.booter.local.TypeDefinition;
import com.xebialabs.deployit.booter.local.utils.ReflectionUtils;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.overthere.util.OverthereUtils;
import com.xebialabs.xlplatform.synthetic.BaseTypeSpecification;
import com.xebialabs.xlplatform.synthetic.MethodSpecification;
import com.xebialabs.xlplatform.synthetic.TypeModificationSpecification;
import com.xebialabs.xlplatform.synthetic.TypeSpecification;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeDefinitions {
    private final Map<Type, TypeDefinition> typeDefs = new HashMap<Type, TypeDefinition>();
    private LocalDescriptorRegistry registry;
    private static final Logger logger = LoggerFactory.getLogger(TypeDefinitions.class);

    public TypeDefinitions(LocalDescriptorRegistry registry) {
        this.registry = registry;
    }

    public void addTypeDef(TypeDefinition typeDef) {
        OverthereUtils.checkState((!this.typeDefs.containsKey(typeDef.type) ? 1 : 0) != 0, (String)"Trying to register duplicate definition for type [%s]. Existing: [%s], duplicate: [%s]", (Object[])new Object[]{typeDef.type, this.typeDefs.get(typeDef.type), typeDef});
        this.typeDefs.put(typeDef.type, typeDef);
    }

    public Collection<TypeDefinition> getDefinitions() {
        return new ArrayList<TypeDefinition>(this.typeDefs.values());
    }

    private TypeDefinition getDefinition(Type type) {
        return (TypeDefinition)OverthereUtils.checkNotNull((Object)this.typeDefs.get(type), (String)"Could not find a type definition associated with type [%s]", (Object[])new Object[]{type});
    }

    void defineType(Class clazz) {
        ClassBasedTypeDefinition typeDef = new ClassBasedTypeDefinition(clazz);
        this.addTypeDef(typeDef);
        logger.debug("Found: {}", (Object)typeDef);
    }

    void defineType(TypeSpecification typeSpec) {
        this.addTypeDef(new SyntheticBasedTypeDefinition(typeSpec));
        if (typeSpec.hasGenerateDeployable()) {
            this.addTypeDef(new GenerateDeployableTypeDefinition(typeSpec.getType(), typeSpec.getGenerateDeployable()));
        }
        this.findAllGeneratedParameterTypes(typeSpec);
    }

    void modifyType(TypeModificationSpecification typeModification) {
        OverthereUtils.checkState((boolean)this.typeDefs.containsKey(typeModification.getType()), (String)"Detected type-modification for non-existing type [%s]", (Object[])new Object[]{typeModification.getType()});
        this.typeDefs.get(typeModification.getType()).addTypeModification(typeModification);
        this.findAllGeneratedParameterTypes(typeModification);
        logger.debug("Found: {}", (Object)typeModification);
    }

    private void findAllGeneratedParameterTypes(BaseTypeSpecification type) {
        for (MethodSpecification method : type.getMethods()) {
            if (method.getParameters().isEmpty()) continue;
            this.defineGeneratedParameterType(method, type);
        }
    }

    void defineGeneratedParameterType(MethodSpecification methodDef, BaseTypeSpecification type) {
        GeneratedParameterTypeDefinition typeDef = new GeneratedParameterTypeDefinition(type, methodDef);
        this.addTypeDef(typeDef);
        logger.debug("Found: {}", (Object)typeDef);
    }

    public void registerTypes() {
        this.getDefinitions().forEach(definition -> this.registerAsSubtype((TypeDefinition)definition, definition.type));
        this.getDefinitions().forEach(this::register);
    }

    private void registerAsSubtype(TypeDefinition definition, Type type) {
        if (definition.superType != null) {
            this.registry.registerSubtype(definition.superType, type);
            this.registerAsSubtype(this.getDefinition(definition.superType), type);
        }
        for (Type anInterface : definition.getInterfaces()) {
            this.registry.registerSubtype(anInterface, type);
        }
    }

    private void register(TypeDefinition definition) {
        if (DescriptorRegistry.exists((Type)definition.type)) {
            return;
        }
        if (definition.superType != null && !DescriptorRegistry.exists((Type)definition.superType)) {
            this.register(this.getDefinition(definition.superType));
        }
        for (Type anInterface : definition.getInterfaces()) {
            if (LocalDescriptorRegistry.exists((Type)anInterface)) continue;
            this.register(this.getDefinition(anInterface));
        }
        if (definition.getOwner() != null && !DescriptorRegistry.exists((Type)definition.getOwner())) {
            this.register(this.getDefinition(definition.getOwner()));
        }
        LocalDescriptor descriptor = definition.createDescriptor(this);
        this.registry.register(descriptor);
        definition.applyTypeModifications(descriptor);
    }

    private static boolean isClassACi(Class<?> clazz) {
        return clazz != null && ConfigurationItem.class.isAssignableFrom(clazz);
    }

    private static Type type(Class<?> clazz) {
        if (TypeDefinitions.isClassACi(clazz)) {
            return Type.valueOf(clazz);
        }
        return null;
    }

    public static Type generatedParameterType(Type type, String name) {
        return Type.valueOf((String)(type.toString() + "_" + name));
    }

    class ClassBasedTypeDefinition
    extends TypeDefinition {
        private Class<? extends ConfigurationItem> clazz;

        public ClassBasedTypeDefinition(Class<? extends ConfigurationItem> ci) {
            this.type = TypeDefinitions.type(ci);
            this.superType = TypeDefinitions.type(ci.getSuperclass());
            this.interfaces = ReflectionUtils.getAllInterfaces(ci).stream().filter(x$0 -> TypeDefinitions.isClassACi(x$0)).map(Type::valueOf).collect(Collectors.toList());
            this.clazz = ci;
        }

        @Override
        protected LocalDescriptor createDescriptor(TypeDefinitions typeDefinitions) {
            return new ClassBasedLocalDescriptor(this.clazz);
        }
    }
}

