/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.postoffice.impl;

import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.postoffice.BindingType;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.server.Bindable;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.jboss.logging.Logger;

public class LocalQueueBinding
implements QueueBinding {
    private static final Logger logger = Logger.getLogger(LocalQueueBinding.class);
    private final SimpleString address;
    private final Queue queue;
    private final SimpleString clusterName;
    private SimpleString name;

    public LocalQueueBinding(SimpleString address, Queue queue, SimpleString nodeID) {
        this.address = address;
        this.queue = queue;
        this.name = queue.getName();
        this.clusterName = queue.getName().concat(nodeID);
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public Long getID() {
        return this.queue.getID();
    }

    @Override
    public Filter getFilter() {
        return this.queue.getFilter();
    }

    @Override
    public SimpleString getAddress() {
        return this.address;
    }

    @Override
    public Bindable getBindable() {
        return this.queue;
    }

    @Override
    public Queue getQueue() {
        return this.queue;
    }

    @Override
    public SimpleString getRoutingName() {
        if (this.queue.getRoutingType() == RoutingType.ANYCAST) {
            return this.address;
        }
        return this.name;
    }

    @Override
    public SimpleString getUniqueName() {
        return this.queue.getName();
    }

    @Override
    public SimpleString getClusterName() {
        return this.clusterName;
    }

    @Override
    public boolean isExclusive() {
        return false;
    }

    @Override
    public int getDistance() {
        return 0;
    }

    @Override
    public boolean isHighAcceptPriority(Message message) {
        return this.queue.hasMatchingConsumer(message);
    }

    @Override
    public void unproposed(SimpleString groupID) {
        this.queue.unproposed(groupID);
    }

    @Override
    public void route(Message message, RoutingContext context) throws Exception {
        if (this.isMatchRoutingType(context)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("adding routing " + this.queue.getID() + " on message " + message));
            }
            this.queue.route(message, context);
        } else if (logger.isTraceEnabled()) {
            logger.trace((Object)("routing " + this.queue.getID() + " is ignored as routing type did not match"));
        }
    }

    @Override
    public void routeWithAck(Message message, RoutingContext context) throws Exception {
        if (this.isMatchRoutingType(context)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Message " + message + " routed with ack on queue " + this.queue.getID()));
            }
            this.queue.routeWithAck(message, context);
        }
    }

    private boolean isMatchRoutingType(RoutingContext context) {
        return context.getRoutingType() == null || context.getRoutingType() == this.queue.getRoutingType();
    }

    public boolean isQueueBinding() {
        return true;
    }

    @Override
    public int consumerCount() {
        return this.queue.getConsumerCount();
    }

    @Override
    public BindingType getType() {
        return BindingType.LOCAL_QUEUE;
    }

    @Override
    public void close() throws Exception {
        this.queue.close();
    }

    public String toString() {
        return "LocalQueueBinding [address=" + this.address + ", queue=" + this.queue + ", filter=" + this.getFilter() + ", name=" + this.name + ", clusterName=" + this.clusterName + "]";
    }

    @Override
    public String toManagementString() {
        return this.getClass().getSimpleName() + " [address=" + this.address + ", queue=" + this.queue + "]";
    }

    @Override
    public boolean isConnected() {
        return true;
    }
}

