/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.multipart;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.MimeIOException;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.Entity;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.field.DefaultFieldParser;
import org.apache.james.mime4j.field.LenientFieldParser;
import org.apache.james.mime4j.message.BodyFactory;
import org.apache.james.mime4j.message.DefaultBodyDescriptorBuilder;
import org.apache.james.mime4j.message.MessageImpl;
import org.apache.james.mime4j.parser.ContentHandler;
import org.apache.james.mime4j.parser.MimeStreamParser;
import org.apache.james.mime4j.storage.AbstractStorageProvider;
import org.apache.james.mime4j.storage.DefaultStorageProvider;
import org.apache.james.mime4j.storage.Storage;
import org.apache.james.mime4j.storage.StorageBodyFactory;
import org.apache.james.mime4j.storage.StorageOutputStream;
import org.apache.james.mime4j.storage.StorageProvider;
import org.apache.james.mime4j.storage.ThresholdStorageProvider;
import org.apache.james.mime4j.stream.BodyDescriptorBuilder;
import org.apache.james.mime4j.stream.MimeConfig;
import org.jboss.resteasy.plugins.providers.multipart.Mime4jWorkaroundBinaryEntityBuilder;
import org.jboss.resteasy.spi.config.ConfigurationFactory;

public class Mime4JWorkaround {
    public static Message parseMessage(InputStream is) throws IOException, MimeIOException {
        try {
            StorageProvider storageProvider;
            MessageImpl message = new MessageImpl();
            MimeConfig cfg = MimeConfig.DEFAULT;
            boolean strict = cfg.isStrictParsing();
            DecodeMonitor mon = strict ? DecodeMonitor.STRICT : DecodeMonitor.SILENT;
            DefaultBodyDescriptorBuilder bdb = new DefaultBodyDescriptorBuilder(null, strict ? DefaultFieldParser.getParser() : LenientFieldParser.getParser(), mon);
            if (ConfigurationFactory.getInstance().getConfiguration().getOptionalValue("org.apache.james.mime4j.defaultStorageProvider", String.class).orElse(null) != null) {
                storageProvider = DefaultStorageProvider.getInstance();
            } else {
                CustomTempFileStorageProvider backend = new CustomTempFileStorageProvider();
                storageProvider = new ThresholdStorageProvider((StorageProvider)backend, 1024);
            }
            StorageBodyFactory bf = new StorageBodyFactory(storageProvider, mon);
            MimeStreamParser parser = new MimeStreamParser(cfg, mon, (BodyDescriptorBuilder)bdb);
            parser.setContentHandler((ContentHandler)new Mime4jWorkaroundBinaryEntityBuilder((Entity)message, (BodyFactory)bf));
            parser.setContentDecoding(false);
            parser.setRecurse();
            parser.parse(is);
            return message;
        }
        catch (MimeException e) {
            throw new MimeIOException(e);
        }
    }

    private static class CustomTempFileStorageProvider
    extends AbstractStorageProvider {
        private static final String DEFAULT_PREFIX = "m4j";
        private final String prefix;
        private final String suffix;
        private final File directory;

        CustomTempFileStorageProvider() {
            this(DEFAULT_PREFIX, null, null);
        }

        CustomTempFileStorageProvider(String prefix, String suffix, File directory) {
            if (prefix == null || prefix.length() < 3) {
                throw new IllegalArgumentException("invalid prefix");
            }
            if (directory != null && !directory.isDirectory() && !directory.mkdirs()) {
                throw new IllegalArgumentException("invalid directory");
            }
            this.prefix = prefix;
            this.suffix = suffix;
            this.directory = directory;
        }

        public StorageOutputStream createStorageOutputStream() throws IOException {
            return new TempFileStorageOutputStream(CustomTempFileStorageProvider.createTempFile(this.prefix, this.suffix, this.directory));
        }

        private static File createTempFile(String prefix, String suffix, File directory) throws IOException {
            boolean java2SecurityEnabled;
            boolean bl = java2SecurityEnabled = System.getSecurityManager() != null;
            if (java2SecurityEnabled) {
                try {
                    return AccessController.doPrivileged(() -> File.createTempFile(prefix, suffix, directory));
                }
                catch (PrivilegedActionException pae) {
                    Throwable cause = pae.getCause();
                    if (cause instanceof IOException) {
                        throw (IOException)cause;
                    }
                    throw new RuntimeException(cause);
                }
            }
            return File.createTempFile(prefix, suffix, directory);
        }

        private static FileOutputStream createFileOutputStream(File file) throws IOException {
            boolean java2SecurityEnabled;
            boolean bl = java2SecurityEnabled = System.getSecurityManager() != null;
            if (java2SecurityEnabled) {
                try {
                    return AccessController.doPrivileged(() -> new FileOutputStream(file));
                }
                catch (PrivilegedActionException pae) {
                    Throwable cause = pae.getCause();
                    if (cause instanceof IOException) {
                        throw (IOException)cause;
                    }
                    throw new RuntimeException(cause);
                }
            }
            return new FileOutputStream(file);
        }

        private static final class TempFileStorage
        implements Storage {
            private File file;
            private static final Set<File> filesToDelete = new HashSet<File>();

            TempFileStorage(File file) {
                this.file = file;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void delete() {
                Set<File> set = filesToDelete;
                synchronized (set) {
                    if (this.file != null) {
                        filesToDelete.add(this.file);
                        this.file = null;
                    }
                    Iterator<File> iterator = filesToDelete.iterator();
                    while (iterator.hasNext()) {
                        File f = iterator.next();
                        if (!f.delete()) continue;
                        iterator.remove();
                    }
                }
            }

            public InputStream getInputStream() throws IOException {
                if (this.file == null) {
                    throw new IllegalStateException("storage has been deleted");
                }
                return new BufferedInputStream(new FileInputStream(this.file));
            }
        }

        private static final class TempFileStorageOutputStream
        extends StorageOutputStream {
            private File file;
            private OutputStream out;

            TempFileStorageOutputStream(File file) throws IOException {
                this.file = file;
                this.out = CustomTempFileStorageProvider.createFileOutputStream(file);
            }

            public void close() throws IOException {
                super.close();
                this.out.close();
            }

            protected void write0(byte[] buffer, int offset, int length) throws IOException {
                this.out.write(buffer, offset, length);
            }

            protected Storage toStorage0() throws IOException {
                return new TempFileStorage(this.file);
            }
        }
    }
}

