/*
 * Decompiled with CFR 0.152.
 */
package com.github.drapostolos.typeparser;

import com.github.drapostolos.typeparser.NoSuchRegisteredTypeParserException;
import com.github.drapostolos.typeparser.ParseTemplate;
import com.github.drapostolos.typeparser.Parser;
import com.github.drapostolos.typeparser.ParserHelper;
import com.github.drapostolos.typeparser.Parsers;
import com.github.drapostolos.typeparser.TypeParser;
import com.github.drapostolos.typeparser.TypeParserUtility;
import java.lang.reflect.Type;

class ParserInvoker
extends ParseTemplate<Object> {
    private final TypeParser parser;
    private final String preprocessedInput;

    public ParserInvoker(TypeParser parser, Type targetType, String preprocessedInput) {
        super(parser.parsers, targetType);
        this.preprocessedInput = preprocessedInput;
        this.parser = parser;
    }

    @Override
    Object actionWhenTargetTypeHasNormalTypeParser() {
        if (this.preprocessedInput == null) {
            return null;
        }
        return this.invokeTypeParser(this.typeParsers.parsers.get(this.targetType));
    }

    @Override
    Object actionWhenTaretTypeIsGeneric(Class<?> cls) {
        Parser<?> tp = this.typeParsers.assignableParsers.get(cls);
        return this.invokeTypeParser(tp);
    }

    @Override
    Object actionWhenTargetTypeIsAssignalbleTo(Class<?> superClass) {
        Parser<?> tp = this.typeParsers.assignableParsers.get(superClass);
        return this.invokeTypeParser(tp);
    }

    @Override
    Object actionWhenTargetTypeIsArrayClass() {
        Parser<?> tp = this.typeParsers.parsers.get(Parsers.ANY_ARRAY);
        return this.invokeTypeParser(tp);
    }

    @Override
    Object actionWhenTargetTypeHasStaticFactoryMethod() {
        if (this.preprocessedInput == null) {
            return null;
        }
        Parser<?> tp = this.typeParsers.parsers.get(Parsers.ANY_CLASS_WITH_STATIC_VALUEOF_METHOD);
        return this.invokeTypeParser(tp);
    }

    @Override
    Object actionWhenTargetTypeIsGenericArrayType() {
        Parser<?> tp = this.typeParsers.parsers.get(Parsers.ANY_ARRAY);
        return this.invokeTypeParser(tp);
    }

    @Override
    Object lastAction() {
        throw new NoSuchRegisteredTypeParserException(this.preprocessedInput, this.targetType);
    }

    private Object invokeTypeParser(Parser<?> typeParser) {
        try {
            ParserHelper parseHelper = new ParserHelper(this.parser, this.targetType);
            return typeParser.parse(this.preprocessedInput, parseHelper);
        }
        catch (NumberFormatException e) {
            String message = String.format("Number format exception %s.", e.getMessage());
            message = TypeParserUtility.makeParseErrorMsg(this.preprocessedInput, this.targetType, message);
            throw new IllegalArgumentException(message, e);
        }
        catch (Throwable e) {
            String message = TypeParserUtility.makeParseErrorMsg(this.preprocessedInput, this.targetType, e.getMessage());
            throw new IllegalArgumentException(message, e);
        }
    }
}

