/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.asn1.eac;

import java.io.UnsupportedEncodingException;

public class CertificateHolderReference {
    private static final String ReferenceEncoding = "ISO-8859-1";
    private String countryCode;
    private String holderMnemonic;
    private String sequenceNumber;

    public CertificateHolderReference(String string2, String string3, String string4) {
        this.countryCode = string2;
        this.holderMnemonic = string3;
        this.sequenceNumber = string4;
    }

    CertificateHolderReference(byte[] byArray) {
        try {
            String string2 = new String(byArray, ReferenceEncoding);
            this.countryCode = string2.substring(0, 2);
            this.holderMnemonic = string2.substring(2, string2.length() - 5);
            this.sequenceNumber = string2.substring(string2.length() - 5);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException.toString());
        }
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public String getHolderMnemonic() {
        return this.holderMnemonic;
    }

    public String getSequenceNumber() {
        return this.sequenceNumber;
    }

    public byte[] getEncoded() {
        String string2 = this.countryCode + this.holderMnemonic + this.sequenceNumber;
        try {
            return string2.getBytes(ReferenceEncoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException.toString());
        }
    }
}

