/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.observation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.core.observation.ChangeLogBasedHierarchyMgr;
import org.apache.jackrabbit.core.observation.EventDispatcher;
import org.apache.jackrabbit.core.observation.EventState;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.name.PathBuilder;
import org.apache.jackrabbit.spi.commons.name.PathFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventStateCollection {
    private static Logger log = LoggerFactory.getLogger((Class)EventStateCollection.class);
    private final List events = new ArrayList();
    private final EventDispatcher dispatcher;
    private final SessionImpl session;
    private final Path pathPrefix;

    public EventStateCollection(EventDispatcher dispatcher, SessionImpl session, Path pathPrefix) {
        this.dispatcher = dispatcher;
        this.session = session;
        this.pathPrefix = pathPrefix;
    }

    public void createEventStates(NodeId rootNodeId, ChangeLog changes, ItemStateManager stateMgr) throws ItemStateException {
        Path path;
        Set mixins;
        NodeTypeImpl nodeType;
        NodeState parent;
        Set mixins2;
        NodeTypeImpl nodeType2;
        NodeState n;
        ItemState state;
        ChangeLogBasedHierarchyMgr hmgr = new ChangeLogBasedHierarchyMgr(rootNodeId, stateMgr, changes);
        Iterator it = changes.modifiedStates();
        while (it.hasNext()) {
            state = (ItemState)it.next();
            if (state.isNode()) {
                Path parentPath;
                n = (NodeState)state;
                if (n.hasOverlayedState()) {
                    NodeId oldParentId = n.getOverlayedState().getParentId();
                    NodeId newParentId = n.getParentId();
                    if (newParentId != null && !oldParentId.equals(newParentId) && !n.isShareable()) {
                        NodeState oldParent;
                        try {
                            oldParent = (NodeState)changes.get(oldParentId);
                        }
                        catch (NoSuchItemStateException e) {
                            oldParent = (NodeState)stateMgr.getItemState(oldParentId);
                        }
                        NodeTypeImpl oldParentNodeType = this.getNodeType(oldParent, this.session);
                        Set mixins3 = oldParent.getMixinTypeNames();
                        Path newPath = this.getPath(n.getNodeId(), hmgr);
                        Path oldPath = this.getZombiePath(n.getNodeId(), hmgr);
                        this.events.add(EventState.childNodeRemoved(oldParentId, this.getParent(oldPath), n.getNodeId(), oldPath.getNameElement(), oldParentNodeType.getQName(), mixins3, this.session));
                        NodeState newParent = (NodeState)changes.get(newParentId);
                        NodeTypeImpl newParentNodeType = this.getNodeType(newParent, this.session);
                        mixins3 = newParent.getMixinTypeNames();
                        this.events.add(EventState.childNodeAdded(newParentId, this.getParent(newPath), n.getNodeId(), newPath.getNameElement(), newParentNodeType.getQName(), mixins3, this.session));
                    } else {
                        NodeState parent2 = null;
                        try {
                            if (state.getParentId() != null) {
                                parent2 = (NodeState)changes.get(state.getParentId());
                            }
                        }
                        catch (NoSuchItemStateException e) {
                            String msg = "Parent of node " + state.getId() + " is deleted.";
                            log.error(msg);
                            throw new ItemStateException(msg, e);
                        }
                        if (parent2 != null) {
                            ChildNodeEntry moved = null;
                            Iterator removedNodes = parent2.getRemovedChildNodeEntries().iterator();
                            while (removedNodes.hasNext()) {
                                ChildNodeEntry child = (ChildNodeEntry)removedNodes.next();
                                if (!child.getId().equals(n.getNodeId())) continue;
                                moved = child;
                            }
                            if (moved != null) {
                                Path oldPath;
                                NodeTypeImpl nodeType3 = this.getNodeType(parent2, this.session);
                                Set mixins4 = parent2.getMixinTypeNames();
                                Path newPath = this.getPath(state.getId(), hmgr);
                                parentPath = this.getParent(newPath);
                                try {
                                    oldPath = moved.getIndex() == 0 ? PathFactoryImpl.getInstance().create(parentPath, moved.getName(), false) : PathFactoryImpl.getInstance().create(parentPath, moved.getName(), moved.getIndex(), false);
                                }
                                catch (RepositoryException e) {
                                    String msg = "Malformed path for item: " + state.getId();
                                    log.error(msg);
                                    throw new ItemStateException(msg, e);
                                }
                                this.events.add(EventState.childNodeRemoved(parent2.getNodeId(), parentPath, n.getNodeId(), oldPath.getNameElement(), nodeType3.getQName(), mixins4, this.session));
                                this.events.add(EventState.childNodeAdded(parent2.getNodeId(), parentPath, n.getNodeId(), newPath.getNameElement(), nodeType3.getQName(), mixins4, this.session));
                            }
                        }
                    }
                }
                List reordered = n.getReorderedChildNodeEntries();
                nodeType2 = this.getNodeType(n, this.session);
                mixins2 = n.getMixinTypeNames();
                if (reordered.size() <= 0) continue;
                Iterator ro = reordered.iterator();
                while (ro.hasNext()) {
                    ChildNodeEntry child = (ChildNodeEntry)ro.next();
                    Name name = child.getName();
                    int index = child.getIndex() != 1 ? child.getIndex() : 0;
                    parentPath = this.getPath(n.getNodeId(), hmgr);
                    Path.Element addedElem = PathFactoryImpl.getInstance().createElement(name, index);
                    NodeState overlayed = (NodeState)n.getOverlayedState();
                    ChildNodeEntry entry = overlayed.getChildNodeEntry(child.getId());
                    if (entry == null) {
                        throw new ItemStateException("Unable to retrieve old child index for item: " + child.getId());
                    }
                    int oldIndex = entry.getIndex() != 1 ? entry.getIndex() : 0;
                    Path.Element removedElem = PathFactoryImpl.getInstance().createElement(name, oldIndex);
                    this.events.add(EventState.childNodeRemoved(n.getNodeId(), parentPath, child.getId(), removedElem, nodeType2.getQName(), mixins2, this.session));
                    this.events.add(EventState.childNodeAdded(n.getNodeId(), parentPath, child.getId(), addedElem, nodeType2.getQName(), mixins2, this.session));
                }
                continue;
            }
            Path path2 = this.getPath(state.getId(), hmgr);
            parent = (NodeState)stateMgr.getItemState(state.getParentId());
            nodeType2 = this.getNodeType(parent, this.session);
            mixins2 = parent.getMixinTypeNames();
            this.events.add(EventState.propertyChanged(state.getParentId(), this.getParent(path2), path2.getNameElement(), nodeType2.getQName(), mixins2, this.session));
        }
        it = changes.deletedStates();
        while (it.hasNext()) {
            state = (ItemState)it.next();
            if (state.isNode()) {
                n = (NodeState)state;
                parent = (NodeState)stateMgr.getItemState(n.getParentId());
                nodeType2 = this.getNodeType(parent, this.session);
                mixins2 = parent.getMixinTypeNames();
                Path path3 = this.getZombiePath(state.getId(), hmgr);
                this.events.add(EventState.childNodeRemoved(n.getParentId(), this.getParent(path3), n.getNodeId(), path3.getNameElement(), nodeType2.getQName(), mixins2, this.session));
                continue;
            }
            try {
                n = (NodeState)changes.get(state.getParentId());
                nodeType = this.getNodeType(n, this.session);
                mixins = n.getMixinTypeNames();
                path = this.getZombiePath(state.getId(), hmgr);
                this.events.add(EventState.propertyRemoved(state.getParentId(), this.getParent(path), path.getNameElement(), nodeType.getQName(), mixins, this.session));
            }
            catch (NoSuchItemStateException e) {}
        }
        it = changes.addedStates();
        while (it.hasNext()) {
            state = (ItemState)it.next();
            if (state.isNode()) {
                n = (NodeState)state;
                NodeId parentId = n.getParentId();
                NodeState parent3 = (NodeState)changes.get(parentId);
                NodeTypeImpl nodeType4 = this.getNodeType(parent3, this.session);
                Set mixins5 = parent3.getMixinTypeNames();
                Path path4 = this.getPath(n.getNodeId(), hmgr);
                this.events.add(EventState.childNodeAdded(parentId, this.getParent(path4), n.getNodeId(), path4.getNameElement(), nodeType4.getQName(), mixins5, this.session));
                continue;
            }
            n = (NodeState)changes.get(state.getParentId());
            nodeType = this.getNodeType(n, this.session);
            mixins = n.getMixinTypeNames();
            path = this.getPath(state.getId(), hmgr);
            this.events.add(EventState.propertyAdded(state.getParentId(), this.getParent(path), path.getNameElement(), nodeType.getQName(), mixins, this.session));
        }
    }

    public void addAll(Collection c) {
        this.events.addAll(c);
    }

    public void prepare() {
        this.dispatcher.prepareEvents(this);
    }

    public void prepareDeleted(ChangeLog changes) {
        this.dispatcher.prepareDeleted(this, changes);
    }

    public void dispatch() {
        this.dispatcher.dispatchEvents(this);
    }

    public Path getPathPrefix() {
        return this.pathPrefix;
    }

    Iterator iterator() {
        return this.events.iterator();
    }

    public List getEvents() {
        return Collections.unmodifiableList(this.events);
    }

    SessionImpl getSession() {
        return this.session;
    }

    private NodeTypeImpl getNodeType(NodeState node, SessionImpl session) throws ItemStateException {
        try {
            return session.getNodeTypeManager().getNodeType(node.getNodeTypeName());
        }
        catch (Exception e) {
            String msg = "Item " + node.getNodeId() + " has unknown node type: " + node.getNodeTypeName();
            log.error(msg);
            throw new ItemStateException(msg, e);
        }
    }

    private Path getParent(Path p) throws ItemStateException {
        try {
            return p.getAncestor(1);
        }
        catch (PathNotFoundException e) {
            String msg = "Unable to resolve parent for path: " + p;
            log.error(msg);
            throw new ItemStateException(msg, e);
        }
    }

    private Path getPath(ItemId itemId, HierarchyManager hmgr) throws ItemStateException {
        try {
            return this.prefixPath(hmgr.getPath(itemId));
        }
        catch (RepositoryException e) {
            String msg = "Unable to resolve path for item: " + itemId;
            log.error(msg);
            throw new ItemStateException(msg, e);
        }
    }

    private Path getZombiePath(ItemId itemId, ChangeLogBasedHierarchyMgr hmgr) throws ItemStateException {
        try {
            return this.prefixPath(hmgr.getZombiePath(itemId));
        }
        catch (RepositoryException e) {
            String msg = "Unable to resolve zombie path for item: " + itemId;
            log.error(msg);
            throw new ItemStateException(msg, e);
        }
    }

    private Path prefixPath(Path p) throws RepositoryException {
        if (this.pathPrefix == null) {
            return p;
        }
        PathBuilder builder = new PathBuilder(this.pathPrefix.getElements());
        Path.Element[] elements = p.getElements();
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i].denotesRoot()) continue;
            builder.addLast(elements[i]);
        }
        return builder.getPath();
    }
}

