/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.internal.bytebuddy;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import net.bytebuddy.NamingStrategy;
import net.bytebuddy.TypeCache;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.dynamic.scaffold.subclass.ConstructorStrategy;
import net.bytebuddy.implementation.Implementation;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.bytecode.internal.bytebuddy.ByteBuddyState;
import org.hibernate.bytecode.internal.bytebuddy.PassThroughInterceptor;
import org.hibernate.bytecode.spi.BasicProxyFactory;
import org.hibernate.cfg.Environment;
import org.hibernate.proxy.ProxyConfiguration;

public class BasicProxyFactoryImpl
implements BasicProxyFactory {
    private static final Class[] NO_INTERFACES = new Class[0];
    private static final String PROXY_NAMING_SUFFIX = Environment.useLegacyProxyClassnames() ? "HibernateBasicProxy$" : "HibernateBasicProxy";
    private final Class proxyClass;
    private final ProxyConfiguration.Interceptor interceptor;

    public BasicProxyFactoryImpl(Class superClass, Class[] interfaces, ByteBuddyState byteBuddyState) {
        if (superClass == null && (interfaces == null || interfaces.length < 1)) {
            throw new AssertionFailure("attempting to build proxy without any superclass or interfaces");
        }
        Class superClassOrMainInterface = superClass != null ? superClass : interfaces[0];
        TypeCache.SimpleKey cacheKey = this.getCacheKey(superClass, interfaces);
        this.proxyClass = byteBuddyState.loadBasicProxy(superClassOrMainInterface, cacheKey, byteBuddy -> byteBuddy.with((NamingStrategy)new NamingStrategy.SuffixingRandom(PROXY_NAMING_SUFFIX, (NamingStrategy.SuffixingRandom.BaseNameResolver)new NamingStrategy.SuffixingRandom.BaseNameResolver.ForFixedValue(superClassOrMainInterface.getName()))).subclass(superClass == null ? Object.class : superClass, (ConstructorStrategy)ConstructorStrategy.Default.DEFAULT_CONSTRUCTOR).implement((Type[])(interfaces == null ? NO_INTERFACES : interfaces)).defineField("$$_hibernate_interceptor", ProxyConfiguration.Interceptor.class, new ModifierContributor.ForField[]{Visibility.PRIVATE}).method(byteBuddyState.getProxyDefinitionHelpers().getVirtualNotFinalizerFilter()).intercept((Implementation)byteBuddyState.getProxyDefinitionHelpers().getDelegateToInterceptorDispatcherMethodDelegation()).implement(new Type[]{ProxyConfiguration.class}).intercept((Implementation)byteBuddyState.getProxyDefinitionHelpers().getInterceptorFieldAccessor()));
        this.interceptor = new PassThroughInterceptor(this.proxyClass.getName());
    }

    @Override
    public Object getProxy() {
        try {
            ProxyConfiguration proxy = (ProxyConfiguration)this.proxyClass.newInstance();
            proxy.$$_hibernate_set_interceptor(this.interceptor);
            return proxy;
        }
        catch (Throwable t) {
            throw new HibernateException("Unable to instantiate proxy instance", t);
        }
    }

    public boolean isInstance(Object object) {
        return this.proxyClass.isInstance(object);
    }

    private TypeCache.SimpleKey getCacheKey(Class<?> superClass, Class<?>[] interfaces) {
        HashSet key = new HashSet();
        if (superClass != null) {
            key.add(superClass);
        }
        if (interfaces != null) {
            key.addAll(Arrays.asList(interfaces));
        }
        return new TypeCache.SimpleKey(key);
    }
}

