/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.winrm;

import org.apache.http.auth.Credentials;
import org.apache.http.auth.KerberosCredentials;
import org.apache.http.impl.auth.KerberosScheme;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WsmanKerberosScheme
extends KerberosScheme {
    private final String spnServiceClass;
    private final String spnAddress;
    private final int spnPort;
    private static final Logger logger = LoggerFactory.getLogger(WsmanKerberosScheme.class);

    public WsmanKerberosScheme(boolean stripPort, String spnServiceClass, String spnAddress, int spnPort) {
        this(stripPort, spnServiceClass, spnAddress, spnPort, false);
    }

    public WsmanKerberosScheme(boolean stripPort, String spnServiceClass, String spnAddress, int spnPort, boolean useCanonicalHostname) {
        super(stripPort, useCanonicalHostname);
        this.spnServiceClass = spnServiceClass;
        this.spnAddress = spnAddress;
        this.spnPort = spnPort;
    }

    protected byte[] generateGSSToken(byte[] input, Oid oid, String authServer) throws GSSException {
        logger.trace("WsmanKerberosScheme.generateGSSToken invoked for authServer = {} without credentials", (Object)authServer);
        return this.doGenerateGSSToken(input, oid, authServer, null);
    }

    protected byte[] generateGSSToken(byte[] input, Oid oid, String authServer, Credentials credentials) throws GSSException {
        logger.trace("WsmanKerberosScheme.generateGSSToken invoked for authServer = {} with credentials", (Object)authServer);
        return this.doGenerateGSSToken(input, oid, authServer, credentials);
    }

    private byte[] doGenerateGSSToken(byte[] input, Oid oid, String authServer, Credentials credentials) throws GSSException {
        byte[] token = input;
        if (token == null) {
            token = new byte[]{};
        }
        Object gssAuthServer = authServer.equals("localhost") ? (authServer.indexOf(58) > 0 ? this.spnAddress + ":" + this.spnPort : this.spnAddress) : authServer;
        String spn = this.spnServiceClass + "@" + (String)gssAuthServer;
        GSSCredential gssCredential = credentials instanceof KerberosCredentials ? ((KerberosCredentials)credentials).getGSSCredential() : null;
        logger.debug("Canonicalizing SPN {}", (Object)spn);
        GSSManager manager = this.getManager();
        GSSName serverName = manager.createName(spn, GSSName.NT_HOSTBASED_SERVICE);
        GSSName canonicalizedName = serverName.canonicalize(oid);
        logger.debug("Requesting Kerberos ticket for canonicalized SPN {}", (Object)canonicalizedName);
        GSSContext gssContext = manager.createContext(canonicalizedName, oid, gssCredential, 0);
        gssContext.requestMutualAuth(true);
        gssContext.requestCredDeleg(true);
        return gssContext.initSecContext(token, 0, token.length);
    }
}

