/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.ssh;

import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereExecutionOutputHandler;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.spi.BaseOverthereConnection;
import com.xebialabs.overthere.spi.BaseOverthereFile;
import com.xebialabs.overthere.ssh.SshConnection;
import com.xebialabs.overthere.util.OverthereUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

abstract class SshFile<C extends SshConnection>
extends BaseOverthereFile<C> {
    protected List<String> pathComponents;
    private static final Pattern UNIX_PATH_SPLITTER = Pattern.compile("/");
    private static final Pattern WINDOWS_PATH_SPLITTER = Pattern.compile("[/\\\\]");

    SshFile(C connection, String path) {
        this(connection, SshFile.splitPath(path, ((BaseOverthereConnection)connection).getHostOperatingSystem()));
    }

    SshFile(C connection, List<String> pathComponents) {
        super(connection);
        SshFile.checkWindowsPath(pathComponents, ((BaseOverthereConnection)connection).getHostOperatingSystem());
        this.pathComponents = pathComponents;
    }

    @Override
    public String getPath() {
        return SshFile.joinPath(this.pathComponents, ((SshConnection)this.connection).getHostOperatingSystem());
    }

    @Override
    public boolean isHidden() {
        return this.getName().startsWith(".");
    }

    @Override
    public String getName() {
        if (this.pathComponents.isEmpty()) {
            return ((SshConnection)this.connection).getHostOperatingSystem().getFileSeparator();
        }
        return this.pathComponents.get(this.pathComponents.size() - 1);
    }

    @Override
    public OverthereFile getParentFile() {
        if (this.pathComponents.isEmpty()) {
            return this;
        }
        if (((SshConnection)this.connection).getHostOperatingSystem() == OperatingSystemFamily.WINDOWS && this.pathComponents.size() == 1) {
            return this;
        }
        return ((SshConnection)this.connection).getFile(SshFile.joinPath(this.pathComponents.subList(0, this.pathComponents.size() - 1), ((SshConnection)this.connection).getHostOperatingSystem()));
    }

    @Override
    public void delete() throws RuntimeIOException {
        if (this.exists()) {
            if (this.isDirectory()) {
                this.deleteDirectory();
            } else {
                this.deleteFile();
            }
        }
    }

    protected abstract void deleteFile();

    protected abstract void deleteDirectory();

    protected int executeCommand(OverthereExecutionOutputHandler outHandler, OverthereExecutionOutputHandler errHandler, CmdLine commandLine) {
        return ((SshConnection)this.connection).execute(outHandler, errHandler, commandLine);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SshFile)) {
            return false;
        }
        return this.getPath().equals(((SshFile)obj).getPath());
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    @Override
    public String toString() {
        String p = this.getPath();
        if (p.length() >= 1 && p.charAt(0) == '/') {
            return (BaseOverthereConnection)this.getConnection() + p;
        }
        return (BaseOverthereConnection)this.getConnection() + "/" + p;
    }

    static List<String> splitPath(String path, OperatingSystemFamily os) {
        Pattern s = os == OperatingSystemFamily.WINDOWS ? WINDOWS_PATH_SPLITTER : UNIX_PATH_SPLITTER;
        ArrayList<String> l = new ArrayList<String>();
        for (String p : s.split(path)) {
            if (p.isEmpty()) continue;
            l.add(p);
        }
        return l;
    }

    static String joinPath(List<String> pathComponents, OperatingSystemFamily os) {
        String fileSep = os.getFileSeparator();
        if (pathComponents.isEmpty()) {
            return fileSep;
        }
        if (os == OperatingSystemFamily.WINDOWS) {
            Object path = OverthereUtils.mkString(pathComponents, fileSep);
            if (pathComponents.size() == 1) {
                path = (String)path + fileSep;
            }
            return path;
        }
        return fileSep + OverthereUtils.mkString(pathComponents, fileSep);
    }

    static void checkWindowsPath(List<String> pathComponents, OperatingSystemFamily os) {
        if (os == OperatingSystemFamily.WINDOWS && pathComponents.isEmpty()) {
            throw new IllegalArgumentException("Empty path is not allowed on Windows");
        }
    }
}

