/*
 * Decompiled with CFR 0.152.
 */
package liquibase.serializer.core.xml;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import liquibase.change.ColumnConfig;
import liquibase.change.ConstraintsConfig;
import liquibase.changelog.ChangeLogChild;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.configuration.GlobalConfiguration;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.parser.NamespaceDetails;
import liquibase.parser.NamespaceDetailsFactory;
import liquibase.parser.core.xml.LiquibaseEntityResolver;
import liquibase.serializer.ChangeLogSerializer;
import liquibase.serializer.LiquibaseSerializable;
import liquibase.util.ISODateFormat;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtil;
import liquibase.util.XMLUtil;
import liquibase.util.xml.DefaultXmlWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLChangeLogSerializer
implements ChangeLogSerializer {
    public static final String INVALID_STRING_ENCODING_MESSAGE = "Invalid string encoding";
    private Document currentChangeLogFileDOM;
    private static final String XML_VERSION = "1.1";

    public XMLChangeLogSerializer() {
        try {
            this.currentChangeLogFileDOM = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            this.currentChangeLogFileDOM.setXmlVersion(XML_VERSION);
        }
        catch (ParserConfigurationException e2) {
            throw new UnexpectedLiquibaseException(e2);
        }
    }

    protected XMLChangeLogSerializer(Document currentChangeLogFileDOM) {
        this.currentChangeLogFileDOM = currentChangeLogFileDOM;
    }

    public void setCurrentChangeLogFileDOM(Document currentChangeLogFileDOM) {
        this.currentChangeLogFileDOM = currentChangeLogFileDOM;
    }

    @Override
    public String[] getValidFileExtensions() {
        return new String[]{"xml"};
    }

    public String serialize(DatabaseChangeLog databaseChangeLog) {
        return null;
    }

    @Override
    public String serialize(LiquibaseSerializable object, boolean pretty) {
        StringBuilder buffer = new StringBuilder();
        int indent = -1;
        if (pretty) {
            indent = 0;
        }
        this.nodeToStringBuilder(this.createNode(object), buffer, indent);
        return buffer.toString();
    }

    @Override
    public <T extends ChangeLogChild> void write(List<T> children, OutputStream out) throws IOException {
        DocumentBuilder documentBuilder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            documentBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e2) {
            throw new RuntimeException(e2);
        }
        documentBuilder.setEntityResolver(new LiquibaseEntityResolver());
        Document doc = documentBuilder.newDocument();
        doc.setXmlVersion(XML_VERSION);
        Element changeLogElement = doc.createElementNS("http://www.liquibase.org/xml/ns/dbchangelog", "databaseChangeLog");
        changeLogElement.setAttribute("xmlns", "http://www.liquibase.org/xml/ns/dbchangelog");
        changeLogElement.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        HashMap<String, String> shortNameByNamespace = new HashMap<String, String>();
        HashMap<String, String> urlByNamespace = new HashMap<String, String>();
        for (NamespaceDetails namespaceDetails : NamespaceDetailsFactory.getInstance().getNamespaceDetails()) {
            for (String namespace : namespaceDetails.getNamespaces()) {
                if (namespaceDetails.getPriority() <= 0 || !namespaceDetails.supports(this, namespace)) continue;
                String shortName = namespaceDetails.getShortName(namespace);
                String url = namespaceDetails.getSchemaUrl(namespace);
                if (shortName != null) {
                    shortNameByNamespace.put(namespace, shortName);
                }
                if (url == null) continue;
                urlByNamespace.put(namespace, url);
            }
        }
        for (Map.Entry entry : shortNameByNamespace.entrySet()) {
            if ("".equals(entry.getValue())) continue;
            changeLogElement.setAttribute("xmlns:" + (String)entry.getValue(), (String)entry.getKey());
        }
        StringBuilder schemaLocationAttribute = new StringBuilder();
        for (Map.Entry entry : urlByNamespace.entrySet()) {
            if ("".equals(entry.getValue())) continue;
            schemaLocationAttribute.append((String)entry.getKey()).append(" ").append((String)entry.getValue()).append(" ");
        }
        changeLogElement.setAttribute("xsi:schemaLocation", schemaLocationAttribute.toString().trim());
        doc.appendChild(changeLogElement);
        this.setCurrentChangeLogFileDOM(doc);
        for (ChangeLogChild child : children) {
            doc.getDocumentElement().appendChild(this.createNode(child));
        }
        new DefaultXmlWriter().write(doc, out);
    }

    @Override
    public void append(ChangeSet changeSet, File changeLogFile) throws IOException {
        String existingChangeLog;
        try (FileInputStream in2 = new FileInputStream(changeLogFile);){
            existingChangeLog = StreamUtil.readStreamAsString(in2);
        }
        var5_4 = null;
        try (FileOutputStream out = new FileOutputStream(changeLogFile);){
            if (!existingChangeLog.contains("</databaseChangeLog>")) {
                this.write(Arrays.asList(changeSet), out);
            } else {
                existingChangeLog = existingChangeLog.replaceFirst("</databaseChangeLog>", this.serialize(changeSet, true) + "\n</databaseChangeLog>");
                StreamUtil.copy(new ByteArrayInputStream(existingChangeLog.getBytes(LiquibaseConfiguration.getInstance().getConfiguration(GlobalConfiguration.class).getOutputEncoding())), out);
            }
            out.flush();
        }
        catch (Throwable throwable) {
            var5_4 = throwable;
            throw throwable;
        }
    }

    public Element createNode(LiquibaseSerializable object) {
        String namespace = object.getSerializedObjectNamespace();
        String nodeName = object.getSerializedObjectName();
        NamespaceDetails details = NamespaceDetailsFactory.getInstance().getNamespaceDetails(this, namespace);
        if (details != null && !"".equals(details.getShortName(namespace))) {
            nodeName = details.getShortName(namespace) + ":" + nodeName;
        }
        Element node = this.currentChangeLogFileDOM.createElementNS(namespace, nodeName);
        try {
            for (String field : object.getSerializableFields()) {
                this.setValueOnNode(node, object.getSerializableFieldNamespace(field), field, object.getSerializableFieldValue(field), object.getSerializableFieldType(field), namespace);
            }
        }
        catch (UnexpectedLiquibaseException e2) {
            if (object instanceof ChangeSet && e2.getMessage().startsWith(INVALID_STRING_ENCODING_MESSAGE)) {
                throw new UnexpectedLiquibaseException(e2.getMessage() + " in changeSet " + ((ChangeSet)object).toString(false) + ". To resolve, remove the invalid character on the database and try again");
            }
            throw e2;
        }
        return node;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setValueOnNode(Element node, String objectNamespace, String objectName, Object value, LiquibaseSerializable.SerializationType serializationType, String parentNamespace) {
        if (value == null) {
            return;
        }
        if (value instanceof Collection) {
            for (Object child : (Collection)value) {
                this.setValueOnNode(node, objectNamespace, objectName, child, serializationType, parentNamespace);
            }
            return;
        } else if (value instanceof Map) {
            for (Map.Entry entry : ((Map)value).entrySet()) {
                Element mapNode = this.currentChangeLogFileDOM.createElementNS("http://www.liquibase.org/xml/ns/dbchangelog", this.qualifyName(objectName, objectNamespace, parentNamespace));
                if (serializationType == LiquibaseSerializable.SerializationType.NESTED_OBJECT) {
                    this.setValueOnNode(mapNode, objectNamespace, (String)entry.getKey(), entry.getValue(), serializationType, objectNamespace);
                } else {
                    this.setValueOnNode(mapNode, objectNamespace, "name", entry.getKey(), LiquibaseSerializable.SerializationType.NAMED_FIELD, objectNamespace);
                    this.setValueOnNode(mapNode, objectNamespace, "value", entry.getValue(), serializationType, objectNamespace);
                }
                node.appendChild(mapNode);
            }
            return;
        } else if (value instanceof LiquibaseSerializable) {
            node.appendChild(this.createNode((LiquibaseSerializable)value));
            return;
        } else if (value instanceof Object[]) {
            if (serializationType.equals((Object)LiquibaseSerializable.SerializationType.NESTED_OBJECT)) {
                String namespace = "http://www.liquibase.org/xml/ns/dbchangelog";
                Element newNode = this.createNode(namespace, objectName, "");
                for (Object child : (Object[])value) {
                    this.setValueOnNode(newNode, namespace, objectName, child, serializationType, parentNamespace);
                }
                node.appendChild(newNode);
                return;
            } else {
                for (Object child : (Object[])value) {
                    this.setValueOnNode(node, objectNamespace, objectName, child, serializationType, parentNamespace);
                }
            }
            return;
        } else if (serializationType.equals((Object)LiquibaseSerializable.SerializationType.NESTED_OBJECT)) {
            String namespace = "http://www.liquibase.org/xml/ns/dbchangelog";
            node.appendChild(this.createNode(namespace, objectName, value.toString()));
            return;
        } else if (serializationType.equals((Object)LiquibaseSerializable.SerializationType.DIRECT_VALUE)) {
            try {
                node.setTextContent(this.checkString(value.toString()));
                return;
            }
            catch (UnexpectedLiquibaseException e2) {
                if (!e2.getMessage().startsWith(INVALID_STRING_ENCODING_MESSAGE)) return;
                throw new UnexpectedLiquibaseException(e2.getMessage() + " in text of " + node.getTagName() + ". To resolve, remove the invalid character on the database and try again");
            }
        } else {
            String attributeName = this.qualifyName(objectName, objectNamespace, parentNamespace);
            try {
                node.setAttribute(attributeName, this.checkString(value.toString()));
                return;
            }
            catch (UnexpectedLiquibaseException e3) {
                if (!e3.getMessage().startsWith(INVALID_STRING_ENCODING_MESSAGE)) return;
                throw new UnexpectedLiquibaseException(e3.getMessage() + " on " + node.getTagName() + "." + attributeName + ". To resolve, remove the invalid character on the database and try again");
            }
        }
    }

    protected String checkString(String text) throws UnexpectedLiquibaseException {
        if (null == text || text.isEmpty()) {
            return text;
        }
        int len = text.length();
        for (int i2 = 0; i2 < len; ++i2) {
            int current = text.charAt(i2);
            int codePoint = Character.isHighSurrogate((char)current) && i2 + 1 < len && Character.isLowSurrogate(text.charAt(i2 + 1)) ? text.codePointAt(i2++) : current;
            if (codePoint == 10 || codePoint == 13 || codePoint == 9 || codePoint == 11 || codePoint == 12 || codePoint >= 32 && codePoint <= 126 || codePoint >= 160 && codePoint <= 55295 || codePoint >= 57344 && codePoint <= 65533 || codePoint >= 65536 && codePoint <= 0x10FFFF) continue;
            throw new UnexpectedLiquibaseException(INVALID_STRING_ENCODING_MESSAGE);
        }
        return text;
    }

    private String qualifyName(String objectName, String objectNamespace, String parentNamespace) {
        if (objectNamespace != null && !objectNamespace.equals("http://www.liquibase.org/xml/ns/dbchangelog") && !objectNamespace.equals(parentNamespace)) {
            NamespaceDetails details = NamespaceDetailsFactory.getInstance().getNamespaceDetails(this, objectNamespace);
            return details.getShortName(objectNamespace) + ":" + objectName;
        }
        return objectName;
    }

    public Element createNode(String nodeNamespace, String nodeName, String nodeContent) {
        Element element = this.currentChangeLogFileDOM.createElementNS(nodeNamespace, nodeName);
        element.setTextContent(nodeContent);
        return element;
    }

    public Element createNode(ColumnConfig columnConfig) {
        ConstraintsConfig constraints;
        Element element = this.currentChangeLogFileDOM.createElementNS(columnConfig.getSerializedObjectNamespace(), "column");
        if (columnConfig.getName() != null) {
            element.setAttribute("name", columnConfig.getName());
        }
        if (columnConfig.getType() != null) {
            element.setAttribute("type", columnConfig.getType());
        }
        if (columnConfig.getDefaultValue() != null) {
            element.setAttribute("defaultValue", columnConfig.getDefaultValue());
        }
        if (columnConfig.getDefaultValueNumeric() != null) {
            element.setAttribute("defaultValueNumeric", columnConfig.getDefaultValueNumeric().toString());
        }
        if (columnConfig.getDefaultValueDate() != null) {
            element.setAttribute("defaultValueDate", new ISODateFormat().format(columnConfig.getDefaultValueDate()));
        }
        if (columnConfig.getDefaultValueBoolean() != null) {
            element.setAttribute("defaultValueBoolean", columnConfig.getDefaultValueBoolean().toString());
        }
        if (columnConfig.getDefaultValueComputed() != null) {
            element.setAttribute("defaultValueComputed", columnConfig.getDefaultValueComputed().toString());
        }
        if (columnConfig.getDefaultValueSequenceNext() != null) {
            element.setAttribute("defaultValueSequenceNext", columnConfig.getDefaultValueSequenceNext().toString());
        }
        if (columnConfig.getValue() != null) {
            element.setAttribute("value", columnConfig.getValue());
        }
        if (columnConfig.getValueNumeric() != null) {
            element.setAttribute("valueNumeric", columnConfig.getValueNumeric().toString());
        }
        if (columnConfig.getValueBoolean() != null) {
            element.setAttribute("valueBoolean", columnConfig.getValueBoolean().toString());
        }
        if (columnConfig.getValueDate() != null) {
            element.setAttribute("valueDate", new ISODateFormat().format(columnConfig.getValueDate()));
        }
        if (columnConfig.getValueComputed() != null) {
            element.setAttribute("valueComputed", columnConfig.getValueComputed().toString());
        }
        if (columnConfig.getValueSequenceNext() != null) {
            element.setAttribute("valueSequenceNext", columnConfig.getValueSequenceNext().toString());
        }
        if (columnConfig.getValueSequenceCurrent() != null) {
            element.setAttribute("valueSequenceNext", columnConfig.getValueSequenceCurrent().toString());
        }
        if (StringUtil.trimToNull(columnConfig.getRemarks()) != null) {
            element.setAttribute("remarks", columnConfig.getRemarks());
        }
        if (columnConfig.isAutoIncrement() != null && columnConfig.isAutoIncrement().booleanValue()) {
            element.setAttribute("autoIncrement", "true");
        }
        if ((constraints = columnConfig.getConstraints()) != null) {
            Element constraintsElement = this.currentChangeLogFileDOM.createElementNS(columnConfig.getSerializedObjectNamespace(), "constraints");
            if (constraints.getCheckConstraint() != null) {
                constraintsElement.setAttribute("checkConstraint", constraints.getCheckConstraint());
            }
            if (constraints.getForeignKeyName() != null) {
                constraintsElement.setAttribute("foreignKeyName", constraints.getForeignKeyName());
            }
            if (constraints.getReferences() != null) {
                constraintsElement.setAttribute("references", constraints.getReferences());
            }
            if (constraints.getReferencedTableName() != null) {
                constraintsElement.setAttribute("referencedTableName", constraints.getReferencedTableName());
            }
            if (constraints.getReferencedColumnNames() != null) {
                constraintsElement.setAttribute("referencedColumnNames", constraints.getReferencedColumnNames());
            }
            if (constraints.isDeferrable() != null) {
                constraintsElement.setAttribute("deferrable", constraints.isDeferrable().toString());
            }
            if (constraints.getValidateNullable() != null) {
                constraintsElement.setAttribute("validateNullable", constraints.getValidateNullable().toString());
            }
            if (constraints.getValidateUnique() != null) {
                constraintsElement.setAttribute("validateUnique", constraints.getValidateUnique().toString());
            }
            if (constraints.getValidatePrimaryKey() != null) {
                constraintsElement.setAttribute("validatePrimaryKey", constraints.getValidatePrimaryKey().toString());
            }
            if (constraints.getValidateForeignKey() != null) {
                constraintsElement.setAttribute("validateForeignKey", constraints.getValidateForeignKey().toString());
            }
            if (constraints.isDeleteCascade() != null) {
                constraintsElement.setAttribute("deleteCascade", constraints.isDeleteCascade().toString());
            }
            if (constraints.isInitiallyDeferred() != null) {
                constraintsElement.setAttribute("initiallyDeferred", constraints.isInitiallyDeferred().toString());
            }
            if (constraints.isNullable() != null) {
                constraintsElement.setAttribute("nullable", constraints.isNullable().toString());
            }
            if (constraints.isPrimaryKey() != null) {
                constraintsElement.setAttribute("primaryKey", constraints.isPrimaryKey().toString());
            }
            if (constraints.isUnique() != null) {
                constraintsElement.setAttribute("unique", constraints.isUnique().toString());
            }
            if (constraints.getUniqueConstraintName() != null) {
                constraintsElement.setAttribute("uniqueConstraintName", constraints.getUniqueConstraintName());
            }
            if (constraints.getPrimaryKeyName() != null) {
                constraintsElement.setAttribute("primaryKeyName", constraints.getPrimaryKeyName());
            }
            if (constraints.getPrimaryKeyTablespace() != null) {
                constraintsElement.setAttribute("primaryKeyTablespace", constraints.getPrimaryKeyTablespace());
            }
            if (constraints.getNotNullConstraintName() != null) {
                constraintsElement.setAttribute("notNullConstraintName", constraints.getNotNullConstraintName());
            }
            if (constraints.getReferencedTableCatalogName() != null) {
                constraintsElement.setAttribute("referencedTableCatalogName", constraints.getReferencedTableCatalogName());
            }
            if (constraints.getReferencedTableSchemaName() != null) {
                constraintsElement.setAttribute("referencedTableSchemaName", constraints.getReferencedTableSchemaName());
            }
            element.appendChild(constraintsElement);
        }
        return element;
    }

    private void nodeToStringBuilder(Node node, StringBuilder buffer, int indent) {
        boolean bl2;
        if (indent >= 0) {
            if (indent > 0) {
                buffer.append("\n");
            }
            buffer.append(StringUtil.repeat(" ", indent));
        }
        buffer.append("<").append(node.getNodeName());
        TreeMap<String, String> attributeMap = new TreeMap<String, String>();
        NamedNodeMap attributes = node.getAttributes();
        for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            Node attribute = attributes.item(i2);
            attributeMap.put(attribute.getNodeName(), attribute.getNodeValue());
        }
        boolean firstAttribute = true;
        for (Map.Entry entry : attributeMap.entrySet()) {
            String value = (String)entry.getValue();
            if (value == null) continue;
            if (indent >= 0 && !firstAttribute && attributeMap.size() > 2) {
                buffer.append("\n").append(StringUtil.repeat(" ", indent)).append("        ");
            } else {
                buffer.append(" ");
            }
            buffer.append(entry.getKey()).append("=\"").append(value).append("\"");
            firstAttribute = false;
        }
        String textContent = StringUtil.trimToEmpty(XMLUtil.getTextContent(node));
        textContent = this.escapeXml(textContent);
        buffer.append(">").append(textContent);
        boolean bl3 = false;
        NodeList childNodes = node.getChildNodes();
        for (int i3 = 0; i3 < childNodes.getLength(); ++i3) {
            Node childNode = childNodes.item(i3);
            if (!(childNode instanceof Element)) continue;
            int newIndent = indent;
            if (newIndent >= 0) {
                newIndent += 4;
            }
            this.nodeToStringBuilder(childNode, buffer, newIndent);
            bl2 = true;
        }
        if (indent >= 0 && bl2) {
            buffer.append("\n").append(StringUtil.repeat(" ", indent));
        }
        if (!bl2 && "".equals(textContent)) {
            buffer.replace(buffer.length() - 1, buffer.length(), "/>");
        } else {
            buffer.append("</").append(node.getNodeName()).append(">");
        }
    }

    @Override
    public int getPriority() {
        return 1;
    }

    public String escapeXml(String valueToEscape) {
        return valueToEscape;
    }
}

