/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.impl;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;

public class IdentifierMap<V>
extends ForwardingMap<String, V> {
    private final HashMap<String, V> delegate;

    public IdentifierMap() {
        this.delegate = Maps.newHashMap();
    }

    public IdentifierMap(int expectedSize) {
        this.delegate = Maps.newHashMapWithExpectedSize((int)expectedSize);
    }

    protected Map<String, V> delegate() {
        return this.delegate;
    }

    private Object lowercase(Object key) {
        return key instanceof String ? IdentifierUtils.toLowerCase((String)key) : key;
    }

    public V remove(Object key) {
        return this.delegate().remove(this.lowercase(key));
    }

    public boolean containsKey(Object key) {
        return this.delegate().containsKey(this.lowercase(key));
    }

    public V get(Object key) {
        return this.delegate().get(this.lowercase(key));
    }

    public V put(String key, V value) {
        return this.delegate().put((String)this.lowercase(key), value);
    }

    public void putAll(Map<? extends String, ? extends V> map) {
        HashMap lowercaseMap = Maps.newHashMapWithExpectedSize((int)map.size());
        for (Map.Entry<String, V> entry : map.entrySet()) {
            lowercaseMap.put((String)this.lowercase(entry.getKey()), entry.getValue());
        }
        this.delegate().putAll(lowercaseMap);
    }
}

