/*
 * Decompiled with CFR 0.152.
 */
package akka.http.impl.engine.http2;

import akka.annotation.InternalApi;
import akka.http.impl.engine.http2.Http2$;
import akka.http.impl.engine.http2.Http2SubStream;
import akka.http.impl.engine.parsing.HttpHeaderParser;
import akka.http.impl.engine.server.HttpAttributes;
import akka.http.javadsl.model.AttributeKey;
import akka.http.scaladsl.model.AttributeKeys$;
import akka.http.scaladsl.model.ContentType;
import akka.http.scaladsl.model.ContentType$;
import akka.http.scaladsl.model.ErrorInfo;
import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.HttpMethod;
import akka.http.scaladsl.model.HttpMethods$;
import akka.http.scaladsl.model.HttpProtocols$;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpRequest$;
import akka.http.scaladsl.model.IllegalUriException;
import akka.http.scaladsl.model.ParsingException;
import akka.http.scaladsl.model.RemoteAddress;
import akka.http.scaladsl.model.RemoteAddress$;
import akka.http.scaladsl.model.RequestEntity;
import akka.http.scaladsl.model.SslSessionInfo$;
import akka.http.scaladsl.model.Uri;
import akka.http.scaladsl.model.Uri$;
import akka.http.scaladsl.model.Uri$Authority$;
import akka.http.scaladsl.model.headers.Remote$minusAddress;
import akka.http.scaladsl.model.headers.Tls$minusSession$minusInfo;
import akka.http.scaladsl.settings.ServerSettings;
import akka.parboiled2.ParserInput;
import akka.parboiled2.ParserInput$;
import akka.stream.Attributes;
import akka.util.ByteString;
import akka.util.ByteString$;
import akka.util.OptionVal;
import akka.util.OptionVal$;
import java.io.Serializable;
import java.nio.charset.Charset;
import javax.net.ssl.SSLSession;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.VectorBuilder;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@InternalApi
public final class RequestParsing$ {
    public static final RequestParsing$ MODULE$ = new RequestParsing$();

    public Function1<Http2SubStream, HttpRequest> parseRequest(HttpHeaderParser httpHeaderParser, ServerSettings serverSettings, Attributes streamAttributes) {
        None$ remoteAddressHeader = serverSettings.remoteAddressHeader() ? streamAttributes.get(ClassTag$.MODULE$.apply(HttpAttributes.RemoteAddress.class)).map((Function1 & Serializable)remote -> new Remote$minusAddress(RemoteAddress$.MODULE$.apply(remote.address()))) : None$.MODULE$;
        None$ remoteAddressAttribute = serverSettings.remoteAddressAttribute() ? streamAttributes.get(ClassTag$.MODULE$.apply(HttpAttributes.RemoteAddress.class)).map((Function1 & Serializable)remote -> RemoteAddress$.MODULE$.apply(remote.address())) : None$.MODULE$;
        None$ tlsSessionInfoHeader = serverSettings.parserSettings().includeTlsSessionInfoHeader() ? streamAttributes.get(ClassTag$.MODULE$.apply(HttpAttributes.TLSSessionInfo.class)).map((Function1 & Serializable)sslSessionInfo -> new Tls$minusSession$minusInfo(sslSessionInfo.session())) : None$.MODULE$;
        None$ sslSessionAttribute = serverSettings.parserSettings().includeSslSessionAttribute() ? streamAttributes.get(ClassTag$.MODULE$.apply(HttpAttributes.TLSSessionInfo.class)).map((Function1 & Serializable)x$1 -> x$1.session()) : None$.MODULE$;
        return arg_0 -> RequestParsing$.$anonfun$parseRequest$5(this, httpHeaderParser, (Option)remoteAddressHeader, (Option)tlsSessionInfoHeader, (Option)sslSessionAttribute, (Option)remoteAddressAttribute, serverSettings, arg_0);
    }

    public HttpHeader parseHeaderPair(HttpHeaderParser httpHeaderParser, String name, String value) {
        String concHeaderLine = new java.lang.StringBuilder(5).append(name).append(": ").append(value).append("\r\nx").toString();
        ByteString x$1 = ByteString$.MODULE$.apply(concHeaderLine);
        int x$2 = httpHeaderParser.parseHeaderLine$default$2();
        int x$3 = httpHeaderParser.parseHeaderLine$default$3(x$1, x$2);
        int x$4 = httpHeaderParser.parseHeaderLine$default$4(x$1, x$2);
        httpHeaderParser.parseHeaderLine(x$1, x$2, x$3, x$4);
        return httpHeaderParser.resultHeader();
    }

    public void checkRequiredPseudoHeader(String name, Object value) {
        if (value == null) {
            throw this.malformedRequest(new java.lang.StringBuilder(34).append("Mandatory pseudo-header '").append(name).append("' missing").toString());
        }
    }

    public void checkUniquePseudoHeader(String name, Object value) {
        if (value != null) {
            throw this.malformedRequest(new java.lang.StringBuilder(46).append("Pseudo-header '").append(name).append("' must not occur more than once").toString());
        }
    }

    public void checkNoRegularHeadersBeforePseudoHeader(String name, boolean seenRegularHeader) {
        if (seenRegularHeader) {
            throw this.malformedRequest(new java.lang.StringBuilder(61).append("Pseudo-header field '").append(name).append("' must not appear after a regular header").toString());
        }
    }

    public Nothing$ malformedRequest(String msg) {
        throw new RuntimeException(new java.lang.StringBuilder(19).append("Malformed request: ").append(msg).toString());
    }

    public void validateHeader(HttpHeader httpHeader) {
        block7: {
            block8: {
                block9: {
                    String string = httpHeader.lowercaseName();
                    switch (string == null ? 0 : string.hashCode()) {
                        case -775651618: {
                            if ("connection".equals(string)) {
                                break;
                            }
                            break block7;
                        }
                        case 3697: {
                            if (!"te".equals(string)) break block7;
                            break block8;
                        }
                        case 1274458357: {
                            if (!"transfer-encoding".equals(string)) break block7;
                            break block9;
                        }
                        default: {
                            break block7;
                        }
                    }
                    throw this.malformedRequest("Header 'Connection' must not be used with HTTP/2");
                }
                throw this.malformedRequest("Header 'Transfer-Encoding' must not be used with HTTP/2");
            }
            if (httpHeader.value().compareToIgnoreCase("trailers") != 0) {
                throw this.malformedRequest(new java.lang.StringBuilder(69).append("Header 'TE' must not contain value other than 'trailers', value was '").append(httpHeader.value()).toString());
            }
        }
    }

    private final HttpRequest rec$1(Seq remainingHeaders, HttpMethod method, String scheme, Uri.Authority authority, Tuple2 pathAndRawQuery, ContentType contentType, long contentLength, StringBuilder cookies, boolean seenRegularHeader, VectorBuilder headers2, HttpHeaderParser httpHeaderParser$1, Option remoteAddressHeader$1, Option tlsSessionInfoHeader$1, Http2SubStream subStream$1, Option sslSessionAttribute$1, Option remoteAddressAttribute$1, ServerSettings serverSettings$1) {
        HttpRequest httpRequest;
        block33: {
            Tuple2 tuple2;
            while (true) {
                String string;
                if (remainingHeaders.isEmpty()) {
                    HttpRequest httpRequest2;
                    this.checkRequiredPseudoHeader(":scheme", scheme);
                    this.checkRequiredPseudoHeader(":method", method);
                    this.checkRequiredPseudoHeader(":path", pathAndRawQuery);
                    Object object = cookies != null ? headers2.$plus$eq((Object)this.parseHeaderPair(httpHeaderParser$1, "cookie", cookies.toString())) : BoxedUnit.UNIT;
                    Object object2 = remoteAddressHeader$1.isDefined() ? headers2.$plus$eq(remoteAddressHeader$1.get()) : BoxedUnit.UNIT;
                    Object object3 = tlsSessionInfoHeader$1.isDefined() ? headers2.$plus$eq(tlsSessionInfoHeader$1.get()) : BoxedUnit.UNIT;
                    RequestEntity entity = subStream$1.createEntity(contentLength, contentType);
                    Tuple2<Uri.Path, Option<String>> tuple22 = pathAndRawQuery;
                    if (tuple22 == null) {
                        throw new MatchError((Object)tuple22);
                    }
                    Uri.Path path = (Uri.Path)tuple22._1();
                    Option rawQueryString = (Option)tuple22._2();
                    Tuple2 tuple23 = new Tuple2((Object)path, (Object)rawQueryString);
                    Tuple2 tuple24 = tuple23;
                    Uri.Path path2 = (Uri.Path)tuple24._1();
                    Option rawQueryString2 = (Option)tuple24._2();
                    Uri.Authority authorityOrDefault = authority == null ? Uri$Authority$.MODULE$.Empty() : authority;
                    Uri uri = Uri$.MODULE$.apply(scheme, authorityOrDefault, path2, (Option<String>)rawQueryString2, Uri$.MODULE$.apply$default$5());
                    HttpRequest request = (HttpRequest)HttpRequest$.MODULE$.apply(method, uri, (Seq<HttpHeader>)headers2.result(), entity, HttpProtocols$.MODULE$.HTTP$div2$u002E0()).addAttribute((AttributeKey)Http2$.MODULE$.streamId(), BoxesRunTime.boxToInteger((int)subStream$1.streamId()));
                    Option option = sslSessionAttribute$1;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        SSLSession sslSession = (SSLSession)some.value();
                        httpRequest2 = (HttpRequest)request.addAttribute((AttributeKey)AttributeKeys$.MODULE$.sslSession(), SslSessionInfo$.MODULE$.apply(sslSession));
                    } else if (None$.MODULE$.equals(option)) {
                        httpRequest2 = request;
                    } else {
                        throw new MatchError((Object)option);
                    }
                    HttpRequest requestWithSession = httpRequest2;
                    Option option2 = remoteAddressAttribute$1;
                    if (option2 instanceof Some) {
                        Some some = (Some)option2;
                        RemoteAddress remoteAddress = (RemoteAddress)some.value();
                        httpRequest = (HttpRequest)requestWithSession.addAttribute((AttributeKey)AttributeKeys$.MODULE$.remoteAddress(), remoteAddress);
                        break block33;
                    }
                    if (None$.MODULE$.equals(option2)) {
                        httpRequest = requestWithSession;
                        break block33;
                    }
                    throw new MatchError((Object)option2);
                }
                tuple2 = (Tuple2)remainingHeaders.head();
                if (tuple2 != null) {
                    String string2 = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    if (":scheme".equals(string2)) {
                        this.checkUniquePseudoHeader(":scheme", scheme);
                        this.checkNoRegularHeadersBeforePseudoHeader(":scheme", seenRegularHeader);
                        scheme = value;
                        remainingHeaders = (Seq)remainingHeaders.tail();
                        continue;
                    }
                }
                if (tuple2 != null) {
                    String string3 = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    if (":method".equals(string3)) {
                        HttpMethod m;
                        this.checkUniquePseudoHeader(":method", method);
                        this.checkNoRegularHeadersBeforePseudoHeader(":method", seenRegularHeader);
                        method = m = (HttpMethod)HttpMethods$.MODULE$.getForKey(value).orElse((Function0 & Serializable)() -> (Option)serverSettings$1.parserSettings().customMethods().apply((Object)value)).getOrElse((Function0 & Serializable)() -> MODULE$.malformedRequest(new java.lang.StringBuilder(23).append("Unknown HTTP method: '").append(value).append("'").toString()));
                        remainingHeaders = (Seq)remainingHeaders.tail();
                        continue;
                    }
                }
                if (tuple2 != null) {
                    String string4 = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    if (":path".equals(string4)) {
                        Tuple2<Uri.Path, Option<String>> newPathAndRawQuery;
                        Tuple2<Uri.Path, Option<String>> tuple25;
                        this.checkUniquePseudoHeader(":path", pathAndRawQuery);
                        this.checkNoRegularHeadersBeforePseudoHeader(":path", seenRegularHeader);
                        try {
                            ParserInput.StringBasedParserInput x$1 = ParserInput$.MODULE$.apply(value);
                            Uri.ParsingMode x$2 = serverSettings$1.parserSettings().uriParsingMode();
                            Charset x$3 = Uri$.MODULE$.parseHttp2PathPseudoHeader$default$2();
                            tuple25 = Uri$.MODULE$.parseHttp2PathPseudoHeader((ParserInput)x$1, x$3, x$2);
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2 = throwable;
                            if (throwable2 instanceof IllegalUriException) {
                                IllegalUriException illegalUriException = (IllegalUriException)throwable2;
                                ErrorInfo info = illegalUriException.info();
                                throw new ParsingException(info);
                            }
                            throw throwable;
                        }
                        pathAndRawQuery = newPathAndRawQuery = tuple25;
                        remainingHeaders = (Seq)remainingHeaders.tail();
                        continue;
                    }
                }
                if (tuple2 != null) {
                    String string5 = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    if (":authority".equals(string5)) {
                        Uri.Authority newAuthority;
                        Uri.Authority authority2;
                        this.checkUniquePseudoHeader(":authority", authority);
                        this.checkNoRegularHeadersBeforePseudoHeader(":authority", seenRegularHeader);
                        try {
                            ParserInput.StringBasedParserInput x$4 = ParserInput$.MODULE$.apply(value);
                            Uri.ParsingMode x$5 = serverSettings$1.parserSettings().uriParsingMode();
                            Charset x$6 = Uri$.MODULE$.parseHttp2AuthorityPseudoHeader$default$2();
                            authority2 = Uri$.MODULE$.parseHttp2AuthorityPseudoHeader((ParserInput)x$4, x$6, x$5);
                        }
                        catch (Throwable throwable) {
                            Throwable throwable3 = throwable;
                            if (throwable3 instanceof IllegalUriException) {
                                IllegalUriException illegalUriException = (IllegalUriException)throwable3;
                                ErrorInfo info = illegalUriException.info();
                                throw new ParsingException(info);
                            }
                            throw throwable;
                        }
                        authority = newAuthority = authority2;
                        remainingHeaders = (Seq)remainingHeaders.tail();
                        continue;
                    }
                }
                if (tuple2 != null && ":status".equals(string = (String)tuple2._1())) {
                    throw this.malformedRequest("Pseudo-header ':status' is for responses only; it cannot appear in a request");
                }
                if (tuple2 != null) {
                    String string6 = (String)tuple2._1();
                    String ct = (String)tuple2._2();
                    if ("content-type".equals(string6)) {
                        if (OptionVal$.MODULE$.isEmpty$extension((Object)contentType)) {
                            ContentType contentTypeValue = (ContentType)ContentType$.MODULE$.parse(ct).right().getOrElse((Function0 & Serializable)() -> MODULE$.malformedRequest(new java.lang.StringBuilder(24).append("Invalid content-type: '").append(ct).append("'").toString()));
                            seenRegularHeader = true;
                            contentType = (ContentType)OptionVal.Some$.MODULE$.apply((Object)contentTypeValue);
                            remainingHeaders = (Seq)remainingHeaders.tail();
                            continue;
                        }
                        throw this.malformedRequest("HTTP message must not contain more than one content-type header");
                    }
                }
                if (tuple2 != null) {
                    String string7 = (String)tuple2._1();
                    String length = (String)tuple2._2();
                    if ("content-length".equals(string7)) {
                        if (contentLength == -1L) {
                            long contentLengthValue = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(length));
                            if (contentLengthValue < 0L) {
                                throw this.malformedRequest("HTTP message must not contain a negative content-length header");
                            }
                            seenRegularHeader = true;
                            contentLength = contentLengthValue;
                            remainingHeaders = (Seq)remainingHeaders.tail();
                            continue;
                        }
                        throw this.malformedRequest("HTTP message must not contain more than one content-length header");
                    }
                }
                if (tuple2 != null) {
                    String string8 = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    if ("cookie".equals(string8)) {
                        StringBuilder cookiesBuilder = cookies == null ? new StringBuilder() : cookies.append("; ");
                        cookiesBuilder.append(value);
                        seenRegularHeader = true;
                        cookies = cookiesBuilder;
                        remainingHeaders = (Seq)remainingHeaders.tail();
                        continue;
                    }
                }
                if (tuple2 == null) break;
                String name = (String)tuple2._1();
                String value = (String)tuple2._2();
                HttpHeader httpHeader = this.parseHeaderPair(httpHeaderParser$1, name, value);
                this.validateHeader(httpHeader);
                headers2 = (VectorBuilder)headers2.$plus$eq((Object)httpHeader);
                seenRegularHeader = true;
                remainingHeaders = (Seq)remainingHeaders.tail();
            }
            throw new MatchError((Object)tuple2);
        }
        return httpRequest;
    }

    private static final HttpMethod rec$default$2$1() {
        return null;
    }

    private static final String rec$default$3$1() {
        return null;
    }

    private static final Uri.Authority rec$default$4$1() {
        return null;
    }

    private static final Tuple2 rec$default$5$1() {
        return null;
    }

    private static final ContentType rec$default$6$1() {
        OptionVal$.MODULE$.None();
        return null;
    }

    private static final long rec$default$7$1() {
        return -1L;
    }

    private static final StringBuilder rec$default$8$1() {
        return null;
    }

    private static final boolean rec$default$9$1() {
        return false;
    }

    private static final VectorBuilder rec$default$10$1() {
        return new VectorBuilder();
    }

    public static final /* synthetic */ HttpRequest $anonfun$parseRequest$5(RequestParsing$ $this, HttpHeaderParser httpHeaderParser$1, Option remoteAddressHeader$1, Option tlsSessionInfoHeader$1, Option sslSessionAttribute$1, Option remoteAddressAttribute$1, ServerSettings serverSettings$1, Http2SubStream subStream) {
        Seq<Tuple2<String, String>> remainingHeaders = subStream.initialHeaders().keyValuePairs();
        if (remainingHeaders.size() > serverSettings$1.parserSettings().maxHeaderCount()) {
            throw MODULE$.malformedRequest(new java.lang.StringBuilder(64).append("HTTP message contains more than the configured limit of ").append(serverSettings$1.parserSettings().maxHeaderCount()).append(" headers").toString());
        }
        return $this.rec$1(remainingHeaders, RequestParsing$.rec$default$2$1(), RequestParsing$.rec$default$3$1(), RequestParsing$.rec$default$4$1(), RequestParsing$.rec$default$5$1(), RequestParsing$.rec$default$6$1(), RequestParsing$.rec$default$7$1(), RequestParsing$.rec$default$8$1(), RequestParsing$.rec$default$9$1(), RequestParsing$.rec$default$10$1(), httpHeaderParser$1, remoteAddressHeader$1, tlsSessionInfoHeader$1, subStream, sslSessionAttribute$1, remoteAddressAttribute$1, serverSettings$1);
    }

    private RequestParsing$() {
    }
}

