/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.trigger.change;

import com.datical.liquibase.ext.storedlogic.trigger.Trigger;
import com.datical.liquibase.ext.storedlogic.trigger.change.EnableTriggerStatement;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.structure.DatabaseObject;

public class EnableTriggerGenerator
extends AbstractSqlGenerator<EnableTriggerStatement> {
    @Override
    public boolean supports(EnableTriggerStatement enableTriggerStatement, Database database) {
        return database instanceof OracleDatabase || database instanceof MSSQLDatabase || database instanceof PostgresDatabase;
    }

    @Override
    public ValidationErrors validate(EnableTriggerStatement enableTriggerStatement, Database database, SqlGeneratorChain object) {
        object = new ValidationErrors();
        ((ValidationErrors)object).checkDisallowedField("catalogName", enableTriggerStatement.getCatalogName(), database, MSSQLDatabase.class);
        ((ValidationErrors)object).checkRequiredField("triggerName", enableTriggerStatement.getTriggerName());
        if (database instanceof MSSQLDatabase) {
            if (enableTriggerStatement.getScope() != null && !enableTriggerStatement.getScope().equalsIgnoreCase("CATALOG") && !enableTriggerStatement.getScope().equalsIgnoreCase("TABLE")) {
                ((ValidationErrors)object).addError("Invalid enableTrigger scope: " + enableTriggerStatement.getScope());
                if (enableTriggerStatement.getTableName() != null && enableTriggerStatement.getScope().equalsIgnoreCase("CATALOG")) {
                    ((ValidationErrors)object).addError("Cannot specify tableName and scope != TABLE");
                }
            }
            if ((enableTriggerStatement.getScope() == null || enableTriggerStatement.getScope().equals("TABLE")) && enableTriggerStatement.getTableName() == null) {
                ((ValidationErrors)object).checkRequiredField("tableName", enableTriggerStatement.getTableName());
            }
        }
        if (database instanceof PostgresDatabase) {
            ((ValidationErrors)object).checkRequiredField("tableName", enableTriggerStatement.getTableName());
        }
        return object;
    }

    @Override
    public Sql[] generateSql(EnableTriggerStatement object, Database database, SqlGeneratorChain object2) {
        object2 = new StringBuilder();
        if (database instanceof OracleDatabase) {
            ((StringBuilder)object2).append("ALTER TRIGGER ");
            if (((EnableTriggerStatement)object).getTriggerName() == null) {
                throw new IllegalStateException("Sorry but triggerName must be set");
            }
            ((StringBuilder)object2).append(database.escapeObjectName(null, ((EnableTriggerStatement)object).getSchemaName(), ((EnableTriggerStatement)object).getTriggerName(), Trigger.class)).append(" ");
            ((StringBuilder)object2).append("ENABLE");
        } else if (database instanceof PostgresDatabase) {
            ((StringBuilder)object2).append("ALTER TABLE ");
            ((StringBuilder)object2).append(database.escapeObjectName(null, ((EnableTriggerStatement)object).getSchemaName(), ((EnableTriggerStatement)object).getTableName(), Trigger.class)).append(" ");
            ((StringBuilder)object2).append(" ENABLE TRIGGER ");
            ((StringBuilder)object2).append(((EnableTriggerStatement)object).getTriggerName());
        } else {
            ((StringBuilder)object2).append("ENABLE TRIGGER ");
            if (((EnableTriggerStatement)object).getTriggerName() == null) {
                throw new IllegalStateException("Sorry but triggerName must be set");
            }
            ((StringBuilder)object2).append(database.escapeObjectName(null, ((EnableTriggerStatement)object).getSchemaName(), ((EnableTriggerStatement)object).getTriggerName(), Trigger.class)).append(" ");
            ((StringBuilder)object2).append(" ON ");
            if (((EnableTriggerStatement)object).getScope() != null && ((EnableTriggerStatement)object).getScope().equalsIgnoreCase("CATALOG")) {
                ((StringBuilder)object2).append("DATABASE");
            } else {
                ((StringBuilder)object2).append(database.escapeTableName(((EnableTriggerStatement)object).getCatalogName(), ((EnableTriggerStatement)object).getSchemaName(), ((EnableTriggerStatement)object).getTableName()));
            }
        }
        object = new UnparsedSql(((StringBuilder)object2).toString(), new DatabaseObject[0]);
        return new Sql[]{object};
    }
}

