/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.application.cluster.server;

import io.netty.channel.Channel;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.rzo.netty.ahessian.application.cluster.server.MemberImpl;
import org.rzo.netty.ahessian.application.cluster.server.SeedClusterService;
import org.rzo.netty.ahessian.application.cluster.service.ClusterService;
import org.rzo.netty.ahessian.rpc.server.HessianSkeleton;

public class ClusterServiceImpl
implements SeedClusterService {
    String _clusterName;
    Map<String, ClusterService.Member> _members = new ConcurrentHashMap<String, ClusterService.Member>();
    Map<String, ClusterService.Member> _joinedSeeds = new ConcurrentHashMap<String, ClusterService.Member>();
    Map<String, Channel> _channels = new ConcurrentHashMap<String, Channel>();
    Map<String, String> _channel2member = new ConcurrentHashMap<String, String>();
    Map<String, ClusterService.ClusterEventListener> _listners = new ConcurrentHashMap<String, ClusterService.ClusterEventListener>();
    ClusterService.Member _server;

    public void setServer(ClusterService.Member server) {
        this._server = server;
        this._members.put(this._server.getName(), server);
    }

    public void setClusterName(String name) {
        this._clusterName = name;
    }

    @Override
    public synchronized void join(String clusterName, String clientName, Object data, ClusterService.ClusterEventListener listener) {
        System.out.println("+join " + clientName + " " + System.currentTimeMillis());
        Channel channel = this.getChannel();
        String host = this.getHost(channel);
        if (channel == null) {
            throw new RuntimeException("join: could not get the channel for " + this._clusterName + "/" + clientName);
        }
        ClusterService.Member newMember = this.createMember(clusterName, clientName, data, false, host);
        this.joinInternal(newMember);
        this._channels.put(clientName, channel);
        this._channel2member.put("" + channel.hashCode(), clientName);
        if (listener != null) {
            this._listners.put(clientName, listener);
        }
        System.out.println("-join " + clientName);
    }

    private Channel getChannel() {
        Channel channel = HessianSkeleton.threadLocalChannel.get();
        return channel;
    }

    private String getHost(Channel channel) {
        InetSocketAddress remoteAddress = (InetSocketAddress)channel.remoteAddress();
        return remoteAddress.getHostName();
    }

    @Override
    public synchronized void seedJoin(ClusterService.Member member, ClusterService.ClusterEventListener listener) {
        if (member.isSeed() && this._joinedSeeds.containsKey(member.getName())) {
            throw new RuntimeException("already joined " + this._clusterName + "/" + member.getName());
        }
        if (member.isSeed()) {
            Channel channel = this.getChannel();
            if (channel != null) {
                this._joinedSeeds.put(member.getName(), member);
                this._channels.put(member.getName(), channel);
                this._channel2member.put("" + channel.hashCode(), member.getName());
            }
            if (listener != null) {
                this._listners.put(member.getName(), listener);
            }
        }
        if (!this._members.containsKey(member.getName())) {
            this.joinInternal(member);
        }
    }

    synchronized void channelClosed(Channel channel) {
        String name = this._channel2member.remove("" + channel.hashCode());
        if (name == null) {
            return;
        }
        this.leave(name);
    }

    protected synchronized ClusterService.Member createMember(String clusterName, String clientName, Object data, boolean isSeed, String host) {
        if (this._members.containsKey(clientName)) {
            throw new RuntimeException("already joined " + clusterName + "/" + clientName);
        }
        if (!this._clusterName.equals(clusterName)) {
            throw new RuntimeException("cannot join wrong cluster " + this._clusterName + "!=" + clusterName + "/" + clientName);
        }
        MemberImpl newMember = new MemberImpl();
        newMember._data = data;
        newMember._host = host;
        newMember._name = clientName;
        newMember._server = this._server;
        newMember._isSeed = isSeed;
        return newMember;
    }

    private void joinInternal(ClusterService.Member newMember) {
        this._members.put(newMember.getName(), newMember);
        this.announceJoin(newMember);
    }

    @Override
    public synchronized void leave(String clientName) {
        ClusterService.Member member = this._members.remove(clientName);
        if (member == null) {
            throw new RuntimeException("cannot leave not joined cluster " + this._clusterName + "/" + clientName);
        }
        this._listners.remove(clientName);
        this.announceLeave(member);
        Channel channel = this._channels.remove(clientName);
        if (channel != null) {
            channel.close();
            this._channel2member.remove("" + channel.hashCode());
        }
        if (member.isSeed()) {
            this.seedLeft(member);
        }
    }

    private void seedLeft(ClusterService.Member seed) {
        this._joinedSeeds.remove(seed.getName());
        for (ClusterService.Member member : this._members.values()) {
            if (!seed.equals(member.getClusterServer())) continue;
            this.removeRemoteMember(member);
        }
    }

    private void removeRemoteMember(ClusterService.Member member) {
        String clientName = member.getName();
        this.leave(clientName);
    }

    @Override
    public List<ClusterService.Member> getMembers() {
        return new ArrayList<ClusterService.Member>(this._members.values());
    }

    private void announceLeave(ClusterService.Member member) {
        String clientName = member.getName();
        for (String client : this._listners.keySet()) {
            ClusterService.ClusterEventListener listner;
            if (clientName.equals(client) || (listner = this._listners.get(clientName)) == null) continue;
            try {
                listner.left(member);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void announceJoin(ClusterService.Member member) {
        String clientName = member.getName();
        for (String client : this._listners.keySet()) {
            ClusterService.ClusterEventListener listner;
            if (clientName.equals(client) || (listner = this._listners.get(clientName)) == null) continue;
            try {
                listner.joined(member);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void disconnected(Channel channel) {
        String client = this._channel2member.remove("" + channel.hashCode());
        if (client != null) {
            this.leave(client);
        }
    }
}

