/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jdbc.store.logging;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Arrays;
import org.apache.activemq.artemis.jdbc.store.logging.LoggingConnection;
import org.apache.activemq.artemis.jdbc.store.logging.LoggingResultSet;
import org.apache.activemq.artemis.jdbc.store.logging.LoggingUtil;
import org.jboss.logging.Logger;

public class LoggingStatement
implements Statement {
    private final Statement statement;
    protected final String statementID;
    protected final Logger logger;
    protected static Logger.Level level = Logger.Level.TRACE;

    public LoggingStatement(Statement statement, Logger logger) {
        this.statement = statement;
        this.logger = logger;
        this.statementID = LoggingUtil.getID(statement);
    }

    public Statement getStatement() {
        return this.statement;
    }

    public String getStatementID() {
        return this.statementID;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        LoggingResultSet rs = new LoggingResultSet(this.statement.executeQuery(sql), this.logger);
        this.logger.logf(level, "%s.executeQuery(%s) = %s", (Object)this.statementID, (Object)sql, (Object)rs.getResultSetID());
        return rs;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        int i = this.statement.executeUpdate(sql);
        this.logger.logf(level, "%s.executeUpdate(%s) = %s", (Object)this.statementID, (Object)sql, (Object)i);
        return i;
    }

    @Override
    public void close() throws SQLException {
        this.logger.logf(level, "%s.close()", (Object)this.statementID);
        this.statement.close();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        int i = this.statement.getMaxFieldSize();
        this.logger.logf(level, "%s.getMaxFieldSize() = %s", (Object)this.statementID, (Object)i);
        return i;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.logger.logf(level, "%s.setMaxFieldSize(%d)", (Object)this.statementID, (Object)max);
        this.statement.setMaxFieldSize(max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        int i = this.statement.getMaxRows();
        this.logger.logf(level, "%s.getMaxRows() = %s", (Object)this.statementID, (Object)i);
        return i;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.logger.logf(level, "%s.setMaxRows()", (Object)this.statementID);
        this.statement.setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.logger.logf(level, "%s.setEscapeProcessing(%s)", (Object)this.statementID, (Object)enable);
        this.statement.setEscapeProcessing(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        int i = this.statement.getQueryTimeout();
        this.logger.logf(level, "%s.getQueryTimeout() = %s", (Object)this.statementID, (Object)i);
        return i;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.logger.logf(level, "%s.setQueryTimeout(%d)", (Object)this.statementID, (Object)seconds);
        this.statement.setQueryTimeout(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        this.logger.logf(level, "%s.cancel()", (Object)this.statementID);
        this.statement.cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.logger.logf(level, "%s.getWarnings()", (Object)this.statementID);
        return this.statement.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.logger.logf(level, "%s.clearWarnings()", (Object)this.statementID);
        this.statement.clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.logger.logf(level, "%s.setCursorName(%s)", (Object)this.statementID, (Object)name);
        this.statement.setCursorName(name);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        boolean b = this.statement.execute(sql);
        this.logger.logf(level, "%s.execute(%s) = %s", (Object)this.statementID, (Object)sql, (Object)b);
        return b;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        LoggingResultSet rs = new LoggingResultSet(this.statement.getResultSet(), this.logger);
        this.logger.logf(level, "%s.executeQuery() = %s", (Object)this.statementID, (Object)rs.getResultSetID());
        return rs;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        int i = this.statement.getUpdateCount();
        this.logger.logf(level, "%s.getUpdateCount() = %s", (Object)this.statementID, (Object)i);
        return i;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        boolean b = this.statement.getMoreResults();
        this.logger.logf(level, "%s.getMoreResults() = %s", (Object)this.statementID, (Object)b);
        return b;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.logger.logf(level, "%s.setFetchDirection()", (Object)this.statementID);
        this.statement.setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        int i = this.statement.getFetchDirection();
        this.logger.logf(level, "%s.getFetchDirection() = %s", (Object)this.statementID, (Object)i);
        return i;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.logger.logf(level, "%s.setFetchSize(%d)", (Object)this.statementID, (Object)rows);
        this.statement.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        int i = this.statement.getFetchSize();
        this.logger.logf(level, "%s.getFetchSize() = %s", (Object)this.statementID, (Object)i);
        return i;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        int i = this.statement.getResultSetConcurrency();
        this.logger.logf(level, "%s.getResultSetConcurrency() = %s", (Object)this.statementID, (Object)i);
        return i;
    }

    @Override
    public int getResultSetType() throws SQLException {
        int i = this.statement.getResultSetType();
        this.logger.logf(level, "%s.getResultSetType() = %s", (Object)this.statementID, (Object)i);
        return i;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.logger.logf(level, "%s.addBatch(%d, %s)", (Object)this.statementID);
        this.statement.addBatch(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.logger.logf(level, "%s.clearBatch()", (Object)this.statementID);
        this.statement.clearBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int[] i = this.statement.executeBatch();
        this.logger.logf(level, "%s.executeBatch() = %s", (Object)this.statementID, (Object)Arrays.toString(i));
        return i;
    }

    @Override
    public Connection getConnection() throws SQLException {
        LoggingConnection connection = new LoggingConnection(this.statement.getConnection(), this.logger);
        this.logger.logf(level, "%s.getConnection() = %s", (Object)this.statementID, (Object)connection.getConnectionID());
        return connection;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        boolean b = this.statement.getMoreResults(current);
        this.logger.logf(level, "%s.getMoreResults(%s) = %s", (Object)this.statementID, (Object)current, (Object)b);
        return b;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        LoggingResultSet rs = new LoggingResultSet(this.statement.getGeneratedKeys(), this.logger);
        this.logger.logf(level, "%s.getGeneratedKeys() = %s", (Object)this.statementID, (Object)rs.getResultSetID());
        return rs;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        int i = this.statement.executeUpdate(sql, autoGeneratedKeys);
        this.logger.logf(level, "%s.executeUpdate(%s, %d) = %s", new Object[]{this.statementID, sql, autoGeneratedKeys, i});
        return i;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        int i = this.statement.executeUpdate(sql, columnIndexes);
        this.logger.logf(level, "%s.executeUpdate(%s, %s) = %s", new Object[]{this.statementID, sql, Arrays.toString(columnIndexes), i});
        return i;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        int i = this.statement.executeUpdate(sql, columnNames);
        this.logger.logf(level, "%s.executeUpdate(%s, %s) = %s", new Object[]{this.statementID, sql, Arrays.toString(columnNames), i});
        return i;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        boolean b = this.statement.execute(sql, autoGeneratedKeys);
        this.logger.logf(level, "%s.execute(%s, %s) = %s", new Object[]{this.statementID, sql, autoGeneratedKeys, b});
        return b;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        boolean b = this.statement.execute(sql, columnIndexes);
        this.logger.logf(level, "%s.execute(%s, %s) = %s", new Object[]{this.statementID, sql, Arrays.toString(columnIndexes), b});
        return b;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        boolean b = this.statement.execute(sql, columnNames);
        this.logger.logf(level, "%s.execute(%s, %s) = %s", new Object[]{this.statementID, sql, Arrays.toString(columnNames), b});
        return b;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        int i = this.statement.getResultSetHoldability();
        this.logger.logf(level, "%s.getResultSetHoldability() = %s", (Object)this.statementID, (Object)i);
        return i;
    }

    @Override
    public boolean isClosed() throws SQLException {
        boolean b = this.statement.isClosed();
        this.logger.logf(level, "%s.isClosed() = %s", (Object)this.statementID, (Object)b);
        return b;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.logger.logf(level, "%s.setPoolable(%s)", (Object)this.statementID, (Object)poolable);
        this.statement.setPoolable(poolable);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        boolean b = this.statement.isPoolable();
        this.logger.logf(level, "%s.isPoolable() = %s", (Object)this.statementID, (Object)b);
        return b;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.logger.logf(level, "%s.closeOnCompletion()", (Object)this.statementID);
        this.statement.closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        boolean b = this.statement.isCloseOnCompletion();
        this.logger.logf(level, "%s.isCloseOnCompletion() = %s", (Object)this.statementID, (Object)b);
        return b;
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        long x = this.statement.getLargeUpdateCount();
        this.logger.logf(level, "%s.getLargeUpdateCount() = %s", (Object)this.statementID, (Object)x);
        return x;
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        this.logger.logf(level, "%s.setLargeMaxRows(%d)", (Object)this.statementID, (Object)max);
        this.statement.setLargeMaxRows(max);
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        long x = this.statement.getLargeMaxRows();
        this.logger.logf(level, "%s.getLargeMaxRows() = %s", (Object)this.statementID, (Object)x);
        return x;
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        long[] x = this.statement.executeLargeBatch();
        this.logger.logf(level, "%s.executeLargeBatch() = %s", (Object)this.statementID, (Object)x);
        return x;
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        long x = this.statement.executeLargeUpdate(sql);
        this.logger.logf(level, "%s.executeLargeUpdate(%s) = %s", (Object)this.statementID, (Object)sql, (Object)x);
        return x;
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        long x = this.statement.executeLargeUpdate(sql, autoGeneratedKeys);
        this.logger.logf(level, "%s.executeLargeUpdate() = %s", new Object[]{this.statementID, sql, autoGeneratedKeys, x});
        return x;
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        long x = this.statement.executeLargeUpdate(sql, columnIndexes);
        this.logger.logf(level, "%s.executeLargeUpdate(%s, %s) = %s", new Object[]{this.statementID, sql, Arrays.toString(columnIndexes), x});
        return x;
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        long x = this.statement.executeLargeUpdate(sql, columnNames);
        this.logger.logf(level, "%s.executeLargeUpdate(%s, %s) = %s", new Object[]{this.statementID, sql, Arrays.toString(columnNames), x});
        return x;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        T x = this.statement.unwrap(iface);
        this.logger.logf(level, "%s.unwrap(%s) = %s", (Object)this.statementID, iface, x);
        return x;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        boolean b = this.statement.isWrapperFor(iface);
        this.logger.logf(level, "%s.isWrapperFor(%s) = %s", (Object)this.statementID, iface, (Object)b);
        return b;
    }
}

