/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.lock;

import EDU.oswego.cs.dl.util.concurrent.ReentrantLock;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.transaction.xa.Xid;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.SessionListener;
import org.apache.jackrabbit.core.TransactionContext;
import org.apache.jackrabbit.core.cluster.ClusterOperation;
import org.apache.jackrabbit.core.cluster.LockEventChannel;
import org.apache.jackrabbit.core.cluster.LockEventListener;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.fs.FileSystemResource;
import org.apache.jackrabbit.core.lock.AbstractLockInfo;
import org.apache.jackrabbit.core.lock.LockImpl;
import org.apache.jackrabbit.core.lock.LockManager;
import org.apache.jackrabbit.core.lock.LockToken;
import org.apache.jackrabbit.core.observation.EventImpl;
import org.apache.jackrabbit.core.observation.SynchronousEventListener;
import org.apache.jackrabbit.core.util.Dumpable;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.MalformedPathException;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.PathMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockManagerImpl
implements LockManager,
SynchronousEventListener,
LockEventListener,
Dumpable {
    private static final Logger log = LoggerFactory.getLogger((Class)LockManagerImpl.class);
    private static final String LOCKS_FILE = "locks";
    private final PathMap lockMap = new PathMap();
    private final ReentrantLock lockMapLock = new ReentrantLock(){
        private Xid activeXid;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void acquire() throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Thread caller = Thread.currentThread();
            1 var2_2 = this;
            synchronized (var2_2) {
                boolean allow = TransactionContext.isCurrentXid(this.activeXid, caller == this.owner_);
                if (allow) {
                    ++this.holds_;
                } else {
                    try {
                        while (this.owner_ != null) {
                            ((Object)((Object)this)).wait();
                        }
                        this.owner_ = caller;
                        this.activeXid = TransactionContext.getCurrentXid();
                        this.holds_ = 1L;
                    }
                    catch (InterruptedException ex) {
                        ((Object)((Object)this)).notify();
                        throw ex;
                    }
                }
            }
        }

        public synchronized void release() {
            boolean allow = TransactionContext.isCurrentXid(this.activeXid, Thread.currentThread() == this.owner_);
            if (!allow) {
                throw new Error("Illegal Lock usage");
            }
            if (--this.holds_ == 0L) {
                this.owner_ = null;
                this.activeXid = null;
                ((Object)((Object)this)).notify();
            }
        }
    };
    private final SessionImpl sysSession;
    private final FileSystemResource locksFile;
    private boolean savingDisabled;
    private LockEventChannel eventChannel;

    public LockManagerImpl(SessionImpl session, FileSystem fs) throws RepositoryException {
        this.sysSession = session;
        this.locksFile = new FileSystemResource(fs, "/locks");
        session.getWorkspace().getObservationManager().addEventListener((EventListener)this, 3, "/", true, null, null, true);
        try {
            if (this.locksFile.exists()) {
                this.load();
            }
        }
        catch (FileSystemException e) {
            throw new RepositoryException("I/O error while reading locks from '" + this.locksFile.getPath() + "'", (Throwable)e);
        }
    }

    public void close() {
        this.save();
    }

    private void load() throws FileSystemException {
        BufferedReader reader = null;
        try {
            String s;
            reader = new BufferedReader(new InputStreamReader(this.locksFile.getInputStream()));
            while ((s = reader.readLine()) != null && !s.equals("")) {
                this.reapplyLock(LockToken.parse(s));
            }
        }
        catch (IOException e) {
            try {
                throw new FileSystemException("error while reading locks file", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
    }

    private void reapplyLock(LockToken lockToken) {
        try {
            NodeImpl node = (NodeImpl)this.sysSession.getItemManager().getItem(lockToken.getId());
            Path path = this.getPath(this.sysSession, lockToken.getId());
            LockInfo info = new LockInfo(lockToken, false, node.getProperty(NameConstants.JCR_LOCKISDEEP).getBoolean(), node.getProperty(NameConstants.JCR_LOCKOWNER).getString());
            info.setLive(true);
            this.lockMap.put(path, info);
        }
        catch (RepositoryException e) {
            log.warn("Unable to recreate lock '" + lockToken + "': " + e.getMessage());
            log.debug("Root cause: ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void save() {
        if (this.savingDisabled) {
            return;
        }
        final ArrayList list = new ArrayList();
        this.lockMap.traverse(new PathMap.ElementVisitor(){

            public void elementVisited(PathMap.Element element) {
                LockInfo info = (LockInfo)element.get();
                if (!info.sessionScoped) {
                    list.add(info);
                }
            }
        }, false);
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter(this.locksFile.getOutputStream()));
            for (int i = 0; i < list.size(); ++i) {
                AbstractLockInfo info = (AbstractLockInfo)list.get(i);
                writer.write(info.lockToken.toString());
                writer.newLine();
            }
        }
        catch (FileSystemException fse) {
            log.warn("I/O error while saving locks to '" + this.locksFile.getPath() + "': " + fse.getMessage());
            log.debug("Root cause: ", (Throwable)fse);
            IOUtils.closeQuietly((Writer)writer);
        }
        catch (IOException ioe) {
            log.warn("I/O error while saving locks to '" + this.locksFile.getPath() + "': " + ioe.getMessage());
            log.debug("Root cause: ", (Throwable)ioe);
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(writer);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Writer)writer);
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AbstractLockInfo internalLock(NodeImpl node, boolean isDeep, boolean isSessionScoped) throws LockException, RepositoryException {
        SessionImpl session = (SessionImpl)node.getSession();
        LockInfo info = new LockInfo(new LockToken(node.getNodeId()), isSessionScoped, isDeep, session.getUserID());
        ClusterOperation operation = null;
        boolean successful = false;
        if (this.eventChannel != null && !isSessionScoped) {
            operation = this.eventChannel.create(node.getNodeId(), isDeep, session.getUserID());
        }
        this.acquire();
        try {
            Path path = this.getPath(session, node.getId());
            PathMap.Element element = this.lockMap.map(path, false);
            LockInfo other = (LockInfo)element.get();
            if (other != null) {
                if (element.hasPath(path)) {
                    throw new LockException("Node already locked: " + node);
                }
                if (other.deep) {
                    throw new LockException("Parent node has a deep lock: " + node);
                }
            }
            if (info.deep && element.hasPath(path) && element.getChildrenCount() > 0) {
                throw new LockException("Some child node is locked.");
            }
            info.setLockHolder(session);
            info.setLive(true);
            session.addListener(info);
            session.addLockToken(info.lockToken.toString(), false);
            this.lockMap.put(path, info);
            if (!info.sessionScoped) {
                this.save();
                successful = true;
            }
            LockInfo lockInfo = info;
            return lockInfo;
        }
        finally {
            this.release();
            if (operation != null) {
                operation.ended(successful);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalUnlock(NodeImpl node) throws LockException, RepositoryException {
        ClusterOperation operation = null;
        boolean successful = false;
        if (this.eventChannel != null) {
            operation = this.eventChannel.create(node.getNodeId());
        }
        this.acquire();
        try {
            SessionImpl session = (SessionImpl)node.getSession();
            PathMap.Element element = this.lockMap.map(this.getPath(session, node.getId()), true);
            if (element == null) {
                throw new LockException("Node not locked: " + node);
            }
            AbstractLockInfo info = (AbstractLockInfo)element.get();
            if (info == null) {
                throw new LockException("Node not locked: " + node);
            }
            if (session != info.getLockHolder()) {
                throw new LockException("Node not locked by session: " + node);
            }
            session.removeLockToken(info.getLockToken(session), false);
            element.set(null);
            info.setLive(false);
            if (!info.sessionScoped) {
                this.save();
                successful = true;
            }
        }
        finally {
            this.release();
            if (operation != null) {
                operation.ended(successful);
            }
        }
    }

    AbstractLockInfo[] getLockInfos(final SessionImpl session) {
        final ArrayList infos = new ArrayList();
        this.lockMap.traverse(new PathMap.ElementVisitor(){

            public void elementVisited(PathMap.Element element) {
                LockInfo info = (LockInfo)element.get();
                if (info.isLive() && info.getLockHolder().equals(session)) {
                    infos.add(info);
                }
            }
        }, false);
        return infos.toArray(new AbstractLockInfo[infos.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractLockInfo getLockInfo(NodeId id) throws RepositoryException {
        Path path;
        try {
            path = this.getPath(this.sysSession, id);
        }
        catch (ItemNotFoundException e) {
            return null;
        }
        this.acquire();
        try {
            PathMap.Element element = this.lockMap.map(path, false);
            AbstractLockInfo info = (AbstractLockInfo)element.get();
            if (info != null && (element.hasPath(path) || info.deep)) {
                AbstractLockInfo abstractLockInfo = info;
                return abstractLockInfo;
            }
            AbstractLockInfo abstractLockInfo = null;
            return abstractLockInfo;
        }
        finally {
            this.release();
        }
    }

    public Lock lock(NodeImpl node, boolean isDeep, boolean isSessionScoped) throws LockException, RepositoryException {
        AbstractLockInfo info = this.internalLock(node, isDeep, isSessionScoped);
        return new LockImpl(info, node);
    }

    public Lock getLock(NodeImpl node) throws LockException, RepositoryException {
        this.acquire();
        try {
            SessionImpl session = (SessionImpl)node.getSession();
            Path path = this.getPath(session, node.getId());
            PathMap.Element element = this.lockMap.map(path, false);
            AbstractLockInfo info = (AbstractLockInfo)element.get();
            if (info != null && (element.hasPath(path) || info.deep)) {
                Node lockHolder = (Node)session.getItemManager().getItem(info.getId());
                LockImpl lockImpl = new LockImpl(info, lockHolder);
                return lockImpl;
            }
            try {
                throw new LockException("Node not locked: " + node);
            }
            catch (ItemNotFoundException e) {
                throw new LockException("Node not locked: " + node);
            }
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lock[] getLocks(SessionImpl session) throws RepositoryException {
        this.acquire();
        AbstractLockInfo[] infos = this.getLockInfos(session);
        try {
            Lock[] locks = new Lock[infos.length];
            for (int i = 0; i < infos.length; ++i) {
                AbstractLockInfo info = infos[i];
                Node holder = (Node)session.getItemManager().getItem(info.getId());
                locks[i] = new LockImpl(info, holder);
            }
            Lock[] lockArray = locks;
            return lockArray;
        }
        finally {
            this.release();
        }
    }

    public void unlock(NodeImpl node) throws LockException, RepositoryException {
        this.internalUnlock(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean holdsLock(NodeImpl node) throws RepositoryException {
        this.acquire();
        try {
            SessionImpl session = (SessionImpl)node.getSession();
            PathMap.Element element = this.lockMap.map(this.getPath(session, node.getId()), true);
            if (element == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = element.get() != null;
            return bl;
        }
        catch (ItemNotFoundException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLockHolder(Session session, NodeImpl node) throws RepositoryException {
        this.acquire();
        try {
            SessionImpl nodeSession = (SessionImpl)node.getSession();
            PathMap.Element element = this.lockMap.map(this.getPath(nodeSession, node.getId()), true);
            if (element == null) {
                boolean bl = false;
                return bl;
            }
            AbstractLockInfo info = (AbstractLockInfo)element.get();
            boolean bl = info != null && info.getLockHolder() == session;
            return bl;
        }
        catch (ItemNotFoundException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocked(NodeImpl node) throws RepositoryException {
        this.acquire();
        try {
            SessionImpl session = (SessionImpl)node.getSession();
            Path path = this.getPath(session, node.getId());
            PathMap.Element element = this.lockMap.map(path, false);
            AbstractLockInfo info = (AbstractLockInfo)element.get();
            if (info == null) {
                boolean bl = false;
                return bl;
            }
            if (element.hasPath(path)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = info.deep;
            return bl;
        }
        catch (ItemNotFoundException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.release();
        }
    }

    public void checkLock(NodeImpl node) throws LockException, RepositoryException {
        SessionImpl session = (SessionImpl)node.getSession();
        this.checkLock(this.getPath(session, node.getId()), session);
    }

    public void checkLock(Path path, Session session) throws LockException, RepositoryException {
        PathMap.Element element = this.lockMap.map(path, false);
        AbstractLockInfo info = (AbstractLockInfo)element.get();
        if (info != null && (element.hasPath(path) || info.deep) && session != info.getLockHolder()) {
            throw new LockException("Node locked.");
        }
    }

    public void lockTokenAdded(SessionImpl session, String lt) {
        try {
            AbstractLockInfo info;
            LockToken lockToken = LockToken.parse(lt);
            NodeImpl node = (NodeImpl)this.sysSession.getItemManager().getItem(lockToken.getId());
            PathMap.Element element = this.lockMap.map(node.getPrimaryPath(), true);
            if (element != null && (info = (AbstractLockInfo)element.get()) != null) {
                if (info.getLockHolder() == null) {
                    info.setLockHolder(session);
                    if (info instanceof LockInfo) {
                        session.addListener((LockInfo)info);
                    }
                } else {
                    log.warn("Adding lock token has no effect: lock already held by other session.");
                }
            }
        }
        catch (IllegalArgumentException e) {
            log.warn("Bad lock token: " + e.getMessage());
        }
        catch (RepositoryException e) {
            log.warn("Unable to set lock holder: " + e.getMessage());
            log.debug("Root cause: ", (Throwable)e);
        }
    }

    public void lockTokenRemoved(SessionImpl session, String lt) {
        try {
            AbstractLockInfo info;
            LockToken lockToken = LockToken.parse(lt);
            NodeImpl node = (NodeImpl)this.sysSession.getItemManager().getItem(lockToken.getId());
            PathMap.Element element = this.lockMap.map(node.getPrimaryPath(), true);
            if (element != null && (info = (AbstractLockInfo)element.get()) != null) {
                if (session == info.getLockHolder()) {
                    info.setLockHolder(null);
                } else {
                    log.warn("Removing lock token has no effect: lock held by other session.");
                }
            }
        }
        catch (IllegalArgumentException e) {
            log.warn("Bad lock token: " + e.getMessage());
        }
        catch (RepositoryException e) {
            log.warn("Unable to reset lock holder: " + e.getMessage());
            log.debug("Root cause: ", (Throwable)e);
        }
    }

    private Path getPath(SessionImpl session, ItemId id) throws RepositoryException {
        return session.getHierarchyManager().getPath(id);
    }

    private void acquire() {
        while (true) {
            try {
                this.lockMapLock.acquire();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private void release() {
        this.lockMapLock.release();
    }

    public void beginUpdate() {
        this.acquire();
        this.savingDisabled = true;
    }

    public void endUpdate() {
        this.savingDisabled = false;
        this.save();
        this.release();
    }

    public void cancelUpdate() {
        this.savingDisabled = false;
        this.release();
    }

    public void onEvent(EventIterator events) {
        Iterator iter = this.consolidateEvents(events);
        while (iter.hasNext()) {
            HierarchyEvent event = (HierarchyEvent)iter.next();
            if (event.type == 1) {
                this.nodeAdded(event.path);
                continue;
            }
            if (event.type == 2) {
                this.nodeRemoved(event.path);
                continue;
            }
            if (event.type != 3) continue;
            this.nodeMoved(event.getOldPath(), event.getNewPath());
        }
    }

    private Iterator consolidateEvents(EventIterator events) {
        LinkedMap eventMap = new LinkedMap();
        while (events.hasNext()) {
            HierarchyEvent he;
            EventImpl event = (EventImpl)events.nextEvent();
            try {
                he = new HierarchyEvent(event.getChildId(), this.sysSession.getQPath(event.getPath()).getNormalizedPath(), event.getType());
            }
            catch (MalformedPathException e) {
                log.info("Unable to get event's path: " + e.getMessage());
                continue;
            }
            catch (RepositoryException e) {
                log.info("Unable to get event's path: " + e.getMessage());
                continue;
            }
            HierarchyEvent heExisting = (HierarchyEvent)eventMap.get((Object)he.id);
            if (heExisting != null) {
                heExisting.merge(he);
                continue;
            }
            eventMap.put((Object)he.id, (Object)he);
        }
        return eventMap.values().iterator();
    }

    private void refresh(PathMap.Element element) {
        final ArrayList infos = new ArrayList();
        boolean needsSave = false;
        element.traverse(new PathMap.ElementVisitor(){

            public void elementVisited(PathMap.Element element) {
                LockInfo info = (LockInfo)element.get();
                infos.add(info);
            }
        }, false);
        element.removeAll();
        for (int i = 0; i < infos.size(); ++i) {
            LockInfo info = (LockInfo)infos.get(i);
            try {
                NodeImpl node = (NodeImpl)this.sysSession.getItemManager().getItem(info.getId());
                this.lockMap.put(node.getPrimaryPath(), info);
                continue;
            }
            catch (RepositoryException e) {
                info.setLive(false);
                if (info.sessionScoped) continue;
                needsSave = true;
            }
        }
        if (needsSave) {
            this.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nodeAdded(Path path) {
        this.acquire();
        try {
            PathMap.Element parent = this.lockMap.map(path.getAncestor(1), true);
            if (parent != null) {
                this.refresh(parent);
            }
        }
        catch (PathNotFoundException e) {
            log.warn("Unable to determine path of added node's parent.", (Throwable)e);
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nodeMoved(Path oldPath, Path newPath) {
        this.acquire();
        try {
            PathMap.Element parent = this.lockMap.map(oldPath.getAncestor(1), true);
            if (parent != null) {
                this.refresh(parent);
            }
        }
        catch (PathNotFoundException e) {
            log.warn("Unable to determine path of moved node's parent.", (Throwable)e);
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nodeRemoved(Path path) {
        this.acquire();
        try {
            PathMap.Element parent = this.lockMap.map(path.getAncestor(1), true);
            if (parent != null) {
                this.refresh(parent);
            }
        }
        catch (PathNotFoundException e) {
            log.warn("Unable to determine path of removed node's parent.", (Throwable)e);
        }
        finally {
            this.release();
        }
    }

    public void setEventChannel(LockEventChannel eventChannel) {
        this.eventChannel = eventChannel;
        eventChannel.setListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void externalLock(NodeId nodeId, boolean isDeep, String userId) throws RepositoryException {
        this.acquire();
        try {
            Path path = this.getPath(this.sysSession, nodeId);
            LockInfo info = new LockInfo(new LockToken(nodeId), false, isDeep, userId);
            info.setLive(true);
            this.lockMap.put(path, info);
            this.save();
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void externalUnlock(NodeId nodeId) throws RepositoryException {
        this.acquire();
        try {
            Path path = this.getPath(this.sysSession, nodeId);
            PathMap.Element element = this.lockMap.map(path, true);
            if (element == null) {
                throw new LockException("Node not locked: " + path.toString());
            }
            AbstractLockInfo info = (AbstractLockInfo)element.get();
            if (info == null) {
                throw new LockException("Node not locked: " + path.toString());
            }
            element.set(null);
            info.setLive(false);
            this.save();
        }
        finally {
            this.release();
        }
    }

    public void dump(final PrintStream ps) {
        this.lockMap.traverse(new PathMap.ElementVisitor(){

            public void elementVisited(PathMap.Element element) {
                StringBuffer line = new StringBuffer();
                for (int i = 0; i < element.getDepth(); ++i) {
                    line.append("--");
                }
                line.append(element.getName());
                int index = element.getIndex();
                if (index != 0 && index != 1) {
                    line.append('[');
                    line.append(index);
                    line.append(']');
                }
                line.append("  ");
                line.append(element.get());
                ps.println(line.toString());
            }
        }, true);
    }

    class LockInfo
    extends AbstractLockInfo
    implements SessionListener {
        public LockInfo(LockToken lockToken, boolean sessionScoped, boolean deep, String lockOwner) {
            super(lockToken, sessionScoped, deep, lockOwner);
        }

        public void loggingOut(SessionImpl session) {
            if (this.live) {
                if (this.sessionScoped) {
                    SessionImpl lockHolder = this.getLockHolder();
                    if (lockHolder == null) {
                        this.setLockHolder(session);
                    }
                    try {
                        NodeImpl node = (NodeImpl)session.getItemManager().getItem(this.getId());
                        node.unlock();
                    }
                    catch (RepositoryException e) {
                        SessionImpl systemSession = LockManagerImpl.this.sysSession;
                        this.setLockHolder(systemSession);
                        try {
                            NodeImpl node = (NodeImpl)systemSession.getItemManager().getItem(this.getId());
                            node.unlock();
                        }
                        catch (RepositoryException re) {
                            log.warn("Unable to remove session-scoped lock on node '" + this.lockToken + "': " + e.getMessage());
                            log.debug("Root cause: ", (Throwable)e);
                        }
                    }
                } else if (session == this.lockHolder) {
                    session.removeLockToken(this.lockToken.toString());
                    this.lockHolder = null;
                }
            }
        }

        public void loggedOut(SessionImpl session) {
        }
    }

    private class HierarchyEvent {
        private final NodeId id;
        private final Path path;
        private Path oldPath;
        private Path newPath;
        private int type;

        public HierarchyEvent(NodeId id, Path path, int type) {
            this.id = id;
            this.path = path;
            this.type = type;
        }

        public void merge(HierarchyEvent event) {
            this.type |= event.type;
            if (event.type == 1) {
                this.newPath = event.path;
                this.oldPath = this.path;
            } else {
                this.oldPath = event.path;
                this.newPath = this.path;
            }
        }

        public int getType() {
            return this.type;
        }

        public Path getOldPath() {
            return this.oldPath;
        }

        public Path getNewPath() {
            return this.newPath;
        }
    }
}

