/*
 * Decompiled with CFR 0.152.
 */
package akka.http.javadsl.model;

import akka.Done;
import akka.actor.ClassicActorSystemProvider;
import akka.annotation.DoNotInherit;
import akka.http.impl.util.Util;
import akka.http.javadsl.model.BodyPartEntity;
import akka.http.javadsl.model.ContentType;
import akka.http.javadsl.model.HttpHeader;
import akka.http.javadsl.model.HttpMessage;
import akka.http.javadsl.model.RequestEntity;
import akka.http.javadsl.model.ResponseEntity;
import akka.http.javadsl.model.UniversalEntity;
import akka.http.scaladsl.model.HttpEntity;
import akka.http.scaladsl.model.HttpEntity$LastChunk$;
import akka.stream.Materializer;
import akka.stream.javadsl.Source;
import akka.util.ByteString;
import java.util.OptionalLong;
import java.util.concurrent.CompletionStage;
import scala.concurrent.Future;

@DoNotInherit
public interface HttpEntity {
    public ContentType getContentType();

    public HttpEntity withContentType(ContentType var1);

    public boolean isKnownEmpty();

    public boolean isChunked();

    public boolean isStrict();

    public boolean isDefault();

    public boolean isCloseDelimited();

    public boolean isIndefiniteLength();

    public OptionalLong getContentLengthOption();

    public Source<ByteString, Object> getDataBytes();

    public HttpEntity withSizeLimit(long var1);

    public HttpEntity withoutSizeLimit();

    public CompletionStage<Strict> toStrict(long var1, Materializer var3);

    public CompletionStage<Strict> toStrict(long var1, long var3, Materializer var5);

    public CompletionStage<Strict> toStrict(long var1, ClassicActorSystemProvider var3);

    public CompletionStage<Strict> toStrict(long var1, long var3, ClassicActorSystemProvider var5);

    public HttpMessage.DiscardedEntity discardBytes(Materializer var1);

    public HttpMessage.DiscardedEntity discardBytes(ClassicActorSystemProvider var1);

    public static abstract class ChunkStreamPart {
        public static final ChunkStreamPart LAST = HttpEntity$LastChunk$.MODULE$;

        public abstract ByteString data();

        public abstract String extension();

        public abstract boolean isLastChunk();

        public abstract Iterable<HttpHeader> getTrailerHeaders();

        public static ChunkStreamPart create(ByteString byteString, String string) {
            return new HttpEntity.Chunk(byteString, string);
        }

        public static ChunkStreamPart create(ByteString byteString) {
            return ChunkStreamPart.create(byteString, "");
        }

        public static ChunkStreamPart createLast(String string, Iterable<HttpHeader> iterable) {
            return new HttpEntity.LastChunk(string, Util.convertIterable(iterable));
        }
    }

    public static interface IndefiniteLength
    extends BodyPartEntity {
    }

    public static interface Chunked
    extends RequestEntity,
    ResponseEntity {
        public Source<ChunkStreamPart, Object> getChunks();
    }

    public static interface CloseDelimited
    extends ResponseEntity {
    }

    public static interface Default
    extends UniversalEntity {
        public long getContentLength();
    }

    public static interface Strict
    extends UniversalEntity {
        public ByteString getData();
    }

    public static interface DiscardedEntity {
        public Future<Done> future();

        public CompletionStage<Done> completionStage();
    }
}

