/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yacron4j;

import java.text.ParseException;
import java.util.Date;
import java.util.TimeZone;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.quartzx.CronExpression;
import org.rzo.yacron4j.TaskOptions;

public class DSTCronExpression
extends CronExpression {
    final CronExpression _orgCronExpression;
    final TaskOptions _options;

    public DSTCronExpression(String cronExpression, TaskOptions options) throws ParseException {
        super(cronExpression);
        super.setTimeZone(TimeZone.getTimeZone("UTC"));
        this._orgCronExpression = new CronExpression(cronExpression);
        this._options = options;
    }

    public Date getTimeAfter(Date date) {
        Date date1 = super.getTimeAfter(new DateTime((Object)date).withZoneRetainFields(DateTimeZone.UTC).toDate());
        date1 = new DateTime((Object)date1).withZoneRetainFields(DateTimeZone.forTimeZone((TimeZone)this._options.getTimeZone())).toDate();
        if (this._options.getTimeZone().inDaylightTime(date1) && !this._options.getTimeZone().inDaylightTime(date)) {
            DateTimeZone dtz = DateTimeZone.forTimeZone((TimeZone)this._options.getTimeZone());
            Date dstEnd = new Date(dtz.nextTransition(date.getTime()));
            int dstEndHour = dstEnd.getHours();
            int dstDuration = (dtz.getOffset(date1.getTime()) - dtz.getStandardOffset(date1.getTime())) / 3600000;
            int hour = date1.getHours() + date1.getTimezoneOffset() / 60;
            if (hour < dstEndHour && hour >= dstEndHour - dstDuration) {
                if (this._options.getDstConflictResolution() == 0) {
                    return dstEnd;
                }
                if (this._options.getDstConflictResolution() < 0) {
                    return new Date(date1.getTime() - (long)(dstDuration * 60 * 60 * 1000));
                }
                return date1;
            }
            return this._orgCronExpression.getTimeAfter(date);
        }
        return this._orgCronExpression.getTimeAfter(date);
    }

    public void setTimeZone(TimeZone timeZone) {
        this._orgCronExpression.setTimeZone(timeZone);
    }
}

