/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.tasker;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.engine.api.execution.StepExecutionState;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.tasker.TaskStep;
import com.xebialabs.deployit.plugin.api.flow.Preview;
import com.xebialabs.deployit.plugin.api.flow.PreviewStep;
import com.xebialabs.deployit.plugin.api.flow.Step;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;

public class PreviewStepAdapter
implements StepState {
    private final TaskStep adaptee;
    private final Map<String, String> metadata;

    public PreviewStepAdapter(TaskStep adaptee) {
        this.adaptee = adaptee;
        this.metadata = new HashMap<String, String>(adaptee.getMetadata());
        this.calculatePreview();
    }

    private void calculatePreview() {
        Step implementation = this.adaptee.getImplementation();
        if (implementation instanceof PreviewStep) {
            Preview preview = ((PreviewStep)implementation).getPreview();
            String contents = Strings.defaultIfEmpty((String)preview.getContents(), (String)"").replace("\r\n", "\n");
            this.metadata.put("contents", contents);
            this.metadata.put("sourcePath", Strings.defaultIfEmpty((String)preview.getSourcePath(), (String)""));
        }
    }

    public String getDescription() {
        return this.adaptee.getDescription();
    }

    public StepExecutionState getState() {
        return this.adaptee.getState();
    }

    public String getLog() {
        return this.adaptee.getLog();
    }

    public List<String> getPreviousAttemptsLogs() {
        return this.adaptee.getPreviousAttemptsLogs();
    }

    public DateTime getStartDate() {
        return this.adaptee.getStartDate();
    }

    public DateTime getCompletionDate() {
        return this.adaptee.getCompletionDate();
    }

    public int getFailureCount() {
        return this.adaptee.getFailureCount();
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public boolean getSkippable() {
        return this.adaptee.getSkippable();
    }
}

