/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.local.LocalFile;
import java.io.File;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class WorkDirFactory {
    public static final String PREVIEW_WORKDIR_PREFIX = "preview";
    public static final String TASK_WORKDIR_PREFIX = "task";
    public static final String ARTIFACT_WORKDIR_PREFIX = "artifact";
    public static final String IMPORT_WORKDIR_PREFIX = "import";
    public static final String EXPORT_WORKDIR_PREFIX = "export";
    public static final String DOWNLOAD_WORKDIR_PREFIX = "download";
    public static final String EXTERNAL_WORKDIR_PREFIX = "external";
    @Value(value="#{baseWorkDir}")
    private String baseWorkDirPath;
    private File baseWorkDir;
    private static final Logger logger = LoggerFactory.getLogger(WorkDirFactory.class);

    public WorkDirFactory() {
    }

    @PostConstruct
    public void postConstruct() {
        this.initBaseWorkDir();
        this.cleanUpPreviewDirs();
    }

    public WorkDirFactory(String baseWorkDirPath) {
        this.baseWorkDirPath = baseWorkDirPath;
        this.initBaseWorkDir();
    }

    public WorkDir newWorkDir(String workdirPrefix) {
        return new WorkDir(this.baseWorkDir, workdirPrefix);
    }

    public WorkDir newWorkDir() {
        return this.newWorkDir(null);
    }

    public void cleanUpPreviewDirs() {
        for (OverthereFile temporaryDirectory : LocalFile.valueOf((File)this.baseWorkDir).listFiles()) {
            if (!temporaryDirectory.getName().startsWith(PREVIEW_WORKDIR_PREFIX) || !temporaryDirectory.isDirectory()) continue;
            try {
                temporaryDirectory.deleteRecursively();
            }
            catch (Exception e) {
                logger.warn("Could not delete preview workdir [{}]; you can do this manually.", (Object)temporaryDirectory.getPath());
            }
        }
    }

    private void initBaseWorkDir() {
        this.baseWorkDir = new File(this.baseWorkDirPath);
        if (!this.baseWorkDir.mkdirs() && !this.baseWorkDir.exists()) {
            throw new RuntimeIOException("Couldn't create the base work directory: " + this.baseWorkDirPath);
        }
    }

    public String getBaseWorkDirPath() {
        return this.baseWorkDirPath;
    }
}

