/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import com.xebialabs.deployit.engine.spi.event.MaintenanceStartEvent;
import com.xebialabs.deployit.engine.spi.event.MaintenanceStopEvent;
import com.xebialabs.deployit.engine.spi.event.SystemStartedEvent;
import nl.javadude.t2bus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerState {
    private static ServerState instance = new ServerState(Mode.STARTING);
    private static final Logger logger = LoggerFactory.getLogger(ServerState.class);
    private Mode currentMode;

    private ServerState(Mode mode) {
        this.currentMode = mode;
    }

    public static ServerState getInstance() {
        return instance;
    }

    public Mode getCurrentMode() {
        return this.currentMode;
    }

    @Subscribe
    public void onStart(SystemStartedEvent event) {
        logger.trace("Server started. Going into RUNNING mode.");
        this.currentMode = Mode.RUNNING;
    }

    @Subscribe
    public void maintenanceStart(MaintenanceStartEvent event) {
        logger.trace("Received request for MAINTENANCE mode.");
        this.currentMode = Mode.MAINTENANCE;
    }

    @Subscribe
    public void maintenanceCancel(MaintenanceStopEvent event) {
        logger.trace("Received request to cancel MAINTENANCE mode.");
        this.currentMode = Mode.RUNNING;
    }

    public static enum Mode {
        STARTING,
        RUNNING,
        MAINTENANCE;

    }
}

