/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ldap.authentication;

import java.util.Iterator;
import javax.naming.Name;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.log.LogMessage;
import org.springframework.ldap.AuthenticationException;
import org.springframework.ldap.NamingException;
import org.springframework.ldap.OperationNotSupportedException;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.ldap.support.LdapUtils;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.ldap.authentication.AbstractLdapAuthenticator;
import org.springframework.security.ldap.ppolicy.PasswordPolicyControlExtractor;
import org.springframework.security.ldap.ppolicy.PasswordPolicyResponseControl;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class BindAuthenticator
extends AbstractLdapAuthenticator {
    private static final Log logger = LogFactory.getLog(BindAuthenticator.class);

    public BindAuthenticator(BaseLdapPathContextSource contextSource) {
        super((ContextSource)contextSource);
    }

    @Override
    public DirContextOperations authenticate(Authentication authentication) {
        String dn;
        DirContextOperations user = null;
        Assert.isInstanceOf(UsernamePasswordAuthenticationToken.class, (Object)authentication, (String)"Can only process UsernamePasswordAuthenticationToken objects");
        String username = authentication.getName();
        String password = (String)authentication.getCredentials();
        if (!StringUtils.hasLength((String)password)) {
            logger.debug((Object)LogMessage.format((String)"Rejecting empty password for user %s", (Object)username));
            throw new BadCredentialsException(this.messages.getMessage("BindAuthenticator.emptyPassword", "Empty Password"));
        }
        Iterator<String> iterator = this.getUserDns(username).iterator();
        while (iterator.hasNext() && (user = this.bindWithDn(dn = iterator.next(), username, password)) == null) {
        }
        if (user == null && this.getUserSearch() != null) {
            DirContextOperations userFromSearch = this.getUserSearch().searchForUser(username);
            user = this.bindWithDn(userFromSearch.getDn().toString(), username, password, userFromSearch.getAttributes());
        }
        if (user == null) {
            throw new BadCredentialsException(this.messages.getMessage("BindAuthenticator.badCredentials", "Bad credentials"));
        }
        return user;
    }

    private DirContextOperations bindWithDn(String userDnStr, String username, String password) {
        return this.bindWithDn(userDnStr, username, password, null);
    }

    /*
     * Loose catch block
     * WARNING - bad return control flow
     */
    private DirContextOperations bindWithDn(String userDnStr, String username, String password, Attributes attrs) {
        DirContextAdapter dirContextAdapter;
        BaseLdapPathContextSource ctxSource = (BaseLdapPathContextSource)this.getContextSource();
        DistinguishedName userDn = new DistinguishedName(userDnStr);
        DistinguishedName fullDn = new DistinguishedName((Name)userDn);
        fullDn.prepend(ctxSource.getBaseLdapPath());
        logger.debug((Object)LogMessage.format((String)"Attempting to bind as %s", (Object)fullDn));
        DirContext ctx = null;
        try {
            ctx = this.getContextSource().getContext(fullDn.toString(), password);
            PasswordPolicyResponseControl ppolicy = PasswordPolicyControlExtractor.extractControl(ctx);
            logger.debug((Object)"Retrieving attributes...");
            if (attrs == null || attrs.size() == 0) {
                attrs = ctx.getAttributes((Name)userDn, this.getUserAttributes());
            }
            DirContextAdapter result = new DirContextAdapter(attrs, (Name)userDn, (Name)ctxSource.getBaseLdapPath());
            if (ppolicy != null) {
                result.setAttributeValue(ppolicy.getID(), (Object)ppolicy);
            }
            dirContextAdapter = result;
        }
        catch (NamingException ex) {
            if (!(ex instanceof AuthenticationException) && !(ex instanceof OperationNotSupportedException)) {
                throw ex;
            }
            this.handleBindException(userDnStr, username, ex);
            LdapUtils.closeContext((DirContext)ctx);
        }
        catch (javax.naming.NamingException ex2) {
            throw LdapUtils.convertLdapException((javax.naming.NamingException)ex2);
            {
                catch (Throwable throwable) {
                    LdapUtils.closeContext(ctx);
                    throw throwable;
                }
            }
        }
        LdapUtils.closeContext((DirContext)ctx);
        return dirContextAdapter;
        return null;
    }

    protected void handleBindException(String userDn, String username, Throwable cause) {
        logger.debug((Object)LogMessage.format((String)"Failed to bind as %s: %s", (Object)userDn, (Object)cause));
    }
}

