/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.udm;

import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.IDictionary;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import java.util.HashSet;
import java.util.Set;

@PublicApiRef
public abstract class AbstractDictionary
extends BaseConfigurationItem
implements IDictionary {
    @Property(required=false, label="Restrict to containers", description="Only apply this dictionary to the containers mentioned", category="Restrictions")
    private Set<Container> restrictToContainers = new HashSet<Container>();
    @Property(required=false, label="Restrict to applications", description="Only apply this dictionary to the applications mentioned", category="Restrictions")
    private Set<Application> restrictToApplications = new HashSet<Application>();

    public Set<Container> getRestrictToContainers() {
        return this.restrictToContainers;
    }

    public Set<Application> getRestrictToApplications() {
        return this.restrictToApplications;
    }

    @Override
    public IDictionary applyTo(IDictionary.DictionaryContext context) {
        boolean containerMatches;
        boolean appMatches = this.getRestrictToApplications().isEmpty() || this.getRestrictToApplications().contains(context.getApplication());
        boolean bl = containerMatches = this.getRestrictToContainers().isEmpty() || this.getRestrictToContainers().contains(context.getContainer());
        if (appMatches && containerMatches) {
            return this;
        }
        return null;
    }
}

