/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.sftp;

import java.io.Closeable;
import java.io.IOException;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.schmizz.sshj.sftp.FileAttributes;
import net.schmizz.sshj.sftp.FileMode;
import net.schmizz.sshj.sftp.OpenMode;
import net.schmizz.sshj.sftp.PathComponents;
import net.schmizz.sshj.sftp.RemoteDirectory;
import net.schmizz.sshj.sftp.RemoteFile;
import net.schmizz.sshj.sftp.RemoteResourceFilter;
import net.schmizz.sshj.sftp.RemoteResourceInfo;
import net.schmizz.sshj.sftp.Response;
import net.schmizz.sshj.sftp.SFTPEngine;
import net.schmizz.sshj.sftp.SFTPException;
import net.schmizz.sshj.sftp.SFTPFileTransfer;
import net.schmizz.sshj.xfer.FilePermission;
import net.schmizz.sshj.xfer.LocalDestFile;
import net.schmizz.sshj.xfer.LocalSourceFile;
import org.slf4j.Logger;

public class SFTPClient
implements Closeable {
    protected final Logger log;
    protected final SFTPEngine engine;
    protected final SFTPFileTransfer xfer;

    public SFTPClient(SFTPEngine engine) {
        this.engine = engine;
        this.log = engine.getLoggerFactory().getLogger(this.getClass());
        this.xfer = new SFTPFileTransfer(engine);
    }

    public SFTPEngine getSFTPEngine() {
        return this.engine;
    }

    public SFTPFileTransfer getFileTransfer() {
        return this.xfer;
    }

    public List<RemoteResourceInfo> ls(String path) throws IOException {
        return this.ls(path, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RemoteResourceInfo> ls(String path, RemoteResourceFilter filter) throws IOException {
        RemoteDirectory dir = this.engine.openDir(path);
        try {
            List<RemoteResourceInfo> list = dir.scan(filter);
            return list;
        }
        finally {
            dir.close();
        }
    }

    public RemoteFile open(String filename, Set<OpenMode> mode, FileAttributes attrs) throws IOException {
        this.log.debug("Opening `{}`", (Object)filename);
        return this.engine.open(filename, mode, attrs);
    }

    public RemoteFile open(String filename, Set<OpenMode> mode) throws IOException {
        return this.open(filename, mode, FileAttributes.EMPTY);
    }

    public RemoteFile open(String filename) throws IOException {
        return this.open(filename, EnumSet.of(OpenMode.READ));
    }

    public void mkdir(String dirname) throws IOException {
        this.engine.makeDir(dirname);
    }

    public void mkdirs(String path) throws IOException {
        LinkedList<String> dirsToMake = new LinkedList<String>();
        PathComponents current = this.engine.getPathHelper().getComponents(path);
        while (true) {
            FileAttributes attrs;
            if ((attrs = this.statExistence(current.getPath())) != null) {
                if (attrs.getType() == FileMode.Type.DIRECTORY) break;
                throw new SFTPException(current.getPath() + " exists but is not a directory");
            }
            dirsToMake.push(current.getPath());
            current = this.engine.getPathHelper().getComponents(current.getParent());
        }
        while (!dirsToMake.isEmpty()) {
            this.mkdir((String)dirsToMake.pop());
        }
    }

    public FileAttributes statExistence(String path) throws IOException {
        try {
            return this.engine.stat(path);
        }
        catch (SFTPException sftpe) {
            if (sftpe.getStatusCode() == Response.StatusCode.NO_SUCH_FILE) {
                return null;
            }
            throw sftpe;
        }
    }

    public void rename(String oldpath, String newpath) throws IOException {
        this.engine.rename(oldpath, newpath);
    }

    public void rm(String filename) throws IOException {
        this.engine.remove(filename);
    }

    public void rmdir(String dirname) throws IOException {
        this.engine.removeDir(dirname);
    }

    public void symlink(String linkpath, String targetpath) throws IOException {
        this.engine.symlink(linkpath, targetpath);
    }

    public int version() {
        return this.engine.getOperativeProtocolVersion();
    }

    public void setattr(String path, FileAttributes attrs) throws IOException {
        this.engine.setAttributes(path, attrs);
    }

    public int uid(String path) throws IOException {
        return this.stat(path).getUID();
    }

    public int gid(String path) throws IOException {
        return this.stat(path).getGID();
    }

    public long atime(String path) throws IOException {
        return this.stat(path).getAtime();
    }

    public long mtime(String path) throws IOException {
        return this.stat(path).getMtime();
    }

    public Set<FilePermission> perms(String path) throws IOException {
        return this.stat(path).getPermissions();
    }

    public FileMode mode(String path) throws IOException {
        return this.stat(path).getMode();
    }

    public FileMode.Type type(String path) throws IOException {
        return this.stat(path).getType();
    }

    public String readlink(String path) throws IOException {
        return this.engine.readLink(path);
    }

    public FileAttributes stat(String path) throws IOException {
        return this.engine.stat(path);
    }

    public FileAttributes lstat(String path) throws IOException {
        return this.engine.lstat(path);
    }

    public void chown(String path, int uid) throws IOException {
        this.setattr(path, new FileAttributes.Builder().withUIDGID(uid, this.gid(path)).build());
    }

    public void chmod(String path, int perms) throws IOException {
        this.setattr(path, new FileAttributes.Builder().withPermissions(perms).build());
    }

    public void chgrp(String path, int gid) throws IOException {
        this.setattr(path, new FileAttributes.Builder().withUIDGID(this.uid(path), gid).build());
    }

    public void truncate(String path, long size) throws IOException {
        this.setattr(path, new FileAttributes.Builder().withSize(size).build());
    }

    public String canonicalize(String path) throws IOException {
        return this.engine.canonicalize(path);
    }

    public long size(String path) throws IOException {
        return this.stat(path).getSize();
    }

    public void get(String source, String dest) throws IOException {
        this.xfer.download(source, dest);
    }

    public void put(String source, String dest) throws IOException {
        this.xfer.upload(source, dest);
    }

    public void get(String source, LocalDestFile dest) throws IOException {
        this.xfer.download(source, dest);
    }

    public void put(LocalSourceFile source, String dest) throws IOException {
        this.xfer.upload(source, dest);
    }

    @Override
    public void close() throws IOException {
        this.engine.close();
    }
}

