/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.thirdparty.publicsuffix;

import org.python.google.common.annotations.Beta;
import org.python.google.common.annotations.GwtCompatible;

@Beta
@GwtCompatible
public enum PublicSuffixType {
    PRIVATE(':', ','),
    REGISTRY('!', '?');

    private final char innerNodeCode;
    private final char leafNodeCode;

    private PublicSuffixType(char innerNodeCode, char leafNodeCode) {
        this.innerNodeCode = innerNodeCode;
        this.leafNodeCode = leafNodeCode;
    }

    char getLeafNodeCode() {
        return this.leafNodeCode;
    }

    char getInnerNodeCode() {
        return this.innerNodeCode;
    }

    static PublicSuffixType fromCode(char code2) {
        for (PublicSuffixType value : PublicSuffixType.values()) {
            if (value.getInnerNodeCode() != code2 && value.getLeafNodeCode() != code2) continue;
            return value;
        }
        throw new IllegalArgumentException("No enum corresponding to given code: " + code2);
    }

    static PublicSuffixType fromIsPrivate(boolean isPrivate) {
        return isPrivate ? PRIVATE : REGISTRY;
    }
}

