/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlplatform.scheduler.spring;

import com.xebialabs.deployit.engine.tasker.TaskExecutionEngine;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.WorkDirFactory;
import com.xebialabs.deployit.service.gc.GarbageCollectionService;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServiceHolder {
    private static final AtomicReference<RepositoryService> repositoryService = new AtomicReference();
    private static final AtomicReference<TaskExecutionEngine> taskExecutionEngine = new AtomicReference();
    private static final AtomicReference<WorkDirFactory> workDirFactory = new AtomicReference();
    private static final AtomicReference<GarbageCollectionService> garbageCollectionService = new AtomicReference();

    @Autowired
    public ServiceHolder(RepositoryService repositoryService, WorkDirFactory workDirFactory, GarbageCollectionService garbageCollectionService) {
        ServiceHolder.repositoryService.set(repositoryService);
        ServiceHolder.workDirFactory.set(workDirFactory);
        ServiceHolder.garbageCollectionService.set(garbageCollectionService);
    }

    public static void setTaskExecutionEngine(TaskExecutionEngine engine) {
        taskExecutionEngine.set(engine);
    }

    public static RepositoryService getRepositoryService() {
        return repositoryService.get();
    }

    public static TaskExecutionEngine getTaskExecutionEngine() {
        return taskExecutionEngine.get();
    }

    public static WorkDirFactory getWorkDirFactory() {
        return workDirFactory.get();
    }

    public static GarbageCollectionService getGarabageCollectionService() {
        return garbageCollectionService.get();
    }
}

