/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.event.internal;

import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.jpa.event.internal.CallbackBuilderLegacyImpl;
import org.hibernate.jpa.event.internal.CallbackRegistryImpl;
import org.hibernate.jpa.event.internal.CallbackRegistryImplementor;
import org.hibernate.jpa.event.internal.EmptyCallbackBuilder;
import org.hibernate.jpa.event.internal.EmptyCallbackRegistryImpl;
import org.hibernate.jpa.event.spi.CallbackBuilder;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;

public final class CallbacksFactory {
    public static CallbackRegistryImplementor buildCallbackRegistry(SessionFactoryImplementor sessionFactory) {
        if (CallbacksFactory.jpaCallBacksEnabled(sessionFactory)) {
            return new CallbackRegistryImpl();
        }
        return new EmptyCallbackRegistryImpl();
    }

    public static CallbackBuilder buildCallbackBuilder(SessionFactoryImplementor sessionFactory, ReflectionManager reflectionManager) {
        if (CallbacksFactory.jpaCallBacksEnabled(sessionFactory)) {
            ManagedBeanRegistry managedBeanRegistry = sessionFactory.getServiceRegistry().getService(ManagedBeanRegistry.class);
            return new CallbackBuilderLegacyImpl(managedBeanRegistry, reflectionManager);
        }
        return new EmptyCallbackBuilder();
    }

    private static boolean jpaCallBacksEnabled(SessionFactoryImplementor sessionFactory) {
        SessionFactoryOptions options = sessionFactory.getSessionFactoryOptions();
        return options.areJPACallbacksEnabled();
    }
}

