/*
 * Decompiled with CFR 0.152.
 */
package com.github.drapostolos.typeparser;

import com.github.drapostolos.typeparser.Parsers;
import com.github.drapostolos.typeparser.TypeParserUtility;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

abstract class ParseTemplate<T> {
    final Type targetType;
    final Parsers typeParsers;

    protected ParseTemplate(Parsers typeParsers, Type targetType) {
        this.targetType = targetType;
        this.typeParsers = typeParsers;
    }

    abstract T actionWhenTargetTypeHasNormalTypeParser();

    abstract T actionWhenTaretTypeIsGeneric(Class<?> var1);

    abstract T actionWhenTargetTypeIsArrayClass();

    abstract T actionWhenTargetTypeIsGenericArrayType();

    abstract T actionWhenTargetTypeIsAssignalbleTo(Class<?> var1);

    abstract T actionWhenTargetTypeHasStaticFactoryMethod();

    abstract T lastAction();

    final T execute() {
        if (this.typeParsers.parsers.containsKey(this.targetType)) {
            return this.actionWhenTargetTypeHasNormalTypeParser();
        }
        if (this.targetType instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)this.targetType;
            Class rawTargetType = (Class)type.getRawType();
            for (Class<?> rawSuperType : this.typeParsers.assignableParsers.keySet()) {
                if (!rawTargetType.isAssignableFrom(rawSuperType)) continue;
                return this.actionWhenTaretTypeIsGeneric(rawSuperType);
            }
        }
        if (this.targetType instanceof Class) {
            Class targetClass = (Class)this.targetType;
            if (targetClass.isArray()) {
                return this.actionWhenTargetTypeIsArrayClass();
            }
            for (Class<?> superClass : this.typeParsers.assignableParsers.keySet()) {
                if (!superClass.isAssignableFrom(targetClass)) continue;
                return this.actionWhenTargetTypeIsAssignalbleTo(superClass);
            }
            if (TypeParserUtility.containsStaticFactoryMethodNamedValueOf(targetClass)) {
                return this.actionWhenTargetTypeHasStaticFactoryMethod();
            }
        }
        if (this.targetType instanceof GenericArrayType) {
            return this.actionWhenTargetTypeIsGenericArrayType();
        }
        return this.lastAction();
    }
}

