/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.function;

import com.datical.liquibase.ext.config.LiquibaseProConfiguration;
import com.datical.liquibase.ext.storedlogic.AbstractMissingStoredLogicChangeGenerator;
import com.datical.liquibase.ext.storedlogic.function.ChangedFunctionChangeGenerator;
import com.datical.liquibase.ext.storedlogic.function.Function;
import com.datical.liquibase.ext.storedlogic.function.change.CreateFunctionChange;
import com.datical.liquibase.ext.util.ObjectSqlFileUtil;
import liquibase.change.Change;
import liquibase.change.core.CreateProcedureChange;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.database.Database;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.servicelocator.LiquibaseService;
import liquibase.structure.DatabaseObject;

@LiquibaseService
public class ChangedFunctionExternalFileChangeGenerator
extends ChangedFunctionChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> clazz, Database database) {
        if (!LiquibaseConfiguration.getInstance().getConfiguration(LiquibaseProConfiguration.class).getInlineSql() && Function.class.isAssignableFrom(clazz)) {
            return super.getPriority(clazz, database) + 100;
        }
        return -1;
    }

    @Override
    public Change[] fixChanged(DatabaseObject databaseObject, ObjectDifferences changeArray, DiffOutputControl object, Database database, Database database2, ChangeGeneratorChain changeGeneratorChain) {
        if ((changeArray = super.fixChanged(databaseObject, (ObjectDifferences)changeArray, (DiffOutputControl)object, database, database2, changeGeneratorChain)) == null) {
            return null;
        }
        object = AbstractMissingStoredLogicChangeGenerator.findChange(CreateFunctionChange.class, changeArray);
        ((CreateProcedureChange)object).setRelativeToChangelogFile(Boolean.TRUE);
        ((CreateProcedureChange)object).setPath(ObjectSqlFileUtil.writeObjectSql((Function)databaseObject));
        ((CreateFunctionChange)object).setFunctionBody(null);
        return changeArray;
    }
}

