/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization.principalbased;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.apache.jackrabbit.api.jsr283.security.AccessControlEntry;
import org.apache.jackrabbit.api.jsr283.security.AccessControlManager;
import org.apache.jackrabbit.api.jsr283.security.AccessControlPolicy;
import org.apache.jackrabbit.api.jsr283.security.Privilege;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.core.ItemImpl;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.observation.SynchronousEventListener;
import org.apache.jackrabbit.core.security.authorization.AbstractAccessControlProvider;
import org.apache.jackrabbit.core.security.authorization.AbstractCompiledPermissions;
import org.apache.jackrabbit.core.security.authorization.AccessControlConstants;
import org.apache.jackrabbit.core.security.authorization.AccessControlEditor;
import org.apache.jackrabbit.core.security.authorization.CompiledPermissions;
import org.apache.jackrabbit.core.security.authorization.Permission;
import org.apache.jackrabbit.core.security.authorization.UnmodifiableAccessControlList;
import org.apache.jackrabbit.core.security.authorization.principalbased.ACLEditor;
import org.apache.jackrabbit.core.security.authorization.principalbased.ACLTemplate;
import org.apache.jackrabbit.core.security.principal.PrincipalImpl;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.name.PathFactoryImpl;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ACLProvider
extends AbstractAccessControlProvider
implements AccessControlConstants {
    private static Logger log = LoggerFactory.getLogger((Class)ACLProvider.class);
    private ACLEditor editor;
    private NodeImpl acRoot;

    public boolean isAcItem(Path absPath) throws RepositoryException {
        Path.Element[] elems = absPath.getElements();
        for (int i = 0; i < elems.length; ++i) {
            if (!N_POLICY.equals(elems[i].getName())) continue;
            return true;
        }
        return false;
    }

    public boolean isAcItem(ItemImpl item) throws RepositoryException {
        NodeImpl n = item.isNode() ? (NodeImpl)item : (NodeImpl)item.getParent();
        return n.isNodeType(NT_REP_ACL) || n.isNodeType(NT_REP_ACE);
    }

    public void init(Session systemSession, Map configuration) throws RepositoryException {
        super.init(systemSession, configuration);
        NodeImpl root = (NodeImpl)this.session.getRootNode();
        if (root.hasNode(N_ACCESSCONTROL)) {
            this.acRoot = root.getNode(N_ACCESSCONTROL);
            if (!this.acRoot.isNodeType(NT_REP_ACCESS_CONTROL)) {
                throw new RepositoryException("Error while initializing Access Control Provider: Found ac-root to be wrong node type " + this.acRoot.getPrimaryNodeType().getName());
            }
        } else {
            this.acRoot = root.addNode(N_ACCESSCONTROL, NT_REP_ACCESS_CONTROL, null);
        }
        this.editor = new ACLEditor(this.session, this.resolver.getQPath(this.acRoot.getPath()));
        if (!configuration.containsKey("omit-default-permission")) {
            try {
                Principal administrators;
                log.info("Install initial permissions: ...");
                ValueFactory vf = this.session.getValueFactory();
                HashMap<String, Value> restrictions = new HashMap<String, Value>();
                restrictions.put(this.session.getJCRName(ACLTemplate.P_NODE_PATH), vf.createValue(root.getPath(), 8));
                restrictions.put(this.session.getJCRName(ACLTemplate.P_GLOB), vf.createValue("*"));
                PrincipalManager pMgr = this.session.getPrincipalManager();
                AccessControlManager acMgr = this.session.getAccessControlManager();
                String pName = "administrators";
                if (pMgr.hasPrincipal(pName)) {
                    administrators = pMgr.getPrincipal(pName);
                } else {
                    log.warn("Administrators principal group is missing.");
                    administrators = new PrincipalImpl(pName);
                }
                AccessControlPolicy[] acls = this.editor.editAccessControlPolicies(administrators);
                ACLTemplate acl = (ACLTemplate)acls[0];
                if (acl.isEmpty()) {
                    log.info("... Privilege.ALL for administrators principal.");
                    acl.addEntry(administrators, new Privilege[]{acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}all")}, true, restrictions);
                    this.editor.setPolicy(acl.getPath(), acl);
                } else {
                    log.info("... policy for administrators principal already present.");
                }
                Principal everyone = pMgr.getEveryone();
                acls = this.editor.editAccessControlPolicies(everyone);
                acl = (ACLTemplate)acls[0];
                if (acl.isEmpty()) {
                    log.info("... Privilege.READ for everyone principal.");
                    acl.addEntry(everyone, new Privilege[]{acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}read")}, true, restrictions);
                    this.editor.setPolicy(acl.getPath(), acl);
                } else {
                    log.info("... policy for everyone principal already present.");
                }
                this.session.save();
                log.info("... done.");
            }
            catch (RepositoryException e) {
                log.error("Failed to set-up minimal access control for root node of workspace " + this.session.getWorkspace().getName());
                this.session.getRootNode().refresh(false);
                throw e;
            }
        }
    }

    public AccessControlPolicy[] getEffectivePolicies(Path absPath) throws ItemNotFoundException, RepositoryException {
        AccessControlPolicy[] tmpls = this.editor.getPolicies(this.session.getJCRPath(absPath));
        AccessControlPolicy[] effectives = new AccessControlPolicy[tmpls.length];
        for (int i = 0; i < tmpls.length; ++i) {
            effectives[i] = new UnmodifiableAccessControlList((ACLTemplate)tmpls[i]);
        }
        return effectives;
    }

    public AccessControlEditor getEditor(Session editingSession) {
        this.checkInitialized();
        if (editingSession instanceof SessionImpl) {
            try {
                return new ACLEditor((SessionImpl)editingSession, this.session.getQPath(this.acRoot.getPath()));
            }
            catch (RepositoryException e) {
                log.error("Internal error: ", (Object)e.getMessage());
            }
        }
        log.debug("Unable to build access control editor " + ACLEditor.class.getName() + ".");
        return null;
    }

    public CompiledPermissions compilePermissions(Set principals) throws RepositoryException {
        this.checkInitialized();
        if (this.isAdminOrSystem(principals)) {
            return ACLProvider.getAdminPermissions();
        }
        if (this.isReadOnly(principals)) {
            return this.getReadOnlyPermissions();
        }
        return new CompiledPermissionImpl(principals);
    }

    public boolean canAccessRoot(Set principals) throws RepositoryException {
        this.checkInitialized();
        if (this.isAdminOrSystem(principals)) {
            return true;
        }
        CompiledPermissionImpl cp = new CompiledPermissionImpl(principals, false);
        return cp.grants(PathFactoryImpl.getInstance().getRootPath(), 1);
    }

    private class Entries {
        private final List entries;

        private Entries(List entries) {
            this.entries = entries;
        }

        private AbstractCompiledPermissions.Result getResult(Item target, String targetPath, boolean isAcItem) throws RepositoryException {
            int allows = 0;
            int denies = 0;
            int allowPrivileges = 0;
            int denyPrivileges = 0;
            int parentAllows = 0;
            int parentDenies = 0;
            String parentPath = Text.getRelativeParent(targetPath, 1);
            Iterator it = this.entries.iterator();
            while (it.hasNext() && allows != 31) {
                int permissions;
                boolean matches;
                ACLTemplate.Entry entr = (ACLTemplate.Entry)it.next();
                int privs = entr.getPrivilegeBits();
                if (!"".equals(parentPath) && entr.matches(parentPath)) {
                    if (entr.isAllow()) {
                        parentAllows |= Permission.diff(privs, parentDenies);
                    } else {
                        parentDenies |= Permission.diff(privs, parentAllows);
                    }
                }
                if (!(matches = target != null ? entr.matches(target) : entr.matches(targetPath))) continue;
                if (entr.isAllow()) {
                    permissions = Permission.calculatePermissions(allowPrivileges |= Permission.diff(privs, denyPrivileges), parentAllows, true, isAcItem);
                    allows |= Permission.diff(permissions, denies);
                    continue;
                }
                permissions = Permission.calculatePermissions(denyPrivileges |= Permission.diff(privs, allowPrivileges), parentDenies, false, isAcItem);
                denies |= Permission.diff(permissions, allows);
            }
            return new AbstractCompiledPermissions.Result(allows, denies, allowPrivileges, denyPrivileges);
        }
    }

    private class CompiledPermissionImpl
    extends AbstractCompiledPermissions
    implements SynchronousEventListener {
        private final Set principals;
        private final Set acPaths;
        private Entries entries;

        private CompiledPermissionImpl(Set principals) throws RepositoryException {
            this(principals, true);
        }

        private CompiledPermissionImpl(Set principals, boolean listenToEvents) throws RepositoryException {
            this.principals = principals;
            this.acPaths = new HashSet(principals.size());
            this.entries = this.reload();
            if (listenToEvents) {
                int events = 31;
                String[] ntNames = new String[]{ACLProvider.this.session.getJCRName(AccessControlConstants.NT_REP_ACE)};
                ACLProvider.this.observationMgr.addEventListener((EventListener)this, events, ACLProvider.this.acRoot.getPath(), true, null, ntNames, false);
            }
        }

        protected synchronized AbstractCompiledPermissions.Result buildResult(Path absPath) throws RepositoryException {
            AbstractCompiledPermissions.Result result;
            if (!absPath.isAbsolute()) {
                throw new RepositoryException("Absolute path expected.");
            }
            boolean isAcItem = ACLProvider.this.isAcItem(absPath);
            String jcrPath = ACLProvider.this.session.getJCRPath(absPath);
            if (ACLProvider.this.session.itemExists(jcrPath)) {
                Item item = ACLProvider.this.session.getItem(jcrPath);
                result = this.entries.getResult(item, item.getPath(), isAcItem);
            } else {
                result = this.entries.getResult(null, jcrPath, isAcItem);
            }
            return result;
        }

        public void close() {
            try {
                ACLProvider.this.observationMgr.removeEventListener((EventListener)this);
            }
            catch (RepositoryException e) {
                log.debug("Unable to unregister listener: ", (Object)e.getMessage());
            }
            super.close();
        }

        public synchronized void onEvent(EventIterator events) {
            try {
                boolean reload = false;
                while (events.hasNext() && !reload) {
                    Event ev = events.nextEvent();
                    String path = ev.getPath();
                    switch (ev.getType()) {
                        case 1: 
                        case 2: {
                            reload = this.acPaths.contains(Text.getRelativeParent(path, 2));
                            break;
                        }
                        case 4: 
                        case 8: 
                        case 16: {
                            reload = this.acPaths.contains(Text.getRelativeParent(path, 3));
                            break;
                        }
                    }
                }
                if (reload) {
                    this.clearCache();
                    this.entries = this.reload();
                }
            }
            catch (RepositoryException e) {
                log.warn("Internal error: ", (Object)e.getMessage());
            }
        }

        private Entries reload() throws RepositoryException {
            this.acPaths.clear();
            ArrayList<AccessControlEntry> allACEs = new ArrayList<AccessControlEntry>();
            Iterator it = this.principals.iterator();
            while (it.hasNext()) {
                Principal princ = (Principal)it.next();
                ACLTemplate acl = ACLProvider.this.editor.getACL(princ);
                if (acl == null || acl.isEmpty()) {
                    this.acPaths.add(ACLProvider.this.editor.getPathToAcNode(princ));
                    continue;
                }
                AccessControlEntry[] aces = acl.getAccessControlEntries();
                allACEs.addAll(Arrays.asList(aces));
                this.acPaths.add(acl.getPath());
            }
            return new Entries(allACEs);
        }
    }
}

