/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.encryption;

import com.xebialabs.deployit.conversion.Base64Coder;
import com.xebialabs.deployit.encryption.IPasswordEncrypter;
import com.xebialabs.deployit.encryption.PasswordEncrypterBase;
import com.xebialabs.deployit.security.SecretKeyHolder;
import java.nio.charset.StandardCharsets;
import javax.crypto.SecretKey;

public class LegacyPasswordEncrypter
extends PasswordEncrypterBase
implements IPasswordEncrypter {
    public LegacyPasswordEncrypter(SecretKeyHolder encryptionKeyHolder) {
        super(encryptionKeyHolder);
        this.coder = new Base64Coder();
    }

    public LegacyPasswordEncrypter(SecretKey passwordEncryptionKey) {
        this(new SecretKeyHolder(passwordEncryptionKey));
    }

    @Override
    public String doEncrypt(String plaintext) throws IllegalStateException {
        byte[] encrypted = this.crypt(plaintext.getBytes(StandardCharsets.UTF_8), this.encryptionKeyHolder.getEncryption());
        return new String(this.coder.encode(encrypted), StandardCharsets.UTF_8);
    }

    @Override
    public String doDecodeAndDecrypt(String text) throws IllegalStateException {
        byte[] decoded = this.coder.decode(text.getBytes(StandardCharsets.UTF_8));
        byte[] decrypted = this.crypt(decoded, this.encryptionKeyHolder.getDecryption());
        return new String(decrypted, StandardCharsets.UTF_8);
    }

    @Override
    public String getKeyFingerprint(String algorithm) {
        return this.encryptionKeyHolder.getKeyFingerprint(algorithm);
    }
}

