/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util.csv.opencsv.bean;

import java.lang.reflect.Field;
import liquibase.util.StringUtil;

public class BeanField {
    private final Field field;
    private final boolean required;

    public BeanField(Field field, boolean required) {
        this.field = field;
        this.required = required;
    }

    public Field getField() {
        return this.field;
    }

    public boolean isRequired() {
        return this.required;
    }

    public <T> void setFieldValue(T bean, String value) throws IllegalAccessException {
        if (this.required && StringUtil.trimToNull(value) == null) {
            throw new IllegalStateException(String.format("Field '%s' is mandatory but no value was provided.", this.field.getName()));
        }
        if (StringUtil.trimToNull(value) != null) {
            Class<String> fieldType = this.field.getType();
            this.field.setAccessible(true);
            if (fieldType.equals(Boolean.TYPE)) {
                this.field.setBoolean(bean, Boolean.valueOf(value.trim()));
            } else if (fieldType.equals(Byte.TYPE)) {
                this.field.setByte(bean, Byte.valueOf(value.trim()));
            } else if (fieldType.equals(Double.TYPE)) {
                this.field.setDouble(bean, Double.valueOf(value.trim()));
            } else if (fieldType.equals(Float.TYPE)) {
                this.field.setFloat(bean, Float.valueOf(value.trim()).floatValue());
            } else if (fieldType.equals(Integer.TYPE)) {
                this.field.setInt(bean, Integer.parseInt(value.trim()));
            } else if (fieldType.equals(Long.TYPE)) {
                this.field.setLong(bean, Long.parseLong(value.trim()));
            } else if (fieldType.equals(Short.TYPE)) {
                this.field.setShort(bean, Short.valueOf(value.trim()));
            } else if (fieldType.equals(Character.TYPE)) {
                this.field.setChar(bean, value.charAt(0));
            } else if (fieldType.isAssignableFrom(String.class)) {
                this.field.set(bean, value);
            } else {
                throw new IllegalStateException(String.format("Unable to set field value for field '%s' with value '%s' - type is unsupported. Use primitive and String types only.", fieldType, value));
            }
        }
    }
}

