/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.cluster;

import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.protocol.ServerPacketDecoder;
import org.apache.activemq.artemis.core.protocol.core.impl.ActiveMQClientProtocolManager;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketDecoder;
import org.apache.activemq.artemis.spi.core.remoting.ClientProtocolManager;
import org.apache.activemq.artemis.spi.core.remoting.ClientProtocolManagerFactory;

public class ActiveMQServerSideProtocolManagerFactory
implements ClientProtocolManagerFactory {
    ServerLocator locator;
    final StorageManager storageManager;
    private static final long serialVersionUID = 1L;

    private ActiveMQServerSideProtocolManagerFactory(StorageManager storageManager) {
        this.storageManager = storageManager;
    }

    public ServerLocator getLocator() {
        return this.locator;
    }

    public void setLocator(ServerLocator locator) {
        this.locator = locator;
    }

    public static ActiveMQServerSideProtocolManagerFactory getInstance(ServerLocator locator, StorageManager storageManager) {
        ActiveMQServerSideProtocolManagerFactory instance = new ActiveMQServerSideProtocolManagerFactory(storageManager);
        instance.setLocator(locator);
        return instance;
    }

    public TransportConfiguration adaptTransportConfiguration(TransportConfiguration tc) {
        return tc;
    }

    public ClientProtocolManager newProtocolManager() {
        return new ActiveMQReplicationProtocolManager();
    }

    class ActiveMQReplicationProtocolManager
    extends ActiveMQClientProtocolManager {
        ActiveMQReplicationProtocolManager() {
        }

        protected PacketDecoder createPacketDecoder() {
            return new ServerPacketDecoder(ActiveMQServerSideProtocolManagerFactory.this.storageManager);
        }
    }
}

