/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import org.apache.commons.codec.binary.Hex;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaCryptoUtils {
    public static final String BOUNCY_CASTLE = "BC";
    private static boolean registrationDone;
    private static String securityProvider;
    private static final Logger logger;

    private JavaCryptoUtils() {
    }

    public static MessageDigest getSha1() {
        return JavaCryptoUtils.getSha("SHA1");
    }

    public static MessageDigest getSha256() {
        return JavaCryptoUtils.getSha("SHA256");
    }

    private static MessageDigest getSha(String shaType) {
        JavaCryptoUtils.register();
        try {
            return MessageDigest.getInstance(shaType, BOUNCY_CASTLE);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new IllegalStateException("Should have registered Bouncy Castle as JCE provider.");
        }
    }

    public static String digest(MessageDigest md) {
        return Hex.encodeHexString((byte[])md.digest());
    }

    private static void register() {
        if (!registrationDone) {
            if (securityProvider == null) {
                try {
                    new BouncyCastleRegistration().run();
                }
                catch (Throwable t) {
                    logger.error("Failed to register BouncyCastle as the defaut JCE provider");
                    throw new IllegalStateException("Failed to register BouncyCastle as the defaut JCE provider", t);
                }
            }
            registrationDone = true;
        }
    }

    static {
        logger = LoggerFactory.getLogger(JavaCryptoUtils.class);
    }

    private static class BouncyCastleRegistration {
        private BouncyCastleRegistration() {
        }

        public void run() throws Exception {
            if (Security.getProvider(JavaCryptoUtils.BOUNCY_CASTLE) == null) {
                logger.info("Registering BouncyCastle as a JCE provider");
                Security.addProvider((Provider)new BouncyCastleProvider());
                MessageDigest.getInstance("SHA1", JavaCryptoUtils.BOUNCY_CASTLE);
            } else {
                logger.debug("BouncyCastle already registered as a JCE provider");
            }
            securityProvider = JavaCryptoUtils.BOUNCY_CASTLE;
        }
    }
}

