/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.hazelcast;

import com.hazelcast.config.Config;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.config.YamlConfigBuilder;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import java.io.IOException;
import java.net.URL;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

@Deprecated
public class HazelcastInstanceFactory {
    private final Config config;

    public HazelcastInstanceFactory(Resource configLocation) throws IOException {
        Assert.notNull((Object)configLocation, (String)"ConfigLocation must not be null");
        this.config = this.getConfig(configLocation);
    }

    public HazelcastInstanceFactory(Config config) {
        Assert.notNull((Object)config, (String)"Config must not be null");
        this.config = config;
    }

    private Config getConfig(Resource configLocation) throws IOException {
        URL configUrl = configLocation.getURL();
        Config config = HazelcastInstanceFactory.createConfig(configUrl);
        if (ResourceUtils.isFileURL((URL)configUrl)) {
            config.setConfigurationFile(configLocation.getFile());
        } else {
            config.setConfigurationUrl(configUrl);
        }
        return config;
    }

    private static Config createConfig(URL configUrl) throws IOException {
        String configFileName = configUrl.getPath();
        if (configFileName.endsWith(".yaml")) {
            return new YamlConfigBuilder(configUrl).build();
        }
        return new XmlConfigBuilder(configUrl).build();
    }

    public HazelcastInstance getHazelcastInstance() {
        if (StringUtils.hasText((String)this.config.getInstanceName())) {
            return Hazelcast.getOrCreateHazelcastInstance((Config)this.config);
        }
        return Hazelcast.newHazelcastInstance((Config)this.config);
    }
}

