/*
 * Decompiled with CFR 0.152.
 */
package nl.javadude.scannit.registry;

import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import nl.javadude.scannit.metadata.DescriptorHelper;
import nl.javadude.scannit.registry.Registry;
import nl.javadude.scannit.scanner.FieldAnnotationScanner;
import nl.javadude.scannit.scanner.MethodAnnotationScanner;
import nl.javadude.scannit.scanner.SubTypeScanner;
import nl.javadude.scannit.scanner.TypeAnnotationScanner;

public class RegistryHelper {
    private Registry registry;

    public RegistryHelper(Registry registry) {
        this.registry = registry;
    }

    public Set<Class<?>> getTypesAnnotatedWith(Class<? extends Annotation> annotation, boolean findInheritors) {
        Set<String> annotated = this.registry.get(TypeAnnotationScanner.class).get(annotation.getName());
        if (annotated == null) {
            return Collections.emptySet();
        }
        HashSet<String> strings = new HashSet<String>(annotated);
        if (findInheritors && annotation.isAnnotationPresent(Inherited.class)) {
            HashSet<String> moreStrings = new HashSet<String>();
            this.findSubtypes(strings, moreStrings);
            strings.addAll(moreStrings);
        }
        return this.convertToClassSet(strings);
    }

    private <T> Set<Class<? extends T>> convertToClassSet(Set<String> strings) {
        HashSet clazzes = new HashSet();
        for (String string : strings) {
            clazzes.add(DescriptorHelper.fromTypeDescriptor(string));
        }
        return Collections.unmodifiableSet(clazzes);
    }

    public <T> Set<Class<? extends T>> getSubTypesOf(Class<T> clazz) {
        HashSet<String> strings = new HashSet<String>();
        this.findSubtypes(Collections.singleton(clazz.getName()), strings);
        return this.convertToClassSet(strings);
    }

    private void findSubtypes(Collection<String> superclazzes, Set<String> subclazzesCollector) {
        for (String superclazz : superclazzes) {
            Collection strings = this.registry.get(SubTypeScanner.class).get(superclazz);
            if (strings == null || strings.isEmpty()) continue;
            subclazzesCollector.addAll(strings);
            this.findSubtypes(strings, subclazzesCollector);
        }
    }

    public Set<Method> getMethodsAnnotatedWith(Class<? extends Annotation> annotation) {
        Collection strings = this.registry.get(MethodAnnotationScanner.class).get(annotation.getName());
        HashSet<Method> methods = new HashSet<Method>();
        if (strings != null) {
            for (String string : strings) {
                methods.add(DescriptorHelper.fromMethodDescriptor(string));
            }
        }
        return methods;
    }

    public Set<Field> getFieldsAnnotatedWith(Class<? extends Annotation> annotation) {
        Collection strings = this.registry.get(FieldAnnotationScanner.class).get(annotation.getName());
        HashSet<Field> fields = new HashSet<Field>();
        if (strings != null) {
            for (String string : strings) {
                fields.add(DescriptorHelper.fromFieldDescriptor(string));
            }
        }
        return fields;
    }
}

