/*
 * Decompiled with CFR 0.152.
 */
package com.github.drapostolos.typeparser;

import com.github.drapostolos.typeparser.SplitStrategy;
import com.github.drapostolos.typeparser.SplitStrategyHelper;
import com.github.drapostolos.typeparser.TypeParser;
import com.github.drapostolos.typeparser.TypeParserUtility;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;

public final class ParserHelper {
    private final Type targetType;
    private final TypeParser stringParser;
    private final SplitStrategy splitStrategy;
    private final SplitStrategy keyValueSplitStrategy;

    ParserHelper(TypeParser typeParser, Type targetType) {
        this.stringParser = typeParser;
        this.targetType = targetType;
        this.splitStrategy = typeParser.splitStrategy;
        this.keyValueSplitStrategy = typeParser.keyValueSplitStrategy;
    }

    public <T> T parse(String input, Class<T> targetType) {
        return this.stringParser.parse(input, targetType);
    }

    public Object parseType(String input, Type targetType) {
        return this.stringParser.parseType(input, targetType);
    }

    public List<String> split(String input) {
        if (input == null) {
            return Collections.emptyList();
        }
        try {
            return this.splitStrategy.split(input, new SplitStrategyHelper(this.targetType));
        }
        catch (Throwable t) {
            String message = "Exception thrown from SplitStrategy: %s [%s] with message:  %s. See underlying exception for more information.";
            message = String.format(message, this.splitStrategy, this.splitStrategy.getClass(), t.getMessage());
            throw new IllegalStateException(message, t);
        }
    }

    public List<String> splitKeyValue(String keyValue) {
        if (keyValue == null) {
            throw new NullPointerException(TypeParserUtility.makeNullArgumentErrorMsg("keyValue"));
        }
        try {
            return this.keyValueSplitStrategy.split(keyValue, new SplitStrategyHelper(this.targetType));
        }
        catch (Throwable t) {
            String message = "Exception thrown from SplitStrategy: %s [%s] with message:  %s. See underlying exception for more information.";
            message = String.format(message, this.keyValueSplitStrategy, this.keyValueSplitStrategy.getClass(), t.getMessage());
            throw new IllegalStateException(message, t);
        }
    }

    public Type getTargetType() {
        return this.targetType;
    }

    public <T> List<Class<T>> getParameterizedClassArguments() {
        return TypeParserUtility.getParameterizedTypeArguments(this.targetType);
    }

    public <T> Class<T> getParameterizedClassArgumentByIndex(int index) {
        if (index < 0) {
            String message = "Argument named 'index' is illegally set to negative value: %s. Must be positive.";
            throw new IllegalArgumentException(String.format(message, index));
        }
        List<Class<T>> list = this.getParameterizedClassArguments();
        if (index >= list.size()) {
            String message = "Argument named 'index' is illegally set to value: %s. List size is: %s.";
            throw new IllegalArgumentException(String.format(message, index, list.size()));
        }
        return list.get(index);
    }

    public <T> Class<T> getTargetClass() {
        if (this.targetType instanceof Class) {
            Class temp = (Class)this.targetType;
            return temp;
        }
        String message = "%s [%s] cannot be casted to java.lang.Class";
        message = String.format(message, this.targetType, this.targetType.getClass());
        throw new IllegalStateException(message);
    }
}

