/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.stitch.service.engine.processor.handler.expression.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import com.xebialabs.xlplatform.documentation.PublicApi;

/**
 * Annotation used in conjunction with AbstractContextResolver for annotating class as expressions utility bean.
 * Class should have constructor that accepts two parameters DeploymentContext and InputContext.
 * @see com.xebialabs.deployit.plugin.stitch.service.engine.processor.handler.expression.resolver.AbstractContextResolver
 * @see com.xebialabs.deployit.plugin.stitch.service.engine.context.DeploymentContext
 * @see com.xebialabs.deployit.plugin.stitch.service.engine.context.InputContext
 * Example:
 * <code>
 * @ExpressionUtility("environment")
 * public class EnvironmentUtility extends AbstractContextResolver {
 *  public EnvironmentUtility(final DeploymentContext deploymentContext, final InputContext inputContext) {
 *   super(deploymentContext, inputContext);
 *  }
 *
 *  public String getName() {
 *   return getDeploymentContext().getCurrentDeployedApplication().getEnvironment().getName();
 *  }
 * }
 * </code>
 */
@PublicApi
@Target({ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
public @interface ExpressionUtility {
    /**
     * Name under which bean is registered inside evaluation context.
     * @return bean name
     */
    String value();
}
