/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlplatform.cluster;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.cluster.Cluster;
import akka.cluster.Cluster$;
import com.xebialabs.xlplatform.cluster.ClusterConfig;
import com.xebialabs.xlplatform.cluster.ClusterMode;
import com.xebialabs.xlplatform.cluster.ClusterMode$Full$;
import com.xebialabs.xlplatform.cluster.ClusterMode$HotStandby$;
import com.xebialabs.xlplatform.cluster.full.FullClusterNodeStateManager$;
import com.xebialabs.xlplatform.cluster.hotstandby.HotStandbyClusterNodeStateManager$;
import com.xebialabs.xlplatform.cluster.membership.ClusterDiscoveryActor;
import com.xebialabs.xlplatform.cluster.membership.ClusterDiscoveryActor$;
import com.xebialabs.xlplatform.cluster.membership.storage.ClusterMembershipManagement$;
import com.xebialabs.xlplatform.cluster.membership.storage.ClusterMembershipSQLManagement;
import scala.Function0;
import scala.concurrent.ExecutionContextExecutor;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005q3A!\u0004\b\u0001/!Aa\u0005\u0001B\u0001B\u0003%q\u0005\u0003\u0005+\u0001\t\u0005\t\u0015!\u0003,\u0011\u0015y\u0003\u0001\"\u00011\u0011\u001d!\u0004A1A\u0005\fUBaA\u000e\u0001!\u0002\u00139\u0003bB\u001c\u0001\u0005\u0004%Y\u0001\u000f\u0005\u0007\u007f\u0001\u0001\u000b\u0011B\u001d\t\u000f=\u0001!\u0019!C\u0005\u0001\"1a\t\u0001Q\u0001\n\u0005Cqa\u0012\u0001C\u0002\u0013\u0005\u0001\n\u0003\u0004R\u0001\u0001\u0006I!\u0013\u0005\u0006%\u0002!\ta\u0015\u0002\u001212\u001cE.^:uKJ\u0004&o\u001c<jI\u0016\u0014(BA\b\u0011\u0003\u001d\u0019G.^:uKJT!!\u0005\n\u0002\u0015ad\u0007\u000f\\1uM>\u0014XN\u0003\u0002\u0014)\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002+\u0005\u00191m\\7\u0004\u0001M\u0019\u0001\u0001\u0007\u0010\u0011\u0005eaR\"\u0001\u000e\u000b\u0003m\tQa]2bY\u0006L!!\b\u000e\u0003\r\u0005s\u0017PU3g!\tyB%D\u0001!\u0015\t\t#%A\u0003bGR|'OC\u0001$\u0003\u0011\t7n[1\n\u0005\u0015\u0002#!C#yi\u0016t7/[8o\u00039)\u0007\u0010^3oI\u0016$7+_:uK6\u0004\"a\b\u0015\n\u0005%\u0002#aE#yi\u0016tG-\u001a3BGR|'oU=ti\u0016l\u0017AB2p]\u001aLw\r\u0005\u0002-[5\ta\"\u0003\u0002/\u001d\ti1\t\\;ti\u0016\u00148i\u001c8gS\u001e\fa\u0001P5oSRtDcA\u00193gA\u0011A\u0006\u0001\u0005\u0006M\r\u0001\ra\n\u0005\u0006U\r\u0001\raK\u0001\u0007gf\u001cH/Z7\u0016\u0003\u001d\nqa]=ti\u0016l\u0007%\u0001\tfq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yiV\t\u0011\b\u0005\u0002;{5\t1H\u0003\u0002=5\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005yZ$\u0001G#yK\u000e,H/[8o\u0007>tG/\u001a=u\u000bb,7-\u001e;pe\u0006\tR\r_3dkRLwN\\\"p]R,\u0007\u0010\u001e\u0011\u0016\u0003\u0005\u0003\"A\u0011#\u000e\u0003\rS!a\u0004\u0012\n\u0005\u0015\u001b%aB\"mkN$XM]\u0001\tG2,8\u000f^3sA\u0005!R.Z7cKJ\u001c\b.\u001b9NC:\fw-Z7f]R,\u0012!\u0013\t\u0003\u0015>k\u0011a\u0013\u0006\u0003\u00196\u000bqa\u001d;pe\u0006<WM\u0003\u0002O\u001d\u0005QQ.Z7cKJ\u001c\b.\u001b9\n\u0005A[%AH\"mkN$XM]'f[\n,'o\u001d5jaN\u000bF*T1oC\u001e,W.\u001a8u\u0003UiW-\u001c2feND\u0017\u000e]'b]\u0006<W-\\3oi\u0002\nQa\u001d;beR$\"\u0001V,\u0011\u0005e)\u0016B\u0001,\u001b\u0005\u0011)f.\u001b;\t\u000bac\u0001\u0019A-\u0002\u0015%t\u0017\u000e^5bY&TX\rE\u0002\u001a5RK!a\u0017\u000e\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004")
public class XlClusterProvider
implements Extension {
    private final ClusterConfig config;
    private final ExtendedActorSystem system;
    private final ExecutionContextExecutor executionContext;
    private final Cluster cluster;
    private final ClusterMembershipSQLManagement membershipManagement;

    private ExtendedActorSystem system() {
        return this.system;
    }

    private ExecutionContextExecutor executionContext() {
        return this.executionContext;
    }

    private Cluster cluster() {
        return this.cluster;
    }

    public ClusterMembershipSQLManagement membershipManagement() {
        return this.membershipManagement;
    }

    public void start(Function0<BoxedUnit> initialize) {
        ActorRef actorRef;
        ClusterMode clusterMode = this.config.mode();
        if (ClusterMode$Full$.MODULE$.equals(clusterMode)) {
            actorRef = this.system().actorOf(FullClusterNodeStateManager$.MODULE$.stateManager(initialize));
        } else if (ClusterMode$HotStandby$.MODULE$.equals(clusterMode)) {
            actorRef = this.system().actorOf(HotStandbyClusterNodeStateManager$.MODULE$.stateManager(initialize));
        } else {
            throw new IllegalArgumentException("This extension is only valid with cluster usage.");
        }
        ActorRef clusterStateManagerActor = actorRef;
        ActorRef discoveryActor = this.system().actorOf(ClusterDiscoveryActor$.MODULE$.props(this.cluster(), this.membershipManagement(), this.config.membership().heartbeatInterval()));
        ClusterDiscoveryActor.Start x$1 = new ClusterDiscoveryActor.Start(clusterStateManagerActor);
        ActorRef x$2 = discoveryActor.$bang$default$2((Object)x$1);
        discoveryActor.$bang((Object)x$1, x$2);
    }

    public XlClusterProvider(ExtendedActorSystem extendedSystem, ClusterConfig config) {
        this.config = config;
        this.system = extendedSystem;
        this.executionContext = extendedSystem.dispatcher();
        this.cluster = (Cluster)Cluster$.MODULE$.apply((ActorSystem)this.system());
        this.membershipManagement = ClusterMembershipManagement$.MODULE$.selectDialect(config.membership().datasource(), config.membership().ttl(), ClusterMembershipManagement$.MODULE$.selectDialect$default$3());
    }
}

