/*
 * Decompiled with CFR 0.152.
 */
package liquibase.snapshot.jvm;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.Scope;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.Database;
import liquibase.database.OfflineConnection;
import liquibase.database.core.AbstractDb2Database;
import liquibase.database.core.FirebirdDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.database.core.SybaseASADatabase;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.logging.Logger;
import liquibase.snapshot.CachedRow;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.JdbcDatabaseSnapshot;
import liquibase.snapshot.jvm.JdbcSnapshotGenerator;
import liquibase.statement.DatabaseFunction;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.DataType;
import liquibase.structure.core.Relation;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;
import liquibase.structure.core.View;
import liquibase.util.BooleanUtils;
import liquibase.util.SqlUtil;
import liquibase.util.StringUtil;

public class ColumnSnapshotGenerator
extends JdbcSnapshotGenerator {
    private static final String LIQUIBASE_COMPLETE = "liquibase-complete";
    protected static final String COLUMN_DEF_COL = "COLUMN_DEF";
    private Pattern postgresStringValuePattern = Pattern.compile("'(.*)'::[\\w .]+");
    private Pattern postgresNumberValuePattern = Pattern.compile("(\\d*)::[\\w .]+");

    public ColumnSnapshotGenerator() {
        super(Column.class, new Class[]{Table.class, View.class});
    }

    @Override
    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException {
        if (BooleanUtils.isTrue(((Column)example).getComputed()) || BooleanUtils.isTrue(((Column)example).getDescending())) {
            return example;
        }
        Database database = snapshot.getDatabase();
        Relation relation = ((Column)example).getRelation();
        Schema schema = relation.getSchema();
        try {
            Column column = null;
            if (example.getAttribute(LIQUIBASE_COMPLETE, false).booleanValue()) {
                column = (Column)example;
                example.setAttribute(LIQUIBASE_COMPLETE, null);
                return column;
            }
            String catalogName = ((AbstractJdbcDatabase)database).getJdbcCatalogName(schema);
            String schemaName = ((AbstractJdbcDatabase)database).getJdbcSchemaName(schema);
            String tableName = relation.getName();
            String columnName = example.getName();
            JdbcDatabaseSnapshot.CachingDatabaseMetaData databaseMetaData = ((JdbcDatabaseSnapshot)snapshot).getMetaDataFromCache();
            List<CachedRow> metaDataColumns = databaseMetaData.getColumns(catalogName, schemaName, tableName, columnName);
            List<CachedRow> metaDataNotNullConst = databaseMetaData.getNotNullConst(catalogName, schemaName, tableName);
            if (!metaDataColumns.isEmpty()) {
                CachedRow data = metaDataColumns.get(0);
                column = this.readColumn(data, relation, database);
                this.setAutoIncrementDetails(column, database, snapshot);
                this.populateValidateNullableIfNeeded(column, metaDataNotNullConst, database);
            }
            example.setAttribute(LIQUIBASE_COMPLETE, null);
            if (column == null && database instanceof PostgresDatabase && this.looksLikeFunction(example.getName())) {
                ((Column)example).setComputed(true);
                return example;
            }
            return column;
        }
        catch (SQLException | DatabaseException e2) {
            throw new DatabaseException(e2);
        }
    }

    private void populateValidateNullableIfNeeded(Column column, List<CachedRow> metaDataNotNullConst, Database database) {
        if (!(database instanceof OracleDatabase)) {
            return;
        }
        String name = column.getName();
        for (CachedRow cachedRow : metaDataNotNullConst) {
            Object columnNameObj = cachedRow.get("COLUMN_NAME");
            if (columnNameObj == null) {
                throw new AssertionError((Object)"Please check query to fetch data for notNullConst!. I didn't fetch needed data");
            }
            if (!name.equalsIgnoreCase(columnNameObj.toString())) continue;
            String VALIDATE = "VALIDATED";
            Object validated = cachedRow.get("VALIDATED");
            if (validated == null) break;
            String searchCondition = cachedRow.getString("SEARCH_CONDITION");
            searchCondition = searchCondition == null ? "" : searchCondition.toUpperCase();
            String nullable = cachedRow.getString("NULLABLE");
            String constraintName = cachedRow.getString("CONSTRAINT_NAME");
            if ("NOT VALIDATED".equalsIgnoreCase(validated.toString()) && "Y".equalsIgnoreCase(nullable) && searchCondition.matches("\"?\\w+\" IS NOT NULL")) {
                column.setNullable(false);
                column.setValidateNullable(false);
            }
            if (!Boolean.FALSE.equals(column.isNullable()) || !ColumnSnapshotGenerator.hasValidObjectName(constraintName)) continue;
            column.setAttribute("notNullConstraintName", constraintName);
        }
    }

    private static boolean hasValidObjectName(String objectName) {
        if (StringUtil.isEmpty(objectName)) {
            return false;
        }
        return !objectName.startsWith("SYS_") && !objectName.startsWith("BIN$");
    }

    @Override
    protected void addTo(DatabaseObject foundObject, DatabaseSnapshot snapshot) throws DatabaseException {
        if (!snapshot.getSnapshotControl().shouldInclude(Column.class)) {
            return;
        }
        if (foundObject instanceof Relation) {
            Database database = snapshot.getDatabase();
            Relation relation = (Relation)foundObject;
            try {
                JdbcDatabaseSnapshot.CachingDatabaseMetaData databaseMetaData = ((JdbcDatabaseSnapshot)snapshot).getMetaDataFromCache();
                Schema schema = relation.getSchema();
                List<CachedRow> allColumnsMetadataRs = databaseMetaData.getColumns(((AbstractJdbcDatabase)database).getJdbcCatalogName(schema), ((AbstractJdbcDatabase)database).getJdbcSchemaName(schema), relation.getName(), null);
                List<CachedRow> metaDataNotNullConst = databaseMetaData.getNotNullConst(schema.getCatalogName(), schema.getName(), relation.getName());
                TreeMap<Integer, CachedRow> treeSet = new TreeMap<Integer, CachedRow>();
                for (CachedRow row : allColumnsMetadataRs) {
                    treeSet.put(row.getInt("ORDINAL_POSITION"), row);
                }
                Logger log = Scope.getCurrentScope().getLog(this.getClass());
                int currentOrdinal = 0;
                for (CachedRow row : treeSet.values()) {
                    int rsOrdinal = row.getInt("ORDINAL_POSITION");
                    if (rsOrdinal == ++currentOrdinal) continue;
                    log.fine(String.format("Repairing ORDINAL_POSITION with gaps for table=%s, column name=%s, bad ordinal=%d, new ordinal=%d", relation.getName(), row.getString("COLUMN_NAME"), rsOrdinal, currentOrdinal));
                    row.set("ORDINAL_POSITION", currentOrdinal);
                }
                for (CachedRow row : allColumnsMetadataRs) {
                    Column column = this.readColumn(row, relation, database);
                    this.setAutoIncrementDetails(column, database, snapshot);
                    this.populateValidateNullableIfNeeded(column, metaDataNotNullConst, database);
                    column.setAttribute(LIQUIBASE_COMPLETE, column.isNullable() == false);
                    relation.getColumns().add(column);
                }
            }
            catch (SQLException e2) {
                throw new DatabaseException(e2);
            }
        }
    }

    protected void setAutoIncrementDetails(Column column, Database database, DatabaseSnapshot snapshot) {
        if (column.getAutoIncrementInformation() != null && database instanceof MSSQLDatabase && database.getConnection() != null && !(database.getConnection() instanceof OfflineConnection)) {
            Column.AutoIncrementInformation autoIncrementInformation;
            HashMap<String, Column.AutoIncrementInformation> autoIncrementColumns = (HashMap<String, Column.AutoIncrementInformation>)snapshot.getScratchData("autoIncrementColumns");
            if (autoIncrementColumns == null) {
                autoIncrementColumns = new HashMap<String, Column.AutoIncrementInformation>();
                Executor executor = Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("jdbc", database);
                try {
                    List<Map<String, ?>> rows = executor.queryForList(new RawSqlStatement("SELECT object_schema_name(object_id) AS schema_name, object_name(object_id) AS table_name, name AS column_name, CAST(seed_value AS bigint) AS start_value, CAST(increment_value AS bigint) AS increment_by FROM sys.identity_columns"));
                    for (Map<String, ?> row : rows) {
                        String schemaName = (String)row.get("SCHEMA_NAME");
                        String tableName = (String)row.get("TABLE_NAME");
                        String columnName = (String)row.get("COLUMN_NAME");
                        Long startValue = (Long)row.get("START_VALUE");
                        Long incrementBy = (Long)row.get("INCREMENT_BY");
                        Column.AutoIncrementInformation info = new Column.AutoIncrementInformation(startValue, incrementBy);
                        autoIncrementColumns.put(schemaName + "." + tableName + "." + columnName, info);
                    }
                    snapshot.setScratchData("autoIncrementColumns", autoIncrementColumns);
                }
                catch (DatabaseException e2) {
                    Scope.getCurrentScope().getLog(this.getClass()).info("Could not read identity information", e2);
                }
            }
            if (column.getRelation() != null && column.getSchema() != null && (autoIncrementInformation = (Column.AutoIncrementInformation)autoIncrementColumns.get(column.getSchema().getName() + "." + column.getRelation().getName() + "." + column.getName())) != null) {
                column.setAutoIncrementInformation(autoIncrementInformation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Column readColumn(CachedRow columnMetadataResultSet, Relation table, Database database) throws SQLException, DatabaseException {
        Object nullable;
        String rawTableName = (String)columnMetadataResultSet.get("TABLE_NAME");
        String rawColumnName = (String)columnMetadataResultSet.get("COLUMN_NAME");
        String rawSchemaName = StringUtil.trimToNull((String)columnMetadataResultSet.get("TABLE_SCHEM"));
        String rawCatalogName = StringUtil.trimToNull((String)columnMetadataResultSet.get("TABLE_CAT"));
        String remarks = StringUtil.trimToNull((String)columnMetadataResultSet.get("REMARKS"));
        if (remarks != null) {
            remarks = remarks.replace("''", "'");
        }
        Integer position = columnMetadataResultSet.getInt("ORDINAL_POSITION");
        Column column = new Column();
        column.setName(StringUtil.trimToNull(rawColumnName));
        column.setRelation(table);
        column.setRemarks(remarks);
        column.setOrder(position);
        Boolean isComputed = columnMetadataResultSet.getBoolean("IS_COMPUTED");
        if (isComputed != null) {
            column.setComputed(isComputed);
        }
        if (columnMetadataResultSet.get("IS_FILESTREAM") != null && ((Boolean)columnMetadataResultSet.get("IS_FILESTREAM")).booleanValue()) {
            column.setAttribute("fileStream", true);
        }
        if (columnMetadataResultSet.get("IS_ROWGUIDCOL") != null && ((Boolean)columnMetadataResultSet.get("IS_ROWGUIDCOL")).booleanValue()) {
            column.setAttribute("rowGuid", true);
        }
        if (database instanceof OracleDatabase) {
            nullable = columnMetadataResultSet.getString("NULLABLE");
            if ("Y".equals(nullable)) {
                column.setNullable(true);
            } else {
                column.setNullable(false);
            }
        } else {
            nullable = columnMetadataResultSet.getInt("NULLABLE");
            if (nullable != null) {
                if ((Integer)nullable == 0) {
                    column.setNullable(false);
                } else if ((Integer)nullable == 1) {
                    column.setNullable(true);
                } else if ((Integer)nullable == 2) {
                    Scope.getCurrentScope().getLog(this.getClass()).info("Unknown nullable state for column " + column.toString() + ". Assuming nullable");
                    column.setNullable(true);
                }
            }
        }
        if (database.supportsAutoIncrement() && table instanceof Table) {
            if (database instanceof OracleDatabase) {
                Boolean isIdentityColumn;
                Column.AutoIncrementInformation autoIncrementInfo = new Column.AutoIncrementInformation();
                String data_default = StringUtil.trimToEmpty((String)columnMetadataResultSet.get("DATA_DEFAULT")).toLowerCase();
                if (data_default.contains("iseq$$") && data_default.endsWith("nextval")) {
                    column.setAutoIncrementInformation(autoIncrementInfo);
                }
                if (Boolean.TRUE.equals(isIdentityColumn = columnMetadataResultSet.yesNoToBoolean("IDENTITY_COLUMN"))) {
                    Boolean defaultOnNull = columnMetadataResultSet.yesNoToBoolean("DEFAULT_ON_NULL");
                    String generationType = columnMetadataResultSet.getString("GENERATION_TYPE");
                    autoIncrementInfo.setDefaultOnNull(defaultOnNull);
                    autoIncrementInfo.setGenerationType(generationType);
                    column.setAutoIncrementInformation(autoIncrementInfo);
                }
            } else if (columnMetadataResultSet.containsColumn("IS_AUTOINCREMENT")) {
                String isAutoincrement = (String)columnMetadataResultSet.get("IS_AUTOINCREMENT");
                if ((isAutoincrement = StringUtil.trimToNull(isAutoincrement)) == null) {
                    column.setAutoIncrementInformation(null);
                } else if (isAutoincrement.equals("YES")) {
                    column.setAutoIncrementInformation(new Column.AutoIncrementInformation());
                } else if (isAutoincrement.equals("NO")) {
                    column.setAutoIncrementInformation(null);
                } else {
                    if (!isAutoincrement.equals("")) throw new UnexpectedLiquibaseException("Unknown is_autoincrement value: '" + isAutoincrement + "'");
                    Scope.getCurrentScope().getLog(this.getClass()).info("Unknown auto increment state for column " + column.toString() + ". Assuming not auto increment");
                    column.setAutoIncrementInformation(null);
                }
            } else {
                String selectStatement;
                if (database.getDatabaseProductName().startsWith("DB2 UDB for AS/400")) {
                    selectStatement = "select " + database.escapeColumnName(rawCatalogName, rawSchemaName, rawTableName, rawColumnName) + " from " + rawSchemaName + "." + rawTableName + " where 0=1";
                    Scope.getCurrentScope().getLog(this.getClass()).fine("rawCatalogName : <" + rawCatalogName + ">");
                    Scope.getCurrentScope().getLog(this.getClass()).fine("rawSchemaName : <" + rawSchemaName + ">");
                    Scope.getCurrentScope().getLog(this.getClass()).fine("rawTableName : <" + rawTableName + ">");
                    Scope.getCurrentScope().getLog(this.getClass()).fine("raw selectStatement : <" + selectStatement + ">");
                } else {
                    selectStatement = "select " + database.escapeColumnName(rawCatalogName, rawSchemaName, rawTableName, rawColumnName) + " from " + database.escapeTableName(rawCatalogName, rawSchemaName, rawTableName) + " where 0=1";
                }
                Scope.getCurrentScope().getLog(this.getClass()).fine("Checking " + rawTableName + "." + rawCatalogName + " for auto-increment with SQL: '" + selectStatement + "'");
                Connection underlyingConnection = ((JdbcConnection)database.getConnection()).getUnderlyingConnection();
                Statement statement = null;
                ResultSet columnSelectRS = null;
                try {
                    statement = underlyingConnection.createStatement();
                    columnSelectRS = statement.executeQuery(selectStatement);
                    if (columnSelectRS.getMetaData().isAutoIncrement(1)) {
                        column.setAutoIncrementInformation(new Column.AutoIncrementInformation());
                    } else {
                        column.setAutoIncrementInformation(null);
                    }
                }
                finally {
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                    catch (SQLException sQLException) {}
                    if (columnSelectRS != null) {
                        columnSelectRS.close();
                    }
                }
            }
        }
        DataType type = this.readDataType(columnMetadataResultSet, column, database);
        column.setType(type);
        Object defaultValue = this.readDefaultValue(columnMetadataResultSet, column, database);
        if (defaultValue != null && defaultValue instanceof DatabaseFunction && ((DatabaseFunction)defaultValue).getValue().matches("\\w+")) {
            defaultValue = new DatabaseFunction(((DatabaseFunction)defaultValue).getValue().toUpperCase());
        }
        column.setDefaultValue(defaultValue);
        column.setDefaultValueConstraintName(columnMetadataResultSet.getString("COLUMN_DEF_NAME"));
        return column;
    }

    protected DataType readDataType(CachedRow columnMetadataResultSet, Column column, Database database) throws DatabaseException {
        if (database instanceof OracleDatabase) {
            String dataType = columnMetadataResultSet.getString("DATA_TYPE_NAME");
            dataType = dataType.replace("VARCHAR2", "VARCHAR");
            dataType = dataType.replace("NVARCHAR2", "NVARCHAR");
            DataType type = new DataType(dataType);
            type.setDataTypeId(columnMetadataResultSet.getInt("DATA_TYPE"));
            if (dataType.equalsIgnoreCase("NUMBER")) {
                type.setColumnSize(columnMetadataResultSet.getInt("DATA_PRECISION"));
                type.setDecimalDigits(columnMetadataResultSet.getInt("DATA_SCALE"));
            } else {
                if ("FLOAT".equalsIgnoreCase(dataType)) {
                    type.setColumnSize(columnMetadataResultSet.getInt("DATA_PRECISION"));
                } else {
                    type.setColumnSize(columnMetadataResultSet.getInt("DATA_LENGTH"));
                }
                boolean isTimeStampDataType = dataType.toUpperCase().contains("TIMESTAMP");
                if (isTimeStampDataType || dataType.equalsIgnoreCase("NCLOB") || dataType.equalsIgnoreCase("BLOB") || dataType.equalsIgnoreCase("CLOB")) {
                    type.setColumnSize(null);
                } else if (dataType.equalsIgnoreCase("NVARCHAR") || dataType.equalsIgnoreCase("NCHAR")) {
                    type.setColumnSize(columnMetadataResultSet.getInt("CHAR_LENGTH"));
                    type.setColumnSizeUnit(DataType.ColumnSizeUnit.CHAR);
                } else {
                    String charUsed = columnMetadataResultSet.getString("CHAR_USED");
                    DataType.ColumnSizeUnit unit = null;
                    if ("C".equals(charUsed)) {
                        unit = DataType.ColumnSizeUnit.CHAR;
                        type.setColumnSize(columnMetadataResultSet.getInt("CHAR_LENGTH"));
                    } else if ("B".equals(charUsed)) {
                        unit = DataType.ColumnSizeUnit.BYTE;
                    }
                    type.setColumnSizeUnit(unit);
                }
            }
            return type;
        }
        String columnTypeName = (String)columnMetadataResultSet.get("TYPE_NAME");
        if (database instanceof MSSQLDatabase) {
            if ("numeric() identity".equalsIgnoreCase(columnTypeName)) {
                columnTypeName = "numeric";
            } else if ("decimal() identity".equalsIgnoreCase(columnTypeName)) {
                columnTypeName = "decimal";
            } else if ("xml".equalsIgnoreCase(columnTypeName)) {
                columnMetadataResultSet.set("COLUMN_SIZE", null);
                columnMetadataResultSet.set("DECIMAL_DIGITS", null);
            } else if ("datetimeoffset".equalsIgnoreCase(columnTypeName) || "time".equalsIgnoreCase(columnTypeName)) {
                columnMetadataResultSet.set("COLUMN_SIZE", columnMetadataResultSet.getInt("DECIMAL_DIGITS"));
                columnMetadataResultSet.set("DECIMAL_DIGITS", null);
            }
        } else if (database instanceof PostgresDatabase && (columnTypeName = database.unescapeDataTypeName(columnTypeName)).startsWith("_")) {
            columnTypeName = columnTypeName.replaceFirst("_", "").concat("[]");
        }
        if (database instanceof FirebirdDatabase) {
            if ("BLOB SUB_TYPE 0".equals(columnTypeName)) {
                columnTypeName = "BLOB";
            }
            if ("BLOB SUB_TYPE 1".equals(columnTypeName)) {
                columnTypeName = "CLOB";
            }
        }
        if (database instanceof MySQLDatabase && ("ENUM".equalsIgnoreCase(columnTypeName) || "SET".equalsIgnoreCase(columnTypeName))) {
            try {
                String boilerLength = "ENUM".equalsIgnoreCase(columnTypeName) ? "7" : "6";
                List enumValues = Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("jdbc", database).queryForList((SqlStatement)new RawSqlStatement("SELECT DISTINCT SUBSTRING_INDEX(SUBSTRING_INDEX(SUBSTRING(COLUMN_TYPE, " + boilerLength + ", LENGTH(COLUMN_TYPE) - " + boilerLength + " - 1 ), \"','\", 1 + units.i + tens.i * 10) , \"','\", -1)\nFROM INFORMATION_SCHEMA.COLUMNS\nCROSS JOIN (SELECT 0 AS i UNION SELECT 1 UNION SELECT 2 UNION SELECT 3 UNION SELECT 4 UNION SELECT 5 UNION SELECT 6 UNION SELECT 7 UNION SELECT 8 UNION SELECT 9) units\nCROSS JOIN (SELECT 0 AS i UNION SELECT 1 UNION SELECT 2 UNION SELECT 3 UNION SELECT 4 UNION SELECT 5 UNION SELECT 6 UNION SELECT 7 UNION SELECT 8 UNION SELECT 9) tens\nWHERE TABLE_NAME = '" + column.getRelation().getName() + "' \nAND COLUMN_NAME = '" + column.getName() + "'"), String.class);
                String enumClause = "";
                for (String enumValue : enumValues) {
                    enumClause = enumClause + "'" + enumValue + "', ";
                }
                enumClause = enumClause.replaceFirst(", $", "");
                return new DataType(columnTypeName + "(" + enumClause + ")");
            }
            catch (DatabaseException e2) {
                Scope.getCurrentScope().getLog(this.getClass()).warning("Error fetching enum values", e2);
            }
        }
        DataType.ColumnSizeUnit columnSizeUnit = DataType.ColumnSizeUnit.BYTE;
        int dataType = columnMetadataResultSet.getInt("DATA_TYPE");
        Integer columnSize = null;
        Integer decimalDigits = null;
        if (!database.dataTypeIsNotModifiable(columnTypeName)) {
            columnSize = columnMetadataResultSet.getInt("COLUMN_SIZE");
            decimalDigits = columnMetadataResultSet.getInt("DECIMAL_DIGITS");
            if (decimalDigits != null && decimalDigits.equals(0)) {
                decimalDigits = null;
            }
        }
        Integer radix = columnMetadataResultSet.getInt("NUM_PREC_RADIX");
        Integer characterOctetLength = columnMetadataResultSet.getInt("CHAR_OCTET_LENGTH");
        if (database instanceof AbstractDb2Database) {
            String typeName = columnMetadataResultSet.getString("TYPE_NAME");
            if (("DBCLOB".equalsIgnoreCase(typeName) || "GRAPHIC".equalsIgnoreCase(typeName) || "VARGRAPHIC".equalsIgnoreCase(typeName)) && columnSize != null) {
                columnSize = columnSize / 2;
            }
            if ("TIMESTAMP".equalsIgnoreCase(columnTypeName) && decimalDigits == null) {
                columnTypeName = "DATE";
                dataType = 91;
            }
        }
        if (database instanceof PostgresDatabase && columnSize != null && columnSize.equals(Integer.MAX_VALUE)) {
            columnSize = null;
        }
        if (database instanceof SybaseASADatabase && ("LONG BINARY".equalsIgnoreCase(columnTypeName) || "LONG VARCHAR".equalsIgnoreCase(columnTypeName))) {
            columnSize = null;
        }
        DataType type = new DataType(columnTypeName);
        type.setDataTypeId(dataType);
        int jdbcType = columnMetadataResultSet.getInt("DATA_TYPE");
        if (jdbcType == 93) {
            if (decimalDigits == null) {
                type.setColumnSize(null);
            } else {
                type.setColumnSize(decimalDigits.intValue() != database.getDefaultFractionalDigitsForTimestamp() ? decimalDigits : null);
            }
            type.setDecimalDigits(null);
        } else {
            type.setColumnSize(columnSize);
            type.setDecimalDigits(decimalDigits);
        }
        type.setRadix(radix);
        type.setCharacterOctetLength(characterOctetLength);
        type.setColumnSizeUnit(columnSizeUnit);
        return type;
    }

    protected Object readDefaultValue(CachedRow columnMetadataResultSet, Column columnInfo, Database database) {
        Object defaultValue;
        if (database instanceof MSSQLDatabase && (defaultValue = columnMetadataResultSet.get(COLUMN_DEF_COL)) != null && defaultValue instanceof String && "(NULL)".equals(defaultValue)) {
            columnMetadataResultSet.set(COLUMN_DEF_COL, new DatabaseFunction("null"));
        }
        if (database instanceof OracleDatabase && columnMetadataResultSet.get(COLUMN_DEF_COL) == null) {
            String lowerCaseDefaultValue;
            Object defaultValue2;
            Object virtColumnDef;
            columnMetadataResultSet.set(COLUMN_DEF_COL, columnMetadataResultSet.get("DATA_DEFAULT"));
            if (columnMetadataResultSet.get(COLUMN_DEF_COL) != null && "NULL".equalsIgnoreCase((String)columnMetadataResultSet.get(COLUMN_DEF_COL))) {
                columnMetadataResultSet.set(COLUMN_DEF_COL, null);
            }
            Object columnDef = columnMetadataResultSet.get(COLUMN_DEF_COL);
            if ("CHAR".equalsIgnoreCase(columnInfo.getType().getTypeName()) && columnDef instanceof String && !((String)columnDef).startsWith("'") && !((String)columnDef).endsWith("'")) {
                return new DatabaseFunction((String)columnDef);
            }
            if ("YES".equals(columnMetadataResultSet.get("VIRTUAL_COLUMN")) && (virtColumnDef = columnMetadataResultSet.get(COLUMN_DEF_COL)) != null && !"null".equals(virtColumnDef)) {
                columnMetadataResultSet.set(COLUMN_DEF_COL, "GENERATED ALWAYS AS (" + virtColumnDef + ")");
            }
            if ((defaultValue2 = columnMetadataResultSet.get(COLUMN_DEF_COL)) != null && defaultValue2 instanceof String && (lowerCaseDefaultValue = ((String)defaultValue2).toLowerCase()).contains("iseq$$") && lowerCaseDefaultValue.endsWith(".nextval")) {
                columnMetadataResultSet.set(COLUMN_DEF_COL, null);
            }
        }
        if (database instanceof PostgresDatabase && (defaultValue = columnMetadataResultSet.get(COLUMN_DEF_COL)) != null && defaultValue instanceof String) {
            Matcher matcher = this.postgresStringValuePattern.matcher((String)defaultValue);
            if (matcher.matches()) {
                defaultValue = matcher.group(1);
            } else {
                matcher = this.postgresNumberValuePattern.matcher((String)defaultValue);
                if (matcher.matches()) {
                    defaultValue = matcher.group(1);
                }
            }
            columnMetadataResultSet.set(COLUMN_DEF_COL, defaultValue);
        }
        if (database instanceof AbstractDb2Database && columnMetadataResultSet.get(COLUMN_DEF_COL) != null && "NULL".equalsIgnoreCase((String)columnMetadataResultSet.get(COLUMN_DEF_COL))) {
            columnMetadataResultSet.set(COLUMN_DEF_COL, null);
        }
        return SqlUtil.parseValue(database, columnMetadataResultSet.get(COLUMN_DEF_COL), columnInfo.getType());
    }

    private boolean looksLikeFunction(String columnName) {
        return columnName.contains("(");
    }
}

