/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltype.serialization.json;

import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.deployit.plugin.api.deployment.ResolvedPlaceholder;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import com.xebialabs.xltype.serialization.json.CiJsonReader;
import com.xebialabs.xltype.serialization.json.CiJsonWriter;
import com.xebialabs.xltype.serialization.json.CiListJsonReader;
import com.xebialabs.xltype.serialization.json.Converters;
import com.xebialabs.xltype.serialization.json.JsonWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class DeploymentJsonConverter {
    private final ConfigurationItemConverter ciConverter;

    public DeploymentJsonConverter(ConfigurationItemConverter converter) {
        this.ciConverter = converter;
    }

    public ConfigurationItemConverter getCiConverter() {
        return this.ciConverter;
    }

    public String toJson(Deployment deployment) {
        JsonWriter writer = new JsonWriter();
        this.toJson(deployment, writer);
        return writer.toString();
    }

    public void toJson(Deployment deployment, JsonWriter writer) {
        CiJsonWriter ciWriter = new CiJsonWriter(writer);
        writer.object();
        if (deployment.getId() != null) {
            writer.key("id").value(deployment.getId());
        }
        writer.key("type").value(deployment.getDeploymentType());
        writer.key("deploymentGroupIndex").value(deployment.getDeploymentGroupIndex());
        writer.key("application");
        this.ciConverter.writeCi(deployment.getDeployedApplication(), ciWriter);
        writer.key("deployeds");
        this.ciConverter.writeCis(deployment.getDeployeds(), ciWriter);
        writer.key("deployables");
        ciWriter.typedCiReferences(deployment.getDeployables());
        writer.key("containers");
        ciWriter.typedCiReferences(deployment.getContainers());
        writer.key("requiredDeployments");
        ciWriter.startList();
        deployment.getRequiredDeployments().forEach(requiredDeployment -> this.toJson((Deployment)requiredDeployment, writer));
        ciWriter.endList();
        this.toJson(deployment.getResolvedPlaceholders(), writer);
        writer.endObject();
    }

    private List<Deployment> toDeployments(JSONArray jsonArray) throws JSONException {
        ArrayList<Deployment> deployments = new ArrayList<Deployment>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            deployments.add(this.toDeployment(jsonArray.getJSONObject(i)));
        }
        return deployments;
    }

    private Set<ResolvedPlaceholder> toResolvedPlaceholders(JSONArray jsonArray) throws JSONException {
        HashSet<ResolvedPlaceholder> placeholders = new HashSet<ResolvedPlaceholder>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            placeholders.add(this.toResolvedPlaceholder(jsonArray.getJSONObject(i)));
        }
        return placeholders;
    }

    public void toJson(Set<ResolvedPlaceholder> resolvedPlaceholders, JsonWriter json) {
        json.key("resolvedPlaceholders");
        json.array();
        for (ResolvedPlaceholder resolvedPlaceholder : resolvedPlaceholders) {
            json.object();
            json.key("encrypted").value(resolvedPlaceholder.isEncrypted());
            json.key("containerId").value(resolvedPlaceholder.containerId());
            json.key("containerDeleted").value(resolvedPlaceholder.containerDeleted());
            json.key("deployedAppId").value(resolvedPlaceholder.deployedAppId());
            json.key("dictionaryId").value(resolvedPlaceholder.dictionaryId());
            json.key("dictionaryDeleted").value(resolvedPlaceholder.dictionaryDeleted());
            json.key("environmentId").value(resolvedPlaceholder.environmentId());
            json.key("environmentDeleted").value(resolvedPlaceholder.environmentDeleted());
            json.key("versionId").value(resolvedPlaceholder.versionId());
            json.key("key").value(resolvedPlaceholder.key());
            json.key("value").value(resolvedPlaceholder.value());
            json.endObject();
        }
        json.endArray();
    }

    public Deployment toDeployment(String jsonString) {
        try {
            JSONObject json = new JSONObject(jsonString);
            return this.toDeployment(json);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Can't parse JSON:\n" + jsonString, e);
        }
    }

    public ResolvedPlaceholder toResolvedPlaceholder(JSONObject jsonObject) throws JSONException {
        return new ResolvedPlaceholder(jsonObject.getBoolean("encrypted"), jsonObject.getString("key"), jsonObject.getString("value"), jsonObject.getString("containerId"), jsonObject.getBoolean("containerDeleted"), jsonObject.getString("deployedAppId"), jsonObject.getString("dictionaryId"), jsonObject.getBoolean("dictionaryDeleted"), jsonObject.getString("environmentId"), jsonObject.getBoolean("environmentDeleted"), jsonObject.getString("versionId"));
    }

    public Deployment toDeployment(JSONObject json) throws JSONException {
        String jsonString = json.toString();
        Converters.checkArgument(json.has("type"), "Missing 'type' property in JSON:\n%s", jsonString);
        Converters.checkArgument(json.has("application"), "Missing 'application' property in JSON:\n%s", jsonString);
        Converters.checkArgument(json.has("deployeds"), "Missing 'deployeds' property in JSON:\n%s", jsonString);
        Deployment deployment = new Deployment();
        if (json.has("id")) {
            deployment.setId(json.getString("id"));
        }
        Deployment.DeploymentType type = Deployment.DeploymentType.valueOf((String)json.getString("type"));
        deployment.setDeploymentType(type);
        if (!json.getString("deploymentGroupIndex").isEmpty()) {
            deployment.setDeploymentGroupIndex(Integer.parseInt(json.getString("deploymentGroupIndex")));
        }
        ConfigurationItem application = this.ciConverter.readCi(new CiJsonReader(json.getJSONObject("application")));
        deployment.setDeployedApplication(application);
        List<ConfigurationItem> deployeds = this.ciConverter.readCis(new CiListJsonReader(json.getJSONArray("deployeds")));
        deployment.setDeployeds(deployeds);
        deployment.setDeployables(DeploymentJsonConverter.toConfigurationItemIds(json.getJSONArray("deployables")));
        deployment.setContainers(DeploymentJsonConverter.toConfigurationItemIds(json.getJSONArray("containers")));
        deployment.setRequiredDeployments(this.toDeployments(json.getJSONArray("requiredDeployments")));
        if (json.has("resolvedPlaceholders")) {
            deployment.addResolvedPlaceholders(this.toResolvedPlaceholders(json.getJSONArray("resolvedPlaceholders")));
        }
        return deployment;
    }

    private static List<ConfigurationItemId> toConfigurationItemIds(JSONArray jsonArray) throws JSONException {
        ArrayList<ConfigurationItemId> ids = new ArrayList<ConfigurationItemId>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            ids.add(DeploymentJsonConverter.toConfigurationItemId(jsonArray.getJSONObject(i)));
        }
        return ids;
    }

    private static ConfigurationItemId toConfigurationItemId(JSONObject jsonObject) throws JSONException {
        return new ConfigurationItemId(jsonObject.getString("ci"), Type.valueOf((String)jsonObject.getString("type")));
    }
}

