/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.transport;

import java.io.IOException;
import java.util.Vector;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.transport.AbstractTransportMapping;
import org.snmp4j.transport.ConnectionOrientedTransportMapping;
import org.snmp4j.transport.MessageLengthDecoder;
import org.snmp4j.transport.TransportStateEvent;
import org.snmp4j.transport.TransportStateListener;

public abstract class TcpTransportMapping
extends AbstractTransportMapping
implements ConnectionOrientedTransportMapping {
    private static final LogAdapter logger = LogFactory.getLogger(TcpTransportMapping.class);
    protected TcpAddress tcpAddress;
    private transient Vector transportStateListeners;

    public TcpTransportMapping(TcpAddress tcpAddress) {
        this.tcpAddress = tcpAddress;
    }

    public Class getSupportedAddressClass() {
        return TcpAddress.class;
    }

    public TcpAddress getAddress() {
        return this.tcpAddress;
    }

    public Address getListenAddress() {
        return this.tcpAddress;
    }

    public abstract void sendMessage(Address var1, byte[] var2) throws IOException;

    public abstract void listen() throws IOException;

    public abstract void close() throws IOException;

    public abstract MessageLengthDecoder getMessageLengthDecoder();

    public abstract void setMessageLengthDecoder(MessageLengthDecoder var1);

    public abstract void setConnectionTimeout(long var1);

    public synchronized void addTransportStateListener(TransportStateListener transportStateListener) {
        if (this.transportStateListeners == null) {
            this.transportStateListeners = new Vector(2);
        }
        this.transportStateListeners.add(transportStateListener);
    }

    public synchronized void removeTransportStateListener(TransportStateListener transportStateListener) {
        if (this.transportStateListeners != null) {
            this.transportStateListeners.remove(transportStateListener);
        }
    }

    protected void fireConnectionStateChanged(TransportStateEvent transportStateEvent) {
        if (logger.isDebugEnabled()) {
            logger.debug("Firing transport state event: " + transportStateEvent);
        }
        if (this.transportStateListeners != null) {
            Vector vector = this.transportStateListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((TransportStateListener)vector.get(i)).connectionStateChanged(transportStateEvent);
            }
        }
    }
}

