/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.io.File;
import java.util.concurrent.Semaphore;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActivateCallback;
import org.apache.activemq.artemis.core.server.impl.CleaningActivateCallback;
import org.apache.activemq.artemis.core.server.impl.FileBasedNodeManager;
import org.apache.activemq.artemis.utils.UUIDGenerator;

public final class InVMNodeManager
extends FileBasedNodeManager {
    private final Semaphore liveLock;
    private final Semaphore backupLock;
    public volatile State state = State.NOT_STARTED;
    public long failoverPause = 0L;

    public InVMNodeManager(boolean replicatedBackup) {
        this(replicatedBackup, null);
        if (replicatedBackup) {
            throw new RuntimeException("if replicated-backup, we need its journal directory");
        }
    }

    public InVMNodeManager(boolean replicatedBackup, File directory) {
        super(replicatedBackup, directory);
        this.liveLock = new Semaphore(1);
        this.backupLock = new Semaphore(1);
        this.setUUID(UUIDGenerator.getInstance().generateUUID());
    }

    @Override
    public void awaitLiveNode() throws InterruptedException {
        while (true) {
            if (this.state == State.NOT_STARTED) {
                Thread.sleep(10L);
                continue;
            }
            this.liveLock.acquire();
            if (this.state == State.PAUSED) {
                this.liveLock.release();
                Thread.sleep(10L);
                continue;
            }
            if (this.state == State.FAILING_BACK) {
                this.liveLock.release();
                Thread.sleep(10L);
                continue;
            }
            if (this.state == State.LIVE) break;
        }
        if (this.failoverPause > 0L) {
            Thread.sleep(this.failoverPause);
        }
    }

    @Override
    public void awaitLiveStatus() throws InterruptedException {
        while (this.state != State.LIVE) {
            Thread.sleep(10L);
        }
    }

    @Override
    public void startBackup() throws InterruptedException {
        this.backupLock.acquire();
    }

    @Override
    public ActivateCallback startLiveNode() throws InterruptedException {
        this.state = State.FAILING_BACK;
        this.liveLock.acquire();
        return new CleaningActivateCallback(){

            @Override
            public void activationComplete() {
                InVMNodeManager.this.state = State.LIVE;
            }
        };
    }

    @Override
    public void pauseLiveServer() {
        this.state = State.PAUSED;
        this.liveLock.release();
    }

    @Override
    public void crashLiveServer() {
        this.liveLock.release();
    }

    @Override
    public boolean isAwaitingFailback() {
        return this.state == State.FAILING_BACK;
    }

    @Override
    public boolean isBackupLive() {
        return this.liveLock.availablePermits() == 0;
    }

    @Override
    public void interrupt() {
    }

    @Override
    public void releaseBackup() {
        this.backupLock.release();
    }

    @Override
    public SimpleString readNodeId() {
        return this.getNodeId();
    }

    public static enum State {
        LIVE,
        PAUSED,
        FAILING_BACK,
        NOT_STARTED;

    }
}

