/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.importer;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.server.api.importer.ImportSource;
import com.xebialabs.deployit.server.api.importer.ImportedPackage;
import com.xebialabs.deployit.server.api.importer.ImportingContext;
import com.xebialabs.deployit.server.api.importer.ListableImporter;
import com.xebialabs.deployit.server.api.importer.PackageInfo;
import com.xebialabs.deployit.service.importer.PackageScanner;
import com.xebialabs.deployit.service.importer.reader.ManifestReaderDriver;
import com.xebialabs.deployit.service.importer.reader.XmlManifestReader;
import java.io.File;
import java.util.List;

public class XmlManifestDarImporter
implements ListableImporter {
    private static final String DRIVER = "driver";
    private RepositoryService repositoryService;

    public XmlManifestDarImporter(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public List<String> list(File directory) {
        return Lists.newArrayList(PackageScanner.scan(directory, (Predicate<File>)((Predicate)PackageScanner::isXmlManifestPackage)));
    }

    public boolean canHandle(ImportSource source) {
        File file = source.getFile();
        return PackageScanner.isXmlManifestPackage(file);
    }

    public PackageInfo preparePackage(ImportSource source, ImportingContext context) {
        ManifestReaderDriver manifestReaderDriver = new ManifestReaderDriver(source, new XmlManifestReader(source));
        context.setAttribute(DRIVER, (Object)manifestReaderDriver);
        return manifestReaderDriver.readPackageInfo(context);
    }

    public ImportedPackage importEntities(PackageInfo packageInfo, ImportingContext context) {
        ManifestReaderDriver driver = (ManifestReaderDriver)context.getAttribute(DRIVER);
        ImportedPackage importedPackage = driver.readDeploymentPackage(packageInfo, context);
        driver.resolveReferences(this.repositoryService, context);
        return importedPackage;
    }

    public void cleanUp(PackageInfo packageInfo, ImportingContext context) {
        ((ManifestReaderDriver)context.getAttribute(DRIVER)).cleanUp(packageInfo, context);
        context.setAttribute(DRIVER, null);
    }
}

